/*
 * Decompiled with CFR 0.152.
 */
package common;

public class PatchHelper {
    public static final String PATCHES_MARKER = "ThisIsThePatchData";
    public static final String PATCHES_PREFIX = "PATCHES:";
    public static final int MAX_PATCHES = 4;
    public static final int PATCH_RULE_LENGTH = 624;
    public static final int MAX_LIBRARY_LENGTH = 260;
    public static final int MAX_FUNCTION_LENGTH = 256;
    public static final int MAX_OFFSET = 65535;
    public static final int MAX_PATCH_HEX_LENGTH = 200;

    public static final boolean validatePatches(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Patches argument has no patches specified.");
        }
        if (stringArray.length > 4) {
            throw new IllegalArgumentException("Patches argument has more than 4 patches.");
        }
        int n = 0;
        for (String string2 : stringArray) {
            ++n;
            PatchHelper.validatePatch(string2, n);
        }
        return true;
    }

    public static final boolean validatePatch(String string, int n) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 4) {
            throw new IllegalArgumentException("Patch #" + n + " does not have 4 patch arguments.");
        }
        if (stringArray[0].length() == 0) {
            throw new IllegalArgumentException("Patch #" + n + " library name is not specified.");
        }
        if (stringArray[0].length() > 260) {
            throw new IllegalArgumentException("Patch #" + n + " library name is longer than " + 260 + ".");
        }
        if (stringArray[1].length() == 0) {
            throw new IllegalArgumentException("Patch #" + n + " function name is not specified.");
        }
        if (stringArray[1].length() > 256) {
            throw new IllegalArgumentException("Patch #" + n + " function name is longer than " + 256 + ".");
        }
        try {
            int n2 = Integer.parseInt(stringArray[2]);
            if (n2 < 0 || n2 > 65535) {
                throw new IllegalArgumentException("Patch #" + n + " offset must be 0-" + 65535 + ".");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Patch #" + n + " offset is not a valid number (0-" + 65535 + ").");
        }
        if (stringArray[3].length() == 0) {
            throw new IllegalArgumentException("Patch #" + n + " value is not specified.");
        }
        if (stringArray[3].length() > 200) {
            throw new IllegalArgumentException("Patch #" + n + " value is longer than " + 200 + " hex characters.");
        }
        if (stringArray[3].length() % 2 != 0) {
            throw new IllegalArgumentException("Patch #" + n + " value must have an even number of hex characters.");
        }
        if (!stringArray[3].matches("[0-9A-F]+")) {
            throw new IllegalArgumentException("Patch #" + n + " value can only contain hex characters (0-9,A-F).");
        }
        return true;
    }
}

