/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.Informant;
import common.Loggable;
import common.Scriptable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class PhishEvent
implements Serializable,
Scriptable,
Loggable,
Informant {
    protected LinkedList variables = new LinkedList();
    protected long when = System.currentTimeMillis();
    protected String evname;
    protected String sid;
    protected String desc;
    protected Map info = null;

    public PhishEvent(String string, String string2, LinkedList linkedList, String string3, Map map2) {
        this.variables = new LinkedList(linkedList);
        this.sid = string;
        this.evname = string2;
        this.desc = string3;
        this.info = map2;
    }

    @Override
    public Stack eventArguments() {
        Stack<Scalar> stack = new Stack<Scalar>();
        for (Object e : this.variables) {
            if (e == null) {
                stack.add(0, SleepUtils.getEmptyScalar());
                continue;
            }
            if (e instanceof Map) {
                stack.add(0, SleepUtils.getHashWrapper((Map)e));
                continue;
            }
            if (e instanceof Long) {
                stack.add(0, SleepUtils.getScalar((Long)e));
                continue;
            }
            stack.add(0, SleepUtils.getScalar(e.toString()));
        }
        return stack;
    }

    @Override
    public String eventName() {
        return this.evname;
    }

    @Override
    public String getBeaconId() {
        return null;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(CommonUtils.formatLogDate(this.when));
        dataOutputStream.writeBytes(" ");
        dataOutputStream.writeBytes(this.desc + "\n");
    }

    @Override
    public String getLogFile() {
        return "campaign_" + this.sid + ".log";
    }

    @Override
    public String getLogFolder() {
        return "phishes";
    }

    @Override
    public long getLogLimit() {
        return 0L;
    }

    @Override
    public String getLogEventName() {
        return "Phish Event";
    }

    @Override
    public boolean hasInformation() {
        return this.info != null;
    }

    @Override
    public Map archive() {
        return this.info;
    }
}

