/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;

public class PivotHint {
    public static final long HINT_REVERSE = 65536L;
    public static final long HINT_FORWARD = 0L;
    public static final long HINT_PROTO_PIPE = 0L;
    public static final long HINT_PROTO_TCP = 0x100000L;
    protected int hint;

    public PivotHint(int n) {
        this.hint = n;
    }

    public PivotHint(String string) {
        this.hint = CommonUtils.toNumber(string, 0);
    }

    public int getPort() {
        return this.hint & 0xFFFF;
    }

    public boolean isReverse() {
        return ((long)this.hint & 0x10000L) == 65536L;
    }

    public boolean isForward() {
        return !this.isReverse();
    }

    public boolean isTCP() {
        return ((long)this.hint & 0x100000L) == 0x100000L;
    }

    public String getProtocol() {
        if (this.isTCP()) {
            return "TCP";
        }
        return "SMB";
    }

    public String toString() {
        if (this.isForward()) {
            return this.getPort() + ", " + this.getProtocol() + " (FWD)";
        }
        return this.getPort() + ", " + this.getProtocol() + " (RVR)";
    }
}

