/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.Starter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class Requirements
extends Starter {
    public static void recommended() {
    }

    private static Set A() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        HashSet<String> hashSet = new HashSet<String>(list);
        return hashSet;
    }

    private static String A(boolean bl) {
        if (bl) {
            if ("1.6".equals(System.getProperty("java.specification.version"))) {
                return "Java 1.6 is not supported. Please upgrade to Java 1.7 or later.";
            }
            if (bl && "1.8".equals(System.getProperty("java.specification.version")) && CommonUtils.isin("OpenJDK", System.getProperty("java.runtime.name"))) {
                return "OpenJDK 1.8 is not supported. Use Oracle Java 8 or OpenJDK 11 (or later.)";
            }
            Set set = Requirements.A();
            if (!set.contains("-XX:+AggressiveHeap")) {
                return "Java -XX:+AggressiveHeap option not set. Use the Cobalt Strike launcher. Don't click the .jar file!";
            }
            if (!set.contains("-XX:+UseParallelGC")) {
                return "Java -XX:+UseParallelGC option not set. Use the Cobalt Strike launcher. Don't click the .jar file!";
            }
        }
        return null;
    }

    public static void checkGUI() {
        String string;
        Requirements.recommended();
        String string2 = Requirements.A(true);
        if (string2 != null) {
            JOptionPane.showMessageDialog(null, string2, null, 0);
            CommonUtils.print_error(string2);
            System.exit(0);
        }
        if ("wayland".equals(string = System.getenv("XDG_SESSION_TYPE"))) {
            CommonUtils.print_warn("You are using a Wayland desktop and not X11. Graphical Java applications run on Wayland are known to crash. You should use X11. See: https://www.cobaltstrike.com/help-wayland");
            JOptionPane.showInputDialog(null, "The Wayland desktop is not supported with Cobalt Strike.\nMore information:", null, 2, null, null, "https://www.cobaltstrike.com/help-wayland");
        }
        Requirements requirements = new Requirements();
        requirements.initializeStarter(requirements.getClass());
    }

    public static void checkConsole() {
        Requirements.recommended();
        String string = Requirements.A(false);
        if (string != null) {
            CommonUtils.print_error(string);
            System.exit(0);
        }
    }
}

