/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.TeamServerProps;
import common.CommonUtils;
import common.HasUUID;
import common.Loggable;
import common.ScriptUtils;
import common.ToScalar;
import common.Transcript;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import sleep.runtime.Scalar;

public class Screenshot
implements Serializable,
Transcript,
Loggable,
ToScalar,
HasUUID {
    protected String when;
    protected String bid;
    protected transient byte[] data;
    protected String user;
    protected int desktop;
    protected String computer;
    protected String title;
    protected String id;
    protected long size;
    protected static final long serialVersionUID = 1L;
    private static final SimpleDateFormat B = new SimpleDateFormat("hhmmss");

    public Screenshot(String string, byte[] byArray, String string2, String string3, int n, String string4) {
        this.bid = string;
        this.data = (byte[])byArray.clone();
        this.user = string2;
        this.computer = string3;
        this.desktop = n;
        this.title = string4;
        this.when = System.currentTimeMillis() + "";
        this.id = CommonUtils.ID();
    }

    @Override
    public String ID() {
        return this.id;
    }

    public String getWindowTitle() {
        return this.title;
    }

    public String getUser() {
        return this.user;
    }

    public int getDesktopSession() {
        return this.desktop;
    }

    public String toString() {
        return "screenshot from beacon id: " + this.bid;
    }

    public String time() {
        return this.when + "";
    }

    @Override
    public String getBeaconId() {
        return this.bid;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        if (this.data != null) {
            dataOutputStream.write(this.data);
            this.data = null;
        }
    }

    @Override
    public String getLogFile() {
        return "screen_" + this.id.substring(0, 8) + "_" + this.bid + ".jpg";
    }

    @Override
    public String getLogFolder() {
        return "screenshots";
    }

    @Override
    public long getLogLimit() {
        long l = TeamServerProps.getPropsFile().getLongNumber("limits.screenshot_diskused_percent", 95L);
        return l;
    }

    @Override
    public String getLogEventName() {
        return "Screenshot";
    }

    public Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", this.id);
        hashMap.put("when", this.when);
        hashMap.put("title", this.title);
        hashMap.put("user", this.user);
        hashMap.put("session", this.desktop);
        hashMap.put("bid", this.bid);
        hashMap.put("computer", this.computer);
        return hashMap;
    }

    @Override
    public Scalar toScalar() {
        Map map2 = this.toMap();
        return ScriptUtils.convertAll(map2);
    }

    static {
        B.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

