/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.Loggable;
import common.Screenshot;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ScreenshotEvent
implements Serializable,
Loggable {
    protected String when;
    protected String bid;
    protected String user;
    protected int desktop;
    protected String computer;
    protected String title;
    protected String id;
    protected String file;

    public ScreenshotEvent(Screenshot screenshot) {
        this.title = screenshot.title;
        this.bid = screenshot.bid;
        this.user = screenshot.user;
        this.desktop = screenshot.desktop;
        this.computer = screenshot.computer;
        this.title = screenshot.title;
        this.id = screenshot.id;
        this.file = screenshot.getLogFile();
        this.when = screenshot.when;
    }

    public String toString() {
        return "screenshot: " + this.title;
    }

    @Override
    public String getBeaconId() {
        return this.bid;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CommonUtils.formatLogDate(Long.parseLong(this.when)));
        stringBuffer.append("\t");
        stringBuffer.append(this.computer);
        stringBuffer.append("\t");
        stringBuffer.append(this.desktop);
        stringBuffer.append("\t");
        stringBuffer.append(this.user);
        stringBuffer.append("\t");
        stringBuffer.append(this.file);
        stringBuffer.append("\t");
        stringBuffer.append(this.title);
        stringBuffer.append("\n");
        CommonUtils.writeUTF8(dataOutputStream, stringBuffer.toString());
    }

    @Override
    public String getLogFile() {
        return "screenshots.log";
    }

    @Override
    public String getLogFolder() {
        return null;
    }

    @Override
    public long getLogLimit() {
        return 0L;
    }

    @Override
    public String getLogEventName() {
        return "Screenshot Event";
    }
}

