/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BeaconEntry;
import common.CommonUtils;
import common.Scriptable;
import common.ToScalar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.ObjectUtilities;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.SleepUtils;

public class ScriptUtils {
    public static Scalar toSleepArray(Object[] objectArray) {
        return SleepUtils.getArrayWrapper(CommonUtils.toList(objectArray));
    }

    public static String[] toStringArray(ScalarArray scalarArray) {
        int n = 0;
        String[] stringArray = new String[scalarArray.size()];
        Iterator iterator = scalarArray.scalarIterator();
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next() + "";
            ++n;
        }
        return stringArray;
    }

    public static Stack scalar(String string) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(string));
        return stack;
    }

    public static Scalar convertAll(Object object) {
        if (object instanceof Collection) {
            Scalar scalar = SleepUtils.getArrayScalar();
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                scalar.getArray().push(ScriptUtils.convertAll(iterator.next()));
            }
            return scalar;
        }
        if (object instanceof Map) {
            Scalar scalar = SleepUtils.getHashScalar();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Scalar scalar2 = SleepUtils.getScalar(entry.getKey() + "");
                Scalar scalar3 = scalar.getHash().getAt(scalar2);
                scalar3.setValue(ScriptUtils.convertAll(entry.getValue()));
            }
            return scalar;
        }
        if (object instanceof BeaconEntry) {
            return ScriptUtils.convertAll(((BeaconEntry)object).toMap());
        }
        if (object instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)object;
            Scalar scalar = SleepUtils.getArrayScalar();
            scalar.getArray().push(SleepUtils.getScalar(scriptable.eventName()));
            Stack stack = scriptable.eventArguments();
            while (!stack.isEmpty()) {
                scalar.getArray().push((Scalar)stack.pop());
            }
            return scalar;
        }
        if (object instanceof ToScalar) {
            return ((ToScalar)object).toScalar();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                linkedList.add(objectArray[i]);
            }
            return ScriptUtils.convertAll(linkedList);
        }
        return ObjectUtilities.BuildScalar(true, object);
    }

    public static String[] ArrayOrString(Stack stack) {
        if (stack.isEmpty()) {
            return new String[0];
        }
        Scalar scalar = (Scalar)stack.peek();
        if (scalar.getArray() != null) {
            return CommonUtils.toStringArray(BridgeUtilities.getArray(stack));
        }
        return new String[]{((Scalar)stack.pop()).stringValue()};
    }

    public static Scalar IndexOrMap(Map map2, Stack stack) {
        if (stack.isEmpty()) {
            return SleepUtils.getHashWrapper(map2);
        }
        String string = BridgeUtilities.getString(stack, "");
        return CommonUtils.convertAll(map2.get(string));
    }

    public static Stack StringToArguments(String string) {
        Stack<Scalar> stack = new Stack<Scalar>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (stringBuffer.length() > 0) {
                    stack.add(0, SleepUtils.getScalar(stringBuffer.toString()));
                }
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '\"' && stringBuffer.length() == 0) {
                ++i;
                while (i < string.length() && string.charAt(i) != '\"') {
                    stringBuffer.append(string.charAt(i));
                    ++i;
                }
                stack.add(0, SleepUtils.getScalar(stringBuffer.toString()));
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            stack.add(0, SleepUtils.getScalar(stringBuffer.toString()));
        }
        stack.pop();
        return stack;
    }
}

