/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringStack {
    protected String string;
    protected String delimeter;

    public StringStack(String string) {
        this(string, " ");
    }

    public StringStack(String string, String string2) {
        this.string = string;
        this.delimeter = string2;
    }

    public List toList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringStack stringStack = new StringStack(this.string, this.delimeter);
        while (!stringStack.isEmpty()) {
            linkedList.add(stringStack.shift());
        }
        return linkedList;
    }

    public void push(String string) {
        this.string = this.string.length() > 0 ? this.string + this.delimeter + string : string;
    }

    public int length() {
        return this.string.length();
    }

    public boolean isEmpty() {
        return this.string.length() == 0;
    }

    public String peekFirst() {
        if (this.string.indexOf(this.delimeter) > -1) {
            String string = this.string.substring(0, this.string.indexOf(this.delimeter));
            return string;
        }
        return this.string;
    }

    public String shift() {
        if (this.string.indexOf(this.delimeter) > -1) {
            String string = this.string.substring(0, this.string.indexOf(this.delimeter));
            if (string.length() >= this.string.length()) {
                this.string = "";
                return string;
            }
            this.string = this.string.substring(string.length() + 1, this.string.length());
            return string;
        }
        String string = this.string;
        this.string = "";
        return string;
    }

    public String shiftStringCanBeSingleOrDoubleQuoted() {
        Matcher matcher = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'").matcher(this.string);
        if (matcher.find()) {
            Boolean bl = false;
            String string = "";
            if (matcher.group(1) != null) {
                bl = true;
                string = matcher.group(1);
            } else if (matcher.group(2) != null) {
                bl = true;
                string = matcher.group(2);
            } else {
                bl = false;
                string = matcher.group();
            }
            int n = string.length();
            if (bl.booleanValue()) {
                n += 2;
            }
            if (n >= this.string.length()) {
                this.string = "";
                return string;
            }
            this.string = this.string.substring(n + 1, this.string.length());
            return string;
        }
        String string = this.string;
        this.string = "";
        return string;
    }

    public String pop() {
        int n = this.string.lastIndexOf(this.delimeter);
        if (n > -1) {
            String string = this.string.substring(n + 1, this.string.length());
            this.string = this.string.substring(0, n);
            return string;
        }
        String string = this.string;
        this.string = "";
        return string;
    }

    public String toString() {
        return this.string;
    }

    public void setDelimeter(String string) {
        this.delimeter = string;
    }
}

