/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Loggable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TabScreenshot
implements Serializable,
Loggable {
    protected long when;
    protected byte[] data;
    protected String who = null;
    protected String title = null;
    private static final SimpleDateFormat A = new SimpleDateFormat("hhmmss");

    public TabScreenshot(String string, byte[] byArray) {
        this.title = string;
        this.data = byArray;
    }

    public void touch(String string) {
        this.when = System.currentTimeMillis();
        this.who = string;
    }

    public String toString() {
        return "screenshot: " + this.title;
    }

    @Override
    public String getBeaconId() {
        return null;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.data);
    }

    @Override
    public String getLogFile() {
        Date date = new Date(this.when);
        String string = A.format(date);
        return string + "_" + this.title.replaceAll("[^a-zA-Z0-9\\.]", "") + ".png";
    }

    @Override
    public String getLogFolder() {
        return "screenshots/" + this.who.replaceAll("[^a-zA-Z0-9]", "");
    }

    @Override
    public long getLogLimit() {
        return 0L;
    }

    @Override
    public String getLogEventName() {
        return "Tab Screenshot";
    }

    static {
        A.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

