/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.Prefs;
import common.Callback;
import common.CommonUtils;
import common.DisconnectListener;
import common.MudgeSanity;
import common.Reply;
import common.Request;
import common.TeamSocket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class TeamQueue {
    protected TeamSocket socket;
    protected Map<Long, Callback> callbacks = new HashMap<Long, Callback>();
    protected long reqId = 0L;
    protected _B reader;
    protected _A writer;
    protected Callback subscriber = null;

    public TeamQueue(TeamSocket teamSocket) {
        this.socket = teamSocket;
        int n = CommonUtils.toNumber(Prefs.getPreferences().getString("connection.client.timeout", "30000"), 30000);
        try {
            this.socket.client.setSoTimeout(n);
        }
        catch (Exception exception) {
            MudgeSanity.logException("Unable to update the client's connection timeout to " + n, exception, false);
        }
        this.reader = new _B();
        this.writer = new _A();
        new Thread((Runnable)this.writer, "TeamQueue Writer").start();
        new Thread((Runnable)this.reader, "TeamQueue Reader").start();
    }

    public void call(String string, Callback callback) {
        this.call(string, null, callback, false);
    }

    public void call(String string) {
        this.call(string, null, null, false);
    }

    public void call(String string, Object[] objectArray) {
        this.call(string, objectArray, null, false);
    }

    public void call(String string, Object[] objectArray, Callback callback) {
        this.call(string, objectArray, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String string, Object[] objectArray, Callback callback, boolean bl) {
        if (callback == null) {
            Request request = new Request(string, objectArray, 0L);
            this.writer.A(request);
        } else {
            TeamQueue teamQueue = this;
            synchronized (teamQueue) {
                ++this.reqId;
                this.callbacks.put(this.reqId, callback);
                Request request = new Request(string, objectArray, this.reqId, bl);
                this.writer.A(request);
            }
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void close() {
        this.socket.close();
    }

    public void addDisconnectListener(DisconnectListener disconnectListener) {
        this.socket.addDisconnectListener(disconnectListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscriber(Callback callback) {
        TeamQueue teamQueue = this;
        synchronized (teamQueue) {
            this.subscriber = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRead(Reply reply) {
        if (reply.hasCallback()) {
            Callback callback;
            TeamQueue teamQueue = this;
            synchronized (teamQueue) {
                callback = reply.getCallbackRemove() ? this.callbacks.remove(reply.getCallbackReference()) : this.callbacks.get(reply.getCallbackReference());
            }
            if (callback != null && reply.getContent() != null) {
                callback.result(reply.getCall(), reply.getContent());
            }
        } else {
            TeamQueue teamQueue = this;
            synchronized (teamQueue) {
                if (this.subscriber != null) {
                    this.subscriber.result(reply.getCall(), reply.getContent());
                }
            }
        }
    }

    private class _A
    implements Runnable {
        protected LinkedList<Request> B = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Request A() {
            _A _A2 = this;
            synchronized (_A2) {
                return this.B.pollFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void A(Request request) {
            _A _A2 = this;
            synchronized (_A2) {
                if (request.size() > 100000) {
                    this.B.removeFirst();
                }
                this.B.add(request);
            }
        }

        @Override
        public void run() {
            while (TeamQueue.this.socket.isConnected()) {
                Request request = this.A();
                if (request != null) {
                    TeamQueue.this.socket.writeObject(request);
                    Thread.yield();
                    continue;
                }
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    MudgeSanity.logException("team writer sleep", interruptedException, false);
                }
            }
        }
    }

    private class _B
    implements Runnable {
        @Override
        public void run() {
            try {
                while (TeamQueue.this.socket.isConnected()) {
                    Reply reply = (Reply)TeamQueue.this.socket.readObject();
                    if (reply == null) {
                        TeamQueue.this.close();
                        break;
                    }
                    TeamQueue.this.processRead(reply);
                    Thread.yield();
                }
            }
            catch (Exception exception) {
                MudgeSanity.logException("team reader", exception, false);
                TeamQueue.this.close();
            }
        }
    }
}

