/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Callback;
import common.CommonUtils;
import common.MudgeSanity;
import common.TeamQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ProgressMonitor;

public class UploadFile
implements Callback {
    protected FileInputStream in = null;
    protected byte[] buffer = new byte[262144];
    protected File file = null;
    protected TeamQueue conn = null;
    protected UploadNotify listener = null;
    protected long total;
    protected long start = System.currentTimeMillis();
    protected long read = 0L;
    protected long ret = 0L;
    protected long sofar = 0L;
    protected double time = 0.0;
    protected ProgressMonitor progress;

    public UploadFile(TeamQueue teamQueue, File file, UploadNotify uploadNotify) {
        this.file = file;
        this.listener = uploadNotify;
        this.conn = teamQueue;
    }

    @Override
    public void result(String string, Object object) {
        String string2 = object + "";
        try {
            if (this.sofar < this.total) {
                this.time = (double)(System.currentTimeMillis() - this.start) / 1000.0;
                this.progress.setProgress((int)this.sofar);
                this.progress.setNote("Speed: " + Math.round((double)(this.sofar / 1024L) / this.time) + " KB/s");
                if (this.progress.isCanceled()) {
                    this.progress.close();
                    this.in.close();
                    this.listener.cancel();
                    return;
                }
                if (string2.startsWith("ERROR: ")) {
                    this.progress.setNote(string2);
                    this.in.close();
                    return;
                }
                this.read = this.in.read(this.buffer);
                this.sofar += this.read;
                this.conn.call("armitage.append", CommonUtils.args(this.file.getName(), this.tailor(this.buffer, this.read)), this);
            } else {
                this.time = (double)(System.currentTimeMillis() - this.start) / 1000.0;
                this.progress.setProgress((int)this.sofar);
                this.progress.setNote("Speed: " + Math.round((double)(this.sofar / 1024L) / this.time) + " KB/s");
                this.progress.close();
                this.in.close();
                this.listener.complete(object + "");
            }
        }
        catch (Exception exception) {
            MudgeSanity.logException("upload" + this.sofar + "/" + this.total + " of " + this.file, exception, false);
            this.listener.cancel();
        }
    }

    public void start() {
        try {
            this.total = this.file.length();
            this.in = new FileInputStream(this.file);
            this.progress = new ProgressMonitor(null, "Upload " + this.file.getName(), "Starting upload", 0, (int)this.total);
            this.conn.call("armitage.upload", CommonUtils.args(this.file.getName()), this);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("upload start: " + this.file, iOException, false);
            this.listener.cancel();
        }
    }

    protected byte[] tailor(byte[] byArray, long l) {
        byte[] byArray2 = new byte[(int)l];
        int n = 0;
        while ((long)n < l) {
            byArray2[n] = byArray[n];
            ++n;
        }
        return byArray2;
    }

    public static interface UploadNotify {
        public void complete(String var1);

        public void cancel();
    }
}

