/*
 * Decompiled with CFR 0.152.
 */
package cortana;

import cortana.Cortana;
import cortana.Loader;
import cortana.core.CommandManager;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Loadable;

public class ConsoleInterface {
    protected Cortana engine = null;
    protected CommandManager commands = null;

    public ConsoleInterface(Cortana cortana) {
        this.engine = cortana;
        this.commands = new CommandManager();
    }

    public Loadable getBridge() {
        return this.commands.getBridge();
    }

    public List commandList(String string) {
        String[] stringArray = string.trim().split("\\s+");
        if ("reload".equals(stringArray[0]) || "pron".equals(stringArray[0]) || "profile".equals(stringArray[0]) || "proff".equals(stringArray[0]) || "tron".equals(stringArray[0]) || "unload".equals(stringArray[0]) || "troff".equals(stringArray[0])) {
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = this.engine.scripts.keySet().iterator();
            while (iterator.hasNext()) {
                linkedList.add(stringArray[0] + " " + new File(iterator.next() + "").getName());
            }
            Cortana.filterList(linkedList, string);
            Collections.sort(linkedList);
            return linkedList;
        }
        if ("load".equals(stringArray[0]) && string.length() > 5) {
            String string2 = string.substring(5);
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory()) {
                file = file.getParentFile();
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            if (file == null) {
                linkedList.add(string);
                return linkedList;
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() && !fileArray[i].getName().endsWith(".cna")) continue;
                linkedList.add(stringArray[0] + " " + fileArray[i].getAbsolutePath());
            }
            Cortana.filterList(linkedList, string);
            Collections.sort(linkedList);
            return linkedList;
        }
        List list = this.commands.commandList(string);
        list.add("help");
        list.add("history");
        list.add("ls");
        list.add("reload");
        list.add("unload");
        list.add("load");
        list.add("pron");
        list.add("proff");
        list.add("profile");
        list.add("tron");
        list.add("troff");
        list.add("!");
        Collections.sort(list);
        Cortana.filterList(list, string);
        return list;
    }

    public void processCommand(final String string) {
        final String[] stringArray = string.trim().split("\\s+");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("tron");
        hashSet.add("troff");
        hashSet.add("profile");
        hashSet.add("pron");
        hashSet.add("proff");
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.addAll(hashSet);
        hashSet2.add("unload");
        hashSet2.add("load");
        hashSet2.add("reload");
        if ("ls".equals(string)) {
            this.engine.p("");
            this.engine.p("Scripts");
            this.engine.pdark("-------");
            for (String string2 : this.engine.scripts.keySet()) {
                if (string2 == null) continue;
                File file = new File(string2);
                this.engine.p(file.getName());
            }
            this.engine.p("");
        } else if (hashSet2.contains(stringArray[0]) && stringArray.length != 2) {
            this.engine.perror("Missing arguments");
        } else if (hashSet.contains(stringArray[0]) && stringArray.length == 2) {
            String string3 = this.engine.findScript(stringArray[1]);
            if (string3 == null) {
                this.engine.perror("Could not find '" + stringArray[1] + "'");
            } else {
                Loader loader = (Loader)this.engine.scripts.get(string3);
                if ("tron".equals(stringArray[0])) {
                    this.engine.pgood("Tracing '" + stringArray[1] + "'");
                    loader.setDebugLevel(8);
                } else if ("troff".equals(stringArray[0])) {
                    this.engine.pgood("Stopped trace of '" + stringArray[1] + "'");
                    loader.unsetDebugLevel(8);
                } else if ("pron".equals(stringArray[0])) {
                    this.engine.pgood("Profiling '" + stringArray[1] + "'");
                    loader.setDebugLevel(24);
                } else if ("profile".equals(stringArray[0]) || "proff".equals(stringArray[0])) {
                    if ("proff".equals(stringArray[0])) {
                        this.engine.pgood("Stopped profile of '" + stringArray[1] + "'");
                        loader.unsetDebugLevel(24);
                    }
                    this.engine.p("");
                    this.engine.p("Profile " + stringArray[1]);
                    this.engine.pdark("-------");
                    loader.printProfile(this.engine.cortana_io.getOutputStream());
                    this.engine.p("");
                }
            }
        } else if ("unload".equals(stringArray[0]) && stringArray.length == 2) {
            String string4 = this.engine.findScript(stringArray[1]);
            if (string4 == null) {
                this.engine.perror("Could not find '" + stringArray[1] + "'");
            } else {
                this.engine.pgood("Unload " + string4);
                this.engine.unloadScript(string4);
            }
        } else if ("load".equals(stringArray[0]) && stringArray.length == 2) {
            this.engine.pgood("Load " + stringArray[1]);
            try {
                this.engine.loadScript(stringArray[1]);
            }
            catch (YourCodeSucksException yourCodeSucksException) {
                this.engine.p(yourCodeSucksException.formatErrors());
            }
            catch (Exception exception) {
                this.engine.perror("Could not load: " + exception.getMessage());
            }
        } else if ("reload".equals(stringArray[0]) && stringArray.length == 2) {
            String string5 = this.engine.findScript(stringArray[1]);
            if (string5 == null) {
                this.engine.perror("Could not find '" + stringArray[1] + "'");
            } else {
                this.engine.pgood("Reload " + string5);
                try {
                    this.engine.unloadScript(string5);
                    this.engine.loadScript(string5);
                }
                catch (IOException iOException) {
                    this.engine.perror("Could not load: '" + stringArray[1] + "' " + iOException.getMessage());
                }
                catch (YourCodeSucksException yourCodeSucksException) {
                    this.engine.p(yourCodeSucksException.formatErrors());
                }
            }
        } else if ("help".equals(string)) {
            this.engine.p("");
            this.engine.p("Commands");
            this.engine.pdark("--------");
            Iterator iterator = this.commandList("").iterator();
            while (iterator.hasNext()) {
                this.engine.p(iterator.next() + "");
            }
            this.engine.p("");
        } else if (this.engine.getScriptableApplication().isHeadless()) {
            if (!this.commands.fireCommand(stringArray[0], string)) {
                this.engine.perror("Command not found");
            }
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!ConsoleInterface.this.commands.fireCommand(stringArray[0], string)) {
                        ConsoleInterface.this.engine.perror("Command not found");
                    }
                }
            }, "cortana command: " + stringArray[0]).start();
        }
    }
}

