/*
 * Decompiled with CFR 0.152.
 */
package cortana.gui;

import cortana.core.EventManager;
import cortana.gui.MenuBuilder;
import cortana.gui.ScriptableApplication;
import cortana.gui.ScriptedMenu;
import cortana.gui.ScriptedMenuItem;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.interfaces.Environment;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import ui.DynamicMenu;

public class MenuBridge
implements Loadable,
Function,
Environment {
    protected Stack parents = new Stack();
    protected Map menus = new HashMap();
    protected Stack data = new Stack();
    protected ScriptableApplication application;
    protected MenuBuilder builder = null;

    public Stack getArguments() {
        return (Stack)this.data.peek();
    }

    public MenuBridge(ScriptableApplication scriptableApplication, MenuBuilder menuBuilder) {
        this.application = scriptableApplication;
        this.builder = menuBuilder;
    }

    public void push(JComponent jComponent, Stack stack) {
        this.parents.push(jComponent);
        this.data.push(stack);
    }

    public void pop() {
        this.parents.pop();
        this.data.pop();
    }

    public JComponent getTopLevel() {
        if (this.parents.isEmpty()) {
            throw new RuntimeException("menu has no parent");
        }
        return (JComponent)this.parents.peek();
    }

    @Override
    public void bindFunction(ScriptInstance scriptInstance, String string, String string2, Block block) {
        SleepClosure sleepClosure = new SleepClosure(scriptInstance, block);
        if (string.equals("menu")) {
            this.createMenu(string2, sleepClosure);
        } else if (string.equals("item")) {
            this.createItem(string2, sleepClosure);
        } else if (string.equals("popup")) {
            this.registerTopLevel(string2, sleepClosure);
        }
    }

    public void registerTopLevel(String string, SleepClosure sleepClosure) {
        if (!this.menus.containsKey(string)) {
            this.menus.put(string, new LinkedList());
        }
        LinkedList linkedList = (LinkedList)this.menus.get(string);
        linkedList.add(sleepClosure);
    }

    public void clearTopLevel(String string) {
        this.menus.remove(string);
    }

    public boolean isPopulated(String string) {
        return this.menus.containsKey(string) && ((LinkedList)this.menus.get(string)).size() > 0;
    }

    public LinkedList getMenus(String string) {
        if (this.menus.containsKey(string)) {
            return (LinkedList)this.menus.get(string);
        }
        return new LinkedList();
    }

    public void createMenu(String string, SleepClosure sleepClosure) {
        JComponent jComponent = this.getTopLevel();
        ScriptedMenu scriptedMenu = new ScriptedMenu(string, sleepClosure, this);
        jComponent.add(scriptedMenu);
    }

    public void createItem(String string, SleepClosure sleepClosure) {
        JComponent jComponent = this.getTopLevel();
        ScriptedMenuItem scriptedMenuItem = new ScriptedMenuItem(string, sleepClosure, this);
        jComponent.add(scriptedMenuItem);
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&separator")) {
            if (this.getTopLevel() instanceof JMenu) {
                ((JMenu)this.getTopLevel()).addSeparator();
            } else if (this.getTopLevel() instanceof JPopupMenu) {
                ((JPopupMenu)this.getTopLevel()).addSeparator();
            }
        } else if (string.equals("&show_menu")) {
            String string2 = BridgeUtilities.getString(stack, "");
            if (stack.size() > 0) {
                this.builder.setupMenu(this.getTopLevel(), string2, EventManager.shallowCopy(stack));
            } else {
                this.builder.setupMenu(this.getTopLevel(), string2, this.getArguments());
            }
        } else if (string.equals("&show_popup")) {
            MouseEvent mouseEvent = (MouseEvent)BridgeUtilities.getObject(stack);
            String string3 = BridgeUtilities.getString(stack, "");
            JPopupMenu jPopupMenu = new JPopupMenu();
            this.push(jPopupMenu, EventManager.shallowCopy(stack));
            this.builder.setupMenu(this.getTopLevel(), string3, this.getArguments());
            this.pop();
            jPopupMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        } else if (string.equals("&insert_menu")) {
            String string4 = BridgeUtilities.getString(stack, "");
            this.push(this.getTopLevel(), EventManager.shallowCopy(stack));
            this.builder.setupMenu(this.getTopLevel(), string4, this.getArguments());
            this.pop();
        } else if (string.equals("&insert_component")) {
            Object object = BridgeUtilities.getObject(stack);
            if (this.getTopLevel() instanceof JMenu) {
                ((JMenu)this.getTopLevel()).add((JComponent)object);
            } else if (this.getTopLevel() instanceof JPopupMenu) {
                ((JPopupMenu)this.getTopLevel()).add((JComponent)object);
            }
        } else if (string.equals("&menubar")) {
            String string5 = BridgeUtilities.getString(stack, "");
            final String string6 = BridgeUtilities.getString(stack, "");
            int n = BridgeUtilities.getInt(stack, 2);
            DynamicMenu dynamicMenu = new DynamicMenu("");
            if (string5.indexOf(38) > -1) {
                dynamicMenu.setText(string5.substring(0, string5.indexOf(38)) + string5.substring(string5.indexOf(38) + 1, string5.length()));
                dynamicMenu.setMnemonic(string5.charAt(string5.indexOf(38) + 1));
            } else {
                dynamicMenu.setText(string5);
            }
            dynamicMenu.setHandler(new DynamicMenu.DynamicMenuHandler(){

                @Override
                public void setupMenu(JMenu jMenu) {
                    MenuBridge.this.builder.setupMenu(jMenu, string6, new Stack());
                    if (!MenuBridge.this.isPopulated(string6)) {
                        MenuBridge.this.application.getJMenuBar().remove(jMenu);
                        MenuBridge.this.application.getJMenuBar().validate();
                    }
                }
            });
            MenuElement[] menuElementArray = this.application.getJMenuBar().getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                JMenu jMenu = (JMenu)menuElementArray[i].getComponent();
                if (!jMenu.getText().equals(dynamicMenu.getText())) continue;
                this.application.getJMenuBar().remove(jMenu);
            }
            this.application.getJMenuBar().add(dynamicMenu);
            this.application.getJMenuBar().validate();
        } else if (string.equals("&popup_clear")) {
            String string7 = BridgeUtilities.getString(stack, "");
            this.clearTopLevel(string7);
        } else {
            String string8 = BridgeUtilities.getString(stack, "");
            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
            if (string.equals("&menu")) {
                this.createMenu(string8, sleepClosure);
            } else if (string.equals("&item")) {
                this.createItem(string8, sleepClosure);
            } else if (string.equals("&popup")) {
                this.registerTopLevel(string8, sleepClosure);
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("popup", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&popup", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("menu", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&menu", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("item", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&item", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&separator", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&menubar", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&show_menu", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&insert_menu", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&show_popup", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&popup_clear", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&insert_component", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }
}

