/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.JTextComponent;

public class TextFieldStyle
extends StyleWrapper {
    private static TextFieldStyle instance = new TextFieldStyle();

    private TextFieldStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null && ((JTextComponent)jComponent).isEditable()) {
            instance.setStyle(synthStyle);
            return instance;
        }
        TextFieldStyle textFieldStyle = new TextFieldStyle();
        textFieldStyle.setStyle(synthStyle);
        return textFieldStyle;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        String string = synthContext.getComponent().getName();
        if ("ComboBox.textField".equals(string)) {
            return new Insets(0, 1, 0, 1);
        }
        return this.synthStyle.getInsets(synthContext, insets);
    }

    public Color getColorForState(SynthContext synthContext, ColorType colorType) {
        JComponent jComponent = synthContext.getComponent();
        if (colorType == ColorType.TEXT_FOREGROUND && jComponent.getForeground() instanceof ColorUIResource && !((JTextComponent)jComponent).isEditable()) {
            Color color = SyntheticaLookAndFeel.getColor("Synthetica.textField.locked.textColor", jComponent);
            return color == null ? super.getColorForState(synthContext, colorType) : color;
        }
        return super.getColorForState(synthContext, colorType);
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        JComponent jComponent = synthContext.getComponent();
        Color color = jComponent.getBackground();
        if (((Component)jComponent).isOpaque() && color != null && !(color instanceof UIResource) && colorType == ColorType.BACKGROUND) {
            return color;
        }
        return super.getColor(synthContext, colorType);
    }
}

