/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class FontDialog
implements ItemListener,
DialogListener {
    protected Font font;
    protected JLabel preview;
    protected JComboBox size;
    protected JComboBox family;
    protected JComboBox style;
    protected LinkedList listeners = new LinkedList();
    protected JFrame dialog;

    public FontDialog(Font font) {
        this.font = font;
    }

    public void addFontChooseListener(SafeDialogCallback safeDialogCallback) {
        this.listeners.add(safeDialogCallback);
    }

    public JComboBox act(DialogManager.DialogRow dialogRow) {
        JComboBox jComboBox = (JComboBox)dialogRow.c[1];
        jComboBox.addItemListener(this);
        return jComboBox;
    }

    public String getResult() {
        return this.family.getSelectedItem() + "-" + this.style.getSelectedItem().toString().toUpperCase() + "-" + this.size.getSelectedItem();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Font font = Font.decode(this.getResult());
        this.preview.setFont(font);
        this.preview.revalidate();
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        for (SafeDialogCallback safeDialogCallback : this.listeners) {
            safeDialogCallback.dialogResult(this.getResult());
        }
        this.dialog.dispose();
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Choose a font", 640, 240);
        this.dialog.setLayout(new BorderLayout());
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.set("size", this.font.getSize() + "");
        dialogManager.set("family", this.font.getFamily());
        String string = "Plain";
        if (this.font.isItalic()) {
            string = "Italic";
        } else if (this.font.isBold()) {
            string = "Bold";
        }
        dialogManager.set("style", string);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.family = this.act(dialogManager.combobox("family", "Family", graphicsEnvironment.getAvailableFontFamilyNames()));
        this.style = this.act(dialogManager.combobox("style", "Style", CommonUtils.toArray("Bold, Italic, Plain")));
        this.size = this.act(dialogManager.combobox("size", "Size", CommonUtils.toArray("5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 20, 23, 26, 30, 33, 38")));
        this.preview = new JLabel("This is Example text 1234+& \u8089\u9e21");
        this.preview.setFont(this.font);
        this.preview.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.preview.setOpaque(true);
        JButton jButton = dialogManager.action("Choose");
        this.dialog.add((Component)dialogManager.layout(), "North");
        this.dialog.add((Component)this.preview, "Center");
        this.dialog.add((Component)DialogUtils.center(jButton), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
        this.dialog.show();
    }
}

