/*
 * Decompiled with CFR 0.152.
 */
package encoders;

import common.CommonUtils;
import common.Packer;

public class Transforms {
    public static byte[] toVeil(byte[] byArray) {
        Packer packer = new Packer();
        for (int i = 0; i < byArray.length; ++i) {
            packer.addString("\\x");
            String string = Integer.toString(byArray[i] & 0xFF, 16);
            if (string.length() == 2) {
                packer.addString(string);
                continue;
            }
            packer.addString("0" + string);
        }
        return packer.getBytes();
    }

    public static String toArray(byte[] byArray) {
        Packer packer = new Packer();
        for (int i = 0; i < byArray.length; ++i) {
            packer.addString("0x");
            String string = Integer.toString(byArray[i] & 0xFF, 16);
            if (string.length() == 2) {
                packer.addString(string);
            } else {
                packer.addString("0" + string);
            }
            if (i >= byArray.length - 1) continue;
            packer.addString(", ");
        }
        return CommonUtils.bString(packer.getBytes());
    }

    public static byte[] toC(byte[] byArray) {
        Packer packer = new Packer();
        packer.addString("/* length: " + byArray.length + " bytes */\n");
        packer.addString("unsigned char buf[] = \"" + CommonUtils.bString(Transforms.toVeil(byArray)) + "\";\n");
        return packer.getBytes();
    }

    public static byte[] toPerl(byte[] byArray) {
        Packer packer = new Packer();
        packer.addString("# length: " + byArray.length + " bytes\n");
        packer.addString("$buf = \"" + CommonUtils.bString(Transforms.toVeil(byArray)) + "\";\n");
        return packer.getBytes();
    }

    public static byte[] toPython(byte[] byArray) {
        Packer packer = new Packer();
        packer.addString("# length: " + byArray.length + " bytes\n");
        packer.addString("buf = \"" + CommonUtils.bString(Transforms.toVeil(byArray)) + "\"\n");
        return packer.getBytes();
    }

    public static byte[] toJava(byte[] byArray) {
        Packer packer = new Packer();
        packer.addString("/* length: " + byArray.length + " bytes */\n");
        packer.addString("byte buf[] = new byte[] { " + Transforms.toArray(byArray) + " };\n");
        return packer.getBytes();
    }

    public static byte[] toCSharp(byte[] byArray) {
        Packer packer = new Packer();
        packer.addString("/* length: " + byArray.length + " bytes */\n");
        packer.addString("byte[] buf = new byte[" + byArray.length + "] { " + Transforms.toArray(byArray) + " };\n");
        return packer.getBytes();
    }

    public static String toVBA(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 10);
        stringBuffer.append("Array(");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            if (i > 0 && i % 40 == 0 && i + 1 < byArray.length) {
                stringBuffer.append(", _\n");
                continue;
            }
            if (i + 1 >= byArray.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

