/*
 * Decompiled with CFR 0.152.
 */
package encoders;

import common.CommonUtils;
import common.MudgeSanity;
import common.Packer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class XorEncoder {
    public static byte[] encode(byte[] byArray) {
        try {
            Packer packer = new Packer();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(CommonUtils.pad(byArray)));
            int n = CommonUtils.rand(Integer.MAX_VALUE);
            packer.addInt(n);
            packer.little();
            packer.addIntWithMask(dataInputStream.available(), n);
            packer.big();
            while (dataInputStream.available() > 0) {
                n = dataInputStream.readInt() ^ n;
                packer.addInt(n);
            }
            dataInputStream.close();
            return packer.getBytes();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("encode: " + byArray.length + " bytes", iOException, false);
            return new byte[0];
        }
    }

    public static void main(String[] stringArray) {
        String string = "\u00ccthis is a test and should show up after decoding.";
        byte[] byArray = CommonUtils.toBytes(string);
        System.err.println(CommonUtils.toNasmHexString(XorEncoder.encode(byArray)));
    }
}

