/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.BeaconCriteria;
import filter.Criteria;
import filter.LiteralCriteria;
import filter.NTLMHashCriteria;
import filter.NegateCriteria;
import filter.NetworkCriteria;
import filter.RangeCriteria;
import filter.WildcardCriteria;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataFilter {
    protected List criteria = null;

    public void reset() {
        this.criteria = null;
    }

    protected void addCriteria(String string, Criteria criteria, boolean bl) {
        if (this.criteria == null) {
            this.criteria = new LinkedList();
        }
        _A _A2 = new _A();
        _A2.A = bl ? new NegateCriteria(criteria) : criteria;
        _A2.B = string;
        this.criteria.add(_A2);
    }

    public void checkWildcard(String string, String string2) {
        this.addCriteria(string, new WildcardCriteria(string2), false);
    }

    public void checkWildcard(String string, String string2, boolean bl) {
        this.addCriteria(string, new WildcardCriteria(string2), bl);
    }

    public void checkLiteral(String string, String string2) {
        this.addCriteria(string, new LiteralCriteria(string2), false);
    }

    public void checkNTLMHash(String string, boolean bl) {
        this.addCriteria(string, new NTLMHashCriteria(), bl);
    }

    public void checkNetwork(String string, String string2, boolean bl) {
        this.addCriteria(string, new NetworkCriteria(string2), bl);
    }

    public void checkNumber(String string, String string2, boolean bl) {
        this.addCriteria(string, new RangeCriteria(string2), bl);
    }

    public void checkBeacon(String string, boolean bl) {
        this.addCriteria(string, new BeaconCriteria(), bl);
    }

    public List apply(List list) {
        if (this.criteria == null) {
            return list;
        }
        LinkedList linkedList = new LinkedList(list);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Map map2 = (Map)iterator.next();
            if (this.test(map2)) continue;
            iterator.remove();
        }
        return linkedList;
    }

    public boolean test(Map map2) {
        if (this.criteria == null) {
            return true;
        }
        for (_A _A2 : this.criteria) {
            Object object;
            if ("*".equals(_A2.B)) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = map2.values().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next() + "");
                    stringBuffer.append("\t");
                }
                object = stringBuffer.toString();
            } else {
                object = map2.get(_A2.B);
            }
            if (_A2.A.test(object)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.criteria.size() == 1) {
            return "1 filter";
        }
        return this.criteria.size() + " filters";
    }

    private static class _A {
        public Criteria A;
        public String B;

        private _A() {
        }
    }
}

