/*
 * Decompiled with CFR 0.152.
 */
package graph;

public class Route {
    private static final long A = Route.ipToLong("255.255.255.255");
    protected long begin;
    protected long end;
    protected String gateway;
    protected String network;
    protected String mask;

    public static long ipToLong(String string) {
        if (string == null) {
            return 0L;
        }
        String[] stringArray = string.split("\\.");
        long l = 0L;
        if (stringArray.length != 4) {
            return 0L;
        }
        try {
            l += (long)Integer.parseInt(stringArray[3]);
            l += Long.parseLong(stringArray[2]) << 8;
            l += Long.parseLong(stringArray[1]) << 16;
        }
        catch (Exception exception) {
            return l;
        }
        return l += Long.parseLong(stringArray[0]) << 24;
    }

    public Route(String string) {
        String[] stringArray = string.split("/");
        String string2 = "";
        String string3 = "";
        if (stringArray.length == 1) {
            string2 = string;
            String[] stringArray2 = string.split("\\.");
            string3 = stringArray2[0].equals("0") ? "1" : (stringArray2[1].equals("0") ? "8" : (stringArray2[2].equals("0") ? "16" : (stringArray2[3].equals("0") ? "24" : "32")));
        } else {
            string2 = stringArray[0];
            string3 = stringArray[1];
        }
        this.network = string2;
        this.mask = string3;
        this.gateway = "undefined";
        this.begin = Route.ipToLong(string2);
        try {
            this.end = this.begin + (A >> Integer.parseInt(string3));
        }
        catch (Exception exception) {
            System.err.println(string3 + " is malformed!");
        }
    }

    public Route(String string, String string2, String string3) {
        this.begin = Route.ipToLong(string);
        this.end = this.begin + (A - Route.ipToLong(string2));
        this.gateway = string3;
        this.network = string;
        this.mask = string2;
    }

    public boolean equals(Object object) {
        if (object instanceof Route) {
            Route route = (Route)object;
            return route.begin == this.begin && route.end == this.end && route.gateway.equals(this.gateway);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.begin + this.end + (long)this.gateway.hashCode());
    }

    public String getGateway() {
        return this.gateway;
    }

    public boolean shouldRoute(String string) {
        long l = Route.ipToLong(string);
        return l >= this.begin && l <= this.end;
    }

    public String toString() {
        return this.network + "/" + this.mask + " via " + this.gateway;
    }
}

