/*
 * Decompiled with CFR 0.152.
 */
package importers;

import aggressor.AggressorClient;
import common.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CredentialsHelper {
    public static final String DELIMITER = "\t";
    private static final SimpleDateFormat B = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String[] A = new String[]{"manual", "hashdump", "mimikatz"};

    public StringBuffer formatExport(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# Cobalt Strike Credential Export (Tab Separated Values)\n");
        stringBuffer.append("# " + CommonUtils.formatTime(System.currentTimeMillis()) + "\n\n");
        while (iterator.hasNext()) {
            Map map2 = (Map)iterator.next();
            String string = this.A(map2, "user").toString();
            String string2 = this.A(map2, "password").toString();
            String string3 = this.A(map2, "realm").toString();
            String string4 = this.A(map2, "note").toString();
            String string5 = this.A(map2, "source").toString();
            String string6 = this.A(map2, "host").toString();
            String string7 = this.A(map2, "added").toString();
            String string8 = this.A(DELIMITER, string, string2, string3, string4, string5, string6, string7);
            stringBuffer.append(string8);
        }
        return stringBuffer;
    }

    private Object A(Map map2, String string) {
        if (map2.containsKey(string)) {
            Object v = map2.get(string);
            if (v != null) {
                return v;
            }
        } else {
            return "";
        }
        return "";
    }

    private String A(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(string + string3);
        stringBuffer.append(string + string4);
        stringBuffer.append(string + string5);
        stringBuffer.append(string + string6);
        stringBuffer.append(string + string7);
        stringBuffer.append(string + string8);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public final int importFile(String string, AggressorClient aggressorClient) {
        String string2;
        List<String> list;
        CommonUtils.print_info("Importing Credentials File: " + string);
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("Credentials import file does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new RuntimeException("Credentials import file is not a file: " + file.getAbsolutePath());
        }
        try {
            list = Files.readAllLines(file.toPath(), Charset.defaultCharset());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Credentials import error: " + iOException.getMessage(), iOException);
        }
        int n = 0;
        int n2 = 0;
        ArrayList<Map> arrayList = new ArrayList<Map>();
        for (String object : list) {
            ++n2;
            if (object.trim().length() == 0 || object.trim().startsWith("#")) continue;
            String[] stringArray = object.split(DELIMITER, -1);
            if (stringArray.length != 7) {
                throw new RuntimeException("Credentials import error. Line number " + n2 + " requires 7 columns but has " + stringArray.length);
            }
            string2 = this.A(n2, "user", 1, stringArray, true, false);
            String string3 = this.A(n2, "password", 2, stringArray, false, false);
            String string4 = this.A(n2, "realm", 3, stringArray, false, false);
            String string5 = this.A(n2, "note", 4, stringArray, false, false);
            String string6 = this.A(n2, "source", 5, stringArray, A, true);
            String string7 = this.A(n2, "host", 6, stringArray, false, false);
            String string8 = this.A(n2, "added", 7, stringArray, false, false);
            long l = 0L;
            if (string8.trim().length() != 0) {
                try {
                    l = Long.parseLong(string8);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Date date = B.parse(string8);
                        l = date.getTime();
                    }
                    catch (ParseException parseException) {
                        throw new RuntimeException("Credentials import error. Line number " + n2 + " has invalid added timestamp (" + string8 + "). " + "Value must be numeric millisecond value, 0, blank, or " + "yyyy-MM-dd HH:mm:ss" + " format.");
                    }
                }
            }
            if (l == 0L) {
                l = System.currentTimeMillis();
            }
            Map map2 = this.A(string2, string3, string4, string5, string6, string7, l);
            arrayList.add(map2);
        }
        for (Map map3 : arrayList) {
            string2 = CommonUtils.CredKey(map3);
            aggressorClient.getConnection().call("credentials.update", CommonUtils.args(string2, map3));
            ++n;
        }
        this.finish(aggressorClient, n);
        return n;
    }

    public void finish(AggressorClient aggressorClient, int n) {
        CommonUtils.print_info("Credentials imported: " + n);
        if (n > 0) {
            aggressorClient.getConnection().call("credentials.push");
        }
    }

    private String A(int n, String string, int n2, String[] stringArray, String[] stringArray2, boolean bl) {
        int n3 = n2 - 1;
        String string2 = this.A(n, string, n2, stringArray, true, bl);
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equalsIgnoreCase(string2)) continue;
            return string2;
        }
        throw new RuntimeException("Credentials import error. Line number " + n + " '" + string + "' column requires one of these values: " + Arrays.toString(stringArray2));
    }

    private String A(int n, String string, int n2, String[] stringArray, boolean bl, boolean bl2) {
        int n3 = n2 - 1;
        if (n2 > stringArray.length) {
            return "";
        }
        String string2 = stringArray[n3].trim();
        if (bl2) {
            string2 = string2.toLowerCase();
        }
        if (bl && string2.length() == 0) {
            throw new RuntimeException("Credentials import error. Line number " + n + " requires a value for '" + string + "' column.");
        }
        return string2;
    }

    private Map A(String string, String string2, String string3, String string4, String string5, String string6, long l) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("user", string);
        hashMap.put("password", string2);
        hashMap.put("realm", string3);
        hashMap.put("note", string4);
        hashMap.put("source", string5);
        hashMap.put("host", string6);
        hashMap.put("added", l);
        return hashMap;
    }
}

