/*
 * Decompiled with CFR 0.152.
 */
package importers;

import common.CommonUtils;
import common.MudgeSanity;
import importers.FlatFile;
import importers.ImportHandler;
import importers.NmapXML;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public abstract class Importer {
    protected ImportHandler handler;
    protected HashSet hosts = new HashSet();

    public static List importers(ImportHandler importHandler) {
        LinkedList<Importer> linkedList = new LinkedList<Importer>();
        linkedList.add(new FlatFile(importHandler));
        linkedList.add(new NmapXML(importHandler));
        return linkedList;
    }

    public Importer(ImportHandler importHandler) {
        this.handler = importHandler;
    }

    public void host(String string, String string2, String string3, double d) {
        if (!this.hosts.contains(string = CommonUtils.trim(string))) {
            this.handler.host(string, string2, string3, d);
            this.hosts.add(string);
        }
    }

    public void service(String string, String string2, String string3) {
        string = CommonUtils.trim(string);
        this.handler.service(string, string2, string3);
    }

    public abstract boolean parse(File var1) throws Exception;

    public boolean process(File file) {
        try {
            if (this.parse(file)) {
                return true;
            }
        }
        catch (Exception exception) {
            MudgeSanity.logException("import " + file, exception, false);
        }
        return false;
    }
}

