/*
 * Decompiled with CFR 0.152.
 */
package importers;

import common.CommonUtils;
import common.MudgeSanity;
import common.OperatingSystem;
import importers.ImportHandler;
import importers.Importer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NmapXML
extends Importer {
    public NmapXML(ImportHandler importHandler) {
        super(importHandler);
    }

    public boolean isNmapXML(File file) {
        String string = CommonUtils.peekFile(file, 1024);
        return string.startsWith("<?xml") && string.indexOf("<nmaprun") > 0;
    }

    @Override
    public boolean parse(File file) throws Exception {
        if (!this.isNmapXML(file)) {
            return false;
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse((InputStream)new FileInputStream(file), (DefaultHandler)new _A());
            return true;
        }
        catch (Exception exception) {
            MudgeSanity.logException("Nmap XML is partially corrupt: " + file, exception, false);
            return true;
        }
    }

    class _A
    extends DefaultHandler {
        protected String I;
        protected boolean C = false;
        protected String A;
        protected String H = null;
        protected String F = null;
        protected boolean D = false;
        protected OperatingSystem B = null;
        protected int G = 0;

        _A() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("host".equals(string3)) {
                this.B = null;
                this.G = 0;
                this.A = null;
                this.C = false;
                this.I = null;
                this.H = null;
                this.F = null;
                this.D = false;
            } else if ("status".equals(string3)) {
                this.C = "up".equals(attributes.getValue("state"));
            } else if ("address".equals(string3) && "ipv4".equals(attributes.getValue("addrtype"))) {
                this.I = attributes.getValue("addr");
            } else if ("address".equals(string3) && "ipv6".equals(attributes.getValue("addrtype"))) {
                this.I = attributes.getValue("addr");
            } else if ("port".equals(string3)) {
                this.A = attributes.getValue("portid");
                this.H = null;
                this.F = null;
            } else if ("service".equals(string3)) {
                this.H = attributes.getValue("product");
                this.F = attributes.getValue("version");
            } else if ("state".equals(string3)) {
                this.D = true;
            } else if ("os".equals(string3)) {
                this.B = null;
                this.G = 0;
            } else if ("osclass".equals(string3)) {
                String string4 = attributes.getValue("osfamily");
                String string5 = attributes.getValue("osgen");
                int n = CommonUtils.toNumber(attributes.getValue("accuracy"), 0);
                OperatingSystem operatingSystem = new OperatingSystem(string4 + " " + string5);
                if (n > this.G && !operatingSystem.isUnknown()) {
                    this.B = operatingSystem;
                    this.G = n;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.D && "host".equals(string3)) {
                if (this.B != null) {
                    NmapXML.this.host(this.I, null, this.B.getName(), this.B.getVersion());
                } else {
                    NmapXML.this.host(this.I, null, null, 0.0);
                }
            } else if (this.C && "service".equals(string3)) {
                if (this.H != null && this.F != null) {
                    NmapXML.this.service(this.I, this.A, this.H + " " + this.F);
                } else if (this.H != null) {
                    NmapXML.this.service(this.I, this.A, this.H);
                } else {
                    NmapXML.this.service(this.I, this.A, null);
                }
            }
        }
    }
}

