/*
 * Decompiled with CFR 0.152.
 */
package kerberos;

import common.CommonUtils;
import common.DataParser;
import common.MudgeSanity;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import kerberos.Credential;
import kerberos.Principal;

public class Ccache {
    protected Principal primary_principal;
    protected List credentials = new LinkedList();

    public Ccache(String string) {
        this.parse(CommonUtils.readFile(string));
    }

    public void parse(byte[] byArray) {
        try {
            DataParser dataParser = new DataParser(byArray);
            dataParser.big();
            int n = dataParser.readShort();
            if (n != 1284) {
                CommonUtils.print_error("VERSION FAIL: " + n);
                return;
            }
            int n2 = dataParser.readShort();
            dataParser.consume(n2);
            this.primary_principal = new Principal(dataParser);
            while (dataParser.more()) {
                this.credentials.add(new Credential(dataParser));
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("CredCacheParse", iOException, false);
        }
    }

    public String toString() {
        return this.primary_principal + "\n" + this.credentials;
    }

    public static void main(String[] stringArray) {
        CommonUtils.print_good(new Ccache(stringArray[0]) + "");
    }
}

