/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.cms;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.DEROctetString;
import net.jsign.bouncycastle.asn1.DERSet;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.AttributeTable;
import net.jsign.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import net.jsign.bouncycastle.asn1.cms.CMSAttributes;
import net.jsign.bouncycastle.asn1.cms.Time;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map map2) {
        Attribute attribute;
        Object object;
        Hashtable hashtable = DefaultSignedAttributeTableGenerator.copyHashTable(this.table);
        if (!hashtable.containsKey(CMSAttributes.contentType) && (object = ASN1ObjectIdentifier.getInstance(map2.get("contentType"))) != null) {
            attribute = new Attribute(CMSAttributes.contentType, new DERSet((ASN1Encodable)object));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.containsKey(CMSAttributes.signingTime)) {
            object = new Date();
            attribute = new Attribute(CMSAttributes.signingTime, new DERSet(new Time((Date)object)));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.containsKey(CMSAttributes.messageDigest)) {
            object = (byte[])map2.get("digest");
            attribute = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString((byte[])object)));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.contains(CMSAttributes.cmsAlgorithmProtect)) {
            object = new Attribute(CMSAttributes.cmsAlgorithmProtect, new DERSet(new CMSAlgorithmProtection((AlgorithmIdentifier)map2.get("digestAlgID"), 1, (AlgorithmIdentifier)map2.get("signatureAlgID"))));
            hashtable.put(((Attribute)object).getAttrType(), object);
        }
        return hashtable;
    }

    public AttributeTable getAttributes(Map map2) {
        return new AttributeTable(this.createStandardAttributeTable(map2));
    }

    private static Hashtable copyHashTable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable2.put(k, hashtable.get(k));
        }
        return hashtable2;
    }
}

