/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.commons.math3.exception.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.jsign.commons.math3.exception.util.Localizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalizedFormats
extends Enum<LocalizedFormats>
implements Localizable {
    public static final /* enum */ LocalizedFormats ARGUMENT_OUTSIDE_DOMAIN = new LocalizedFormats("Argument {0} outside domain [{1} ; {2}]");
    public static final /* enum */ LocalizedFormats ARRAY_SIZE_EXCEEDS_MAX_VARIABLES = new LocalizedFormats("array size cannot be greater than {0}");
    public static final /* enum */ LocalizedFormats ARRAY_SIZES_SHOULD_HAVE_DIFFERENCE_1 = new LocalizedFormats("array sizes should have difference 1 ({0} != {1} + 1)");
    public static final /* enum */ LocalizedFormats ARRAY_SUMS_TO_ZERO = new LocalizedFormats("array sums to zero");
    public static final /* enum */ LocalizedFormats ASSYMETRIC_EIGEN_NOT_SUPPORTED = new LocalizedFormats("eigen decomposition of assymetric matrices not supported yet");
    public static final /* enum */ LocalizedFormats AT_LEAST_ONE_COLUMN = new LocalizedFormats("matrix must have at least one column");
    public static final /* enum */ LocalizedFormats AT_LEAST_ONE_ROW = new LocalizedFormats("matrix must have at least one row");
    public static final /* enum */ LocalizedFormats BANDWIDTH = new LocalizedFormats("bandwidth ({0})");
    public static final /* enum */ LocalizedFormats BESSEL_FUNCTION_BAD_ARGUMENT = new LocalizedFormats("Bessel function of order {0} cannot be computed for x = {1}");
    public static final /* enum */ LocalizedFormats BESSEL_FUNCTION_FAILED_CONVERGENCE = new LocalizedFormats("Bessel function of order {0} failed to converge for x = {1}");
    public static final /* enum */ LocalizedFormats BINOMIAL_INVALID_PARAMETERS_ORDER = new LocalizedFormats("must have n >= k for binomial coefficient (n, k), got k = {0}, n = {1}");
    public static final /* enum */ LocalizedFormats BINOMIAL_NEGATIVE_PARAMETER = new LocalizedFormats("must have n >= 0 for binomial coefficient (n, k), got n = {0}");
    public static final /* enum */ LocalizedFormats CANNOT_CLEAR_STATISTIC_CONSTRUCTED_FROM_EXTERNAL_MOMENTS = new LocalizedFormats("statistics constructed from external moments cannot be cleared");
    public static final /* enum */ LocalizedFormats CANNOT_COMPUTE_0TH_ROOT_OF_UNITY = new LocalizedFormats("cannot compute 0-th root of unity, indefinite result");
    public static final /* enum */ LocalizedFormats CANNOT_COMPUTE_BETA_DENSITY_AT_0_FOR_SOME_ALPHA = new LocalizedFormats("cannot compute beta density at 0 when alpha = {0,number}");
    public static final /* enum */ LocalizedFormats CANNOT_COMPUTE_BETA_DENSITY_AT_1_FOR_SOME_BETA = new LocalizedFormats("cannot compute beta density at 1 when beta = %.3g");
    public static final /* enum */ LocalizedFormats CANNOT_COMPUTE_NTH_ROOT_FOR_NEGATIVE_N = new LocalizedFormats("cannot compute nth root for null or negative n: {0}");
    public static final /* enum */ LocalizedFormats CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS = new LocalizedFormats("cannot discard a negative number of elements ({0})");
    public static final /* enum */ LocalizedFormats CANNOT_FORMAT_INSTANCE_AS_3D_VECTOR = new LocalizedFormats("cannot format a {0} instance as a 3D vector");
    public static final /* enum */ LocalizedFormats CANNOT_FORMAT_INSTANCE_AS_COMPLEX = new LocalizedFormats("cannot format a {0} instance as a complex number");
    public static final /* enum */ LocalizedFormats CANNOT_FORMAT_INSTANCE_AS_REAL_VECTOR = new LocalizedFormats("cannot format a {0} instance as a real vector");
    public static final /* enum */ LocalizedFormats CANNOT_FORMAT_OBJECT_TO_FRACTION = new LocalizedFormats("cannot format given object as a fraction number");
    public static final /* enum */ LocalizedFormats CANNOT_INCREMENT_STATISTIC_CONSTRUCTED_FROM_EXTERNAL_MOMENTS = new LocalizedFormats("statistics constructed from external moments cannot be incremented");
    public static final /* enum */ LocalizedFormats CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR = new LocalizedFormats("cannot normalize a zero norm vector");
    public static final /* enum */ LocalizedFormats CANNOT_RETRIEVE_AT_NEGATIVE_INDEX = new LocalizedFormats("elements cannot be retrieved from a negative array index {0}");
    public static final /* enum */ LocalizedFormats CANNOT_SET_AT_NEGATIVE_INDEX = new LocalizedFormats("cannot set an element at a negative index {0}");
    public static final /* enum */ LocalizedFormats CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY = new LocalizedFormats("cannot substitute an element from an empty array");
    public static final /* enum */ LocalizedFormats CANNOT_TRANSFORM_TO_DOUBLE = new LocalizedFormats("Conversion Exception in Transformation: {0}");
    public static final /* enum */ LocalizedFormats CARDAN_ANGLES_SINGULARITY = new LocalizedFormats("Cardan angles singularity");
    public static final /* enum */ LocalizedFormats CLASS_DOESNT_IMPLEMENT_COMPARABLE = new LocalizedFormats("class ({0}) does not implement Comparable");
    public static final /* enum */ LocalizedFormats CLOSE_VERTICES = new LocalizedFormats("too close vertices near point ({0}, {1}, {2})");
    public static final /* enum */ LocalizedFormats CLOSEST_ORTHOGONAL_MATRIX_HAS_NEGATIVE_DETERMINANT = new LocalizedFormats("the closest orthogonal matrix has a negative determinant {0}");
    public static final /* enum */ LocalizedFormats COLUMN_INDEX_OUT_OF_RANGE = new LocalizedFormats("column index {0} out of allowed range [{1}, {2}]");
    public static final /* enum */ LocalizedFormats COLUMN_INDEX = new LocalizedFormats("column index ({0})");
    public static final /* enum */ LocalizedFormats CONSTRAINT = new LocalizedFormats("constraint");
    public static final /* enum */ LocalizedFormats CONTINUED_FRACTION_INFINITY_DIVERGENCE = new LocalizedFormats("Continued fraction convergents diverged to +/- infinity for value {0}");
    public static final /* enum */ LocalizedFormats CONTINUED_FRACTION_NAN_DIVERGENCE = new LocalizedFormats("Continued fraction diverged to NaN for value {0}");
    public static final /* enum */ LocalizedFormats CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR = new LocalizedFormats("contraction criteria ({0}) smaller than the expansion factor ({1}).  This would lead to a never ending loop of expansion and contraction as a newly expanded internal storage array would immediately satisfy the criteria for contraction.");
    public static final /* enum */ LocalizedFormats CONTRACTION_CRITERIA_SMALLER_THAN_ONE = new LocalizedFormats("contraction criteria smaller than one ({0}).  This would lead to a never ending loop of expansion and contraction as an internal storage array length equal to the number of elements would satisfy the contraction criteria.");
    public static final /* enum */ LocalizedFormats CONVERGENCE_FAILED = new LocalizedFormats("convergence failed");
    public static final /* enum */ LocalizedFormats CROSSING_BOUNDARY_LOOPS = new LocalizedFormats("some outline boundary loops cross each other");
    public static final /* enum */ LocalizedFormats CROSSOVER_RATE = new LocalizedFormats("crossover rate ({0})");
    public static final /* enum */ LocalizedFormats CUMULATIVE_PROBABILITY_RETURNED_NAN = new LocalizedFormats("Cumulative probability function returned NaN for argument {0} p = {1}");
    public static final /* enum */ LocalizedFormats DIFFERENT_ROWS_LENGTHS = new LocalizedFormats("some rows have length {0} while others have length {1}");
    public static final /* enum */ LocalizedFormats DIFFERENT_ORIG_AND_PERMUTED_DATA = new LocalizedFormats("original and permuted data must contain the same elements");
    public static final /* enum */ LocalizedFormats DIGEST_NOT_INITIALIZED = new LocalizedFormats("digest not initialized");
    public static final /* enum */ LocalizedFormats DIMENSIONS_MISMATCH_2x2 = new LocalizedFormats("got {0}x{1} but expected {2}x{3}");
    public static final /* enum */ LocalizedFormats DIMENSIONS_MISMATCH_SIMPLE = new LocalizedFormats("{0} != {1}");
    public static final /* enum */ LocalizedFormats DIMENSIONS_MISMATCH = new LocalizedFormats("dimensions mismatch");
    public static final /* enum */ LocalizedFormats DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN = new LocalizedFormats("Discrete cumulative probability function returned NaN for argument {0}");
    public static final /* enum */ LocalizedFormats DISTRIBUTION_NOT_LOADED = new LocalizedFormats("distribution not loaded");
    public static final /* enum */ LocalizedFormats DUPLICATED_ABSCISSA_DIVISION_BY_ZERO = new LocalizedFormats("duplicated abscissa {0} causes division by zero");
    public static final /* enum */ LocalizedFormats EDGE_CONNECTED_TO_ONE_FACET = new LocalizedFormats("edge joining points ({0}, {1}, {2}) and ({3}, {4}, {5}) is connected to one facet only");
    public static final /* enum */ LocalizedFormats ELITISM_RATE = new LocalizedFormats("elitism rate ({0})");
    public static final /* enum */ LocalizedFormats EMPTY_CLUSTER_IN_K_MEANS = new LocalizedFormats("empty cluster in k-means");
    public static final /* enum */ LocalizedFormats EMPTY_INTERPOLATION_SAMPLE = new LocalizedFormats("sample for interpolation is empty");
    public static final /* enum */ LocalizedFormats EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY = new LocalizedFormats("empty polynomials coefficients array");
    public static final /* enum */ LocalizedFormats EMPTY_SELECTED_COLUMN_INDEX_ARRAY = new LocalizedFormats("empty selected column index array");
    public static final /* enum */ LocalizedFormats EMPTY_SELECTED_ROW_INDEX_ARRAY = new LocalizedFormats("empty selected row index array");
    public static final /* enum */ LocalizedFormats EMPTY_STRING_FOR_IMAGINARY_CHARACTER = new LocalizedFormats("empty string for imaginary character");
    public static final /* enum */ LocalizedFormats ENDPOINTS_NOT_AN_INTERVAL = new LocalizedFormats("endpoints do not specify an interval: [{0}, {1}]");
    public static final /* enum */ LocalizedFormats EQUAL_VERTICES_IN_SIMPLEX = new LocalizedFormats("equal vertices {0} and {1} in simplex configuration");
    public static final /* enum */ LocalizedFormats EULER_ANGLES_SINGULARITY = new LocalizedFormats("Euler angles singularity");
    public static final /* enum */ LocalizedFormats EVALUATION = new LocalizedFormats("evaluation");
    public static final /* enum */ LocalizedFormats EXPANSION_FACTOR_SMALLER_THAN_ONE = new LocalizedFormats("expansion factor smaller than one ({0})");
    public static final /* enum */ LocalizedFormats FACET_ORIENTATION_MISMATCH = new LocalizedFormats("facets orientation mismatch around edge joining points ({0}, {1}, {2}) and ({3}, {4}, {5})");
    public static final /* enum */ LocalizedFormats FACTORIAL_NEGATIVE_PARAMETER = new LocalizedFormats("must have n >= 0 for n!, got n = {0}");
    public static final /* enum */ LocalizedFormats FAILED_BRACKETING = new LocalizedFormats("number of iterations={4}, maximum iterations={5}, initial={6}, lower bound={7}, upper bound={8}, final a value={0}, final b value={1}, f(a)={2}, f(b)={3}");
    public static final /* enum */ LocalizedFormats FAILED_FRACTION_CONVERSION = new LocalizedFormats("Unable to convert {0} to fraction after {1} iterations");
    public static final /* enum */ LocalizedFormats FIRST_COLUMNS_NOT_INITIALIZED_YET = new LocalizedFormats("first {0} columns are not initialized yet");
    public static final /* enum */ LocalizedFormats FIRST_ELEMENT_NOT_ZERO = new LocalizedFormats("first element is not 0: {0}");
    public static final /* enum */ LocalizedFormats FIRST_ROWS_NOT_INITIALIZED_YET = new LocalizedFormats("first {0} rows are not initialized yet");
    public static final /* enum */ LocalizedFormats FRACTION_CONVERSION_OVERFLOW = new LocalizedFormats("Overflow trying to convert {0} to fraction ({1}/{2})");
    public static final /* enum */ LocalizedFormats FUNCTION_NOT_DIFFERENTIABLE = new LocalizedFormats("function is not differentiable");
    public static final /* enum */ LocalizedFormats FUNCTION_NOT_POLYNOMIAL = new LocalizedFormats("function is not polynomial");
    public static final /* enum */ LocalizedFormats GCD_OVERFLOW_32_BITS = new LocalizedFormats("overflow: gcd({0}, {1}) is 2^31");
    public static final /* enum */ LocalizedFormats GCD_OVERFLOW_64_BITS = new LocalizedFormats("overflow: gcd({0}, {1}) is 2^63");
    public static final /* enum */ LocalizedFormats HOLE_BETWEEN_MODELS_TIME_RANGES = new LocalizedFormats("{0} wide hole between models time ranges");
    public static final /* enum */ LocalizedFormats ILL_CONDITIONED_OPERATOR = new LocalizedFormats("condition number {1} is too high ");
    public static final /* enum */ LocalizedFormats INCONSISTENT_STATE_AT_2_PI_WRAPPING = new LocalizedFormats("inconsistent state at 2\u03c0 wrapping");
    public static final /* enum */ LocalizedFormats INDEX_LARGER_THAN_MAX = new LocalizedFormats("the index specified: {0} is larger than the current maximal index {1}");
    public static final /* enum */ LocalizedFormats INDEX_NOT_POSITIVE = new LocalizedFormats("index ({0}) is not positive");
    public static final /* enum */ LocalizedFormats INDEX_OUT_OF_RANGE = new LocalizedFormats("index {0} out of allowed range [{1}, {2}]");
    public static final /* enum */ LocalizedFormats INDEX = new LocalizedFormats("index ({0})");
    public static final /* enum */ LocalizedFormats NOT_FINITE_NUMBER = new LocalizedFormats("{0} is not a finite number");
    public static final /* enum */ LocalizedFormats INFINITE_BOUND = new LocalizedFormats("interval bounds must be finite");
    public static final /* enum */ LocalizedFormats ARRAY_ELEMENT = new LocalizedFormats("value {0} at index {1}");
    public static final /* enum */ LocalizedFormats INFINITE_ARRAY_ELEMENT = new LocalizedFormats("Array contains an infinite element, {0} at index {1}");
    public static final /* enum */ LocalizedFormats INFINITE_VALUE_CONVERSION = new LocalizedFormats("cannot convert infinite value");
    public static final /* enum */ LocalizedFormats INITIAL_CAPACITY_NOT_POSITIVE = new LocalizedFormats("initial capacity ({0}) is not positive");
    public static final /* enum */ LocalizedFormats INITIAL_COLUMN_AFTER_FINAL_COLUMN = new LocalizedFormats("initial column {1} after final column {0}");
    public static final /* enum */ LocalizedFormats INITIAL_ROW_AFTER_FINAL_ROW = new LocalizedFormats("initial row {1} after final row {0}");
    @Deprecated
    public static final /* enum */ LocalizedFormats INPUT_DATA_FROM_UNSUPPORTED_DATASOURCE = new LocalizedFormats("input data comes from unsupported datasource: {0}, supported sources: {1}, {2}");
    public static final /* enum */ LocalizedFormats INSTANCES_NOT_COMPARABLE_TO_EXISTING_VALUES = new LocalizedFormats("instance of class {0} not comparable to existing values");
    public static final /* enum */ LocalizedFormats INSUFFICIENT_DATA = new LocalizedFormats("insufficient data");
    public static final /* enum */ LocalizedFormats INSUFFICIENT_DATA_FOR_T_STATISTIC = new LocalizedFormats("insufficient data for t statistic, needs at least 2, got {0}");
    public static final /* enum */ LocalizedFormats INSUFFICIENT_DIMENSION = new LocalizedFormats("insufficient dimension {0}, must be at least {1}");
    public static final /* enum */ LocalizedFormats DIMENSION = new LocalizedFormats("dimension ({0})");
    public static final /* enum */ LocalizedFormats INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE = new LocalizedFormats("sample contains {0} observed points, at least {1} are required");
    public static final /* enum */ LocalizedFormats INSUFFICIENT_ROWS_AND_COLUMNS = new LocalizedFormats("insufficient data: only {0} rows and {1} columns.");
    public static final /* enum */ LocalizedFormats INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS = new LocalizedFormats("multistep method needs at least {0} previous steps, got {1}");
    public static final /* enum */ LocalizedFormats INTERNAL_ERROR = new LocalizedFormats("internal error, please fill a bug report at {0}");
    public static final /* enum */ LocalizedFormats INVALID_BINARY_DIGIT = new LocalizedFormats("invalid binary digit: {0}");
    public static final /* enum */ LocalizedFormats INVALID_BINARY_CHROMOSOME = new LocalizedFormats("binary mutation works on BinaryChromosome only");
    public static final /* enum */ LocalizedFormats INVALID_BRACKETING_PARAMETERS = new LocalizedFormats("invalid bracketing parameters:  lower bound={0},  initial={1}, upper bound={2}");
    public static final /* enum */ LocalizedFormats INVALID_FIXED_LENGTH_CHROMOSOME = new LocalizedFormats("one-point crossover only works with fixed-length chromosomes");
    public static final /* enum */ LocalizedFormats INVALID_IMPLEMENTATION = new LocalizedFormats("required functionality is missing in {0}");
    public static final /* enum */ LocalizedFormats INVALID_INTERVAL_INITIAL_VALUE_PARAMETERS = new LocalizedFormats("invalid interval, initial value parameters:  lower={0}, initial={1}, upper={2}");
    public static final /* enum */ LocalizedFormats INVALID_ITERATIONS_LIMITS = new LocalizedFormats("invalid iteration limits: min={0}, max={1}");
    public static final /* enum */ LocalizedFormats INVALID_MAX_ITERATIONS = new LocalizedFormats("bad value for maximum iterations number: {0}");
    public static final /* enum */ LocalizedFormats NOT_ENOUGH_DATA_REGRESSION = new LocalizedFormats("the number of observations is not sufficient to conduct regression");
    public static final /* enum */ LocalizedFormats INVALID_REGRESSION_ARRAY = new LocalizedFormats("input data array length = {0} does not match the number of observations = {1} and the number of regressors = {2}");
    public static final /* enum */ LocalizedFormats INVALID_REGRESSION_OBSERVATION = new LocalizedFormats("length of regressor array = {0} does not match the number of variables = {1} in the model");
    public static final /* enum */ LocalizedFormats INVALID_ROUNDING_METHOD = new LocalizedFormats("invalid rounding method {0}, valid methods: {1} ({2}), {3} ({4}), {5} ({6}), {7} ({8}), {9} ({10}), {11} ({12}), {13} ({14}), {15} ({16})");
    public static final /* enum */ LocalizedFormats ITERATOR_EXHAUSTED = new LocalizedFormats("iterator exhausted");
    public static final /* enum */ LocalizedFormats ITERATIONS = new LocalizedFormats("iterations");
    public static final /* enum */ LocalizedFormats LCM_OVERFLOW_32_BITS = new LocalizedFormats("overflow: lcm({0}, {1}) is 2^31");
    public static final /* enum */ LocalizedFormats LCM_OVERFLOW_64_BITS = new LocalizedFormats("overflow: lcm({0}, {1}) is 2^63");
    public static final /* enum */ LocalizedFormats LIST_OF_CHROMOSOMES_BIGGER_THAN_POPULATION_SIZE = new LocalizedFormats("list of chromosomes bigger than maxPopulationSize");
    public static final /* enum */ LocalizedFormats LOESS_EXPECTS_AT_LEAST_ONE_POINT = new LocalizedFormats("Loess expects at least 1 point");
    public static final /* enum */ LocalizedFormats LOWER_BOUND_NOT_BELOW_UPPER_BOUND = new LocalizedFormats("lower bound ({0}) must be strictly less than upper bound ({1})");
    public static final /* enum */ LocalizedFormats LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT = new LocalizedFormats("lower endpoint ({0}) must be less than or equal to upper endpoint ({1})");
    public static final /* enum */ LocalizedFormats MAP_MODIFIED_WHILE_ITERATING = new LocalizedFormats("map has been modified while iterating");
    public static final /* enum */ LocalizedFormats MULTISTEP_STARTER_STOPPED_EARLY = new LocalizedFormats("multistep integrator starter stopped early, maybe too large step size");
    public static final /* enum */ LocalizedFormats EVALUATIONS = new LocalizedFormats("evaluations");
    public static final /* enum */ LocalizedFormats MAX_COUNT_EXCEEDED = new LocalizedFormats("maximal count ({0}) exceeded");
    public static final /* enum */ LocalizedFormats MAX_ITERATIONS_EXCEEDED = new LocalizedFormats("maximal number of iterations ({0}) exceeded");
    public static final /* enum */ LocalizedFormats MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION = new LocalizedFormats("minimal step size ({1,number,0.00E00}) reached, integration needs {0,number,0.00E00}");
    public static final /* enum */ LocalizedFormats MISMATCHED_LOESS_ABSCISSA_ORDINATE_ARRAYS = new LocalizedFormats("Loess expects the abscissa and ordinate arrays to be of the same size, but got {0} abscissae and {1} ordinatae");
    public static final /* enum */ LocalizedFormats MUTATION_RATE = new LocalizedFormats("mutation rate ({0})");
    public static final /* enum */ LocalizedFormats NAN_ELEMENT_AT_INDEX = new LocalizedFormats("element {0} is NaN");
    public static final /* enum */ LocalizedFormats NAN_VALUE_CONVERSION = new LocalizedFormats("cannot convert NaN value");
    public static final /* enum */ LocalizedFormats NEGATIVE_BRIGHTNESS_EXPONENT = new LocalizedFormats("brightness exponent should be positive or null, but got {0}");
    public static final /* enum */ LocalizedFormats NEGATIVE_COMPLEX_MODULE = new LocalizedFormats("negative complex module {0}");
    public static final /* enum */ LocalizedFormats NEGATIVE_ELEMENT_AT_2D_INDEX = new LocalizedFormats("element ({0}, {1}) is negative: {2}");
    public static final /* enum */ LocalizedFormats NEGATIVE_ELEMENT_AT_INDEX = new LocalizedFormats("element {0} is negative: {1}");
    public static final /* enum */ LocalizedFormats NEGATIVE_NUMBER_OF_SUCCESSES = new LocalizedFormats("number of successes must be non-negative ({0})");
    public static final /* enum */ LocalizedFormats NUMBER_OF_SUCCESSES = new LocalizedFormats("number of successes ({0})");
    public static final /* enum */ LocalizedFormats NEGATIVE_NUMBER_OF_TRIALS = new LocalizedFormats("number of trials must be non-negative ({0})");
    public static final /* enum */ LocalizedFormats NUMBER_OF_INTERPOLATION_POINTS = new LocalizedFormats("number of interpolation points ({0})");
    public static final /* enum */ LocalizedFormats NUMBER_OF_TRIALS = new LocalizedFormats("number of trials ({0})");
    public static final /* enum */ LocalizedFormats NOT_CONVEX = new LocalizedFormats("vertices do not form a convex hull in CCW winding");
    public static final /* enum */ LocalizedFormats NOT_CONVEX_HYPERPLANES = new LocalizedFormats("hyperplanes do not define a convex region");
    public static final /* enum */ LocalizedFormats ROBUSTNESS_ITERATIONS = new LocalizedFormats("number of robustness iterations ({0})");
    public static final /* enum */ LocalizedFormats START_POSITION = new LocalizedFormats("start position ({0})");
    public static final /* enum */ LocalizedFormats NON_CONVERGENT_CONTINUED_FRACTION = new LocalizedFormats("Continued fraction convergents failed to converge (in less than {0} iterations) for value {1}");
    public static final /* enum */ LocalizedFormats NON_INVERTIBLE_TRANSFORM = new LocalizedFormats("non-invertible affine transform collapses some lines into single points");
    public static final /* enum */ LocalizedFormats NON_POSITIVE_MICROSPHERE_ELEMENTS = new LocalizedFormats("number of microsphere elements must be positive, but got {0}");
    public static final /* enum */ LocalizedFormats NON_POSITIVE_POLYNOMIAL_DEGREE = new LocalizedFormats("polynomial degree must be positive: degree={0}");
    public static final /* enum */ LocalizedFormats NON_REAL_FINITE_ABSCISSA = new LocalizedFormats("all abscissae must be finite real numbers, but {0}-th is {1}");
    public static final /* enum */ LocalizedFormats NON_REAL_FINITE_ORDINATE = new LocalizedFormats("all ordinatae must be finite real numbers, but {0}-th is {1}");
    public static final /* enum */ LocalizedFormats NON_REAL_FINITE_WEIGHT = new LocalizedFormats("all weights must be finite real numbers, but {0}-th is {1}");
    public static final /* enum */ LocalizedFormats NON_SQUARE_MATRIX = new LocalizedFormats("non square ({0}x{1}) matrix");
    public static final /* enum */ LocalizedFormats NORM = new LocalizedFormats("Norm ({0})");
    public static final /* enum */ LocalizedFormats NORMALIZE_INFINITE = new LocalizedFormats("Cannot normalize to an infinite value");
    public static final /* enum */ LocalizedFormats NORMALIZE_NAN = new LocalizedFormats("Cannot normalize to NaN");
    public static final /* enum */ LocalizedFormats NOT_ADDITION_COMPATIBLE_MATRICES = new LocalizedFormats("{0}x{1} and {2}x{3} matrices are not addition compatible");
    public static final /* enum */ LocalizedFormats NOT_DECREASING_NUMBER_OF_POINTS = new LocalizedFormats("points {0} and {1} are not decreasing ({2} < {3})");
    public static final /* enum */ LocalizedFormats NOT_DECREASING_SEQUENCE = new LocalizedFormats("points {3} and {2} are not decreasing ({1} < {0})");
    public static final /* enum */ LocalizedFormats NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS = new LocalizedFormats("not enough data ({0} rows) for this many predictors ({1} predictors)");
    public static final /* enum */ LocalizedFormats NOT_ENOUGH_POINTS_IN_SPLINE_PARTITION = new LocalizedFormats("spline partition must have at least {0} points, got {1}");
    public static final /* enum */ LocalizedFormats NOT_INCREASING_NUMBER_OF_POINTS = new LocalizedFormats("points {0} and {1} are not increasing ({2} > {3})");
    public static final /* enum */ LocalizedFormats NOT_INCREASING_SEQUENCE = new LocalizedFormats("points {3} and {2} are not increasing ({1} > {0})");
    public static final /* enum */ LocalizedFormats NOT_MULTIPLICATION_COMPATIBLE_MATRICES = new LocalizedFormats("{0}x{1} and {2}x{3} matrices are not multiplication compatible");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_DEFINITE_MATRIX = new LocalizedFormats("not positive definite matrix");
    public static final /* enum */ LocalizedFormats NON_POSITIVE_DEFINITE_MATRIX = new LocalizedFormats("not positive definite matrix: diagonal element at ({1},{1}) is smaller than {2} ({0})");
    public static final /* enum */ LocalizedFormats NON_POSITIVE_DEFINITE_OPERATOR = new LocalizedFormats("non positive definite linear operator");
    public static final /* enum */ LocalizedFormats NON_SELF_ADJOINT_OPERATOR = new LocalizedFormats("non self-adjoint linear operator");
    public static final /* enum */ LocalizedFormats NON_SQUARE_OPERATOR = new LocalizedFormats("non square ({0}x{1}) linear operator");
    public static final /* enum */ LocalizedFormats DEGREES_OF_FREEDOM = new LocalizedFormats("degrees of freedom ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_DEGREES_OF_FREEDOM = new LocalizedFormats("degrees of freedom must be positive ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_ELEMENT_AT_INDEX = new LocalizedFormats("element {0} is not positive: {1}");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_EXPONENT = new LocalizedFormats("invalid exponent {0} (must be positive)");
    public static final /* enum */ LocalizedFormats NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE = new LocalizedFormats("number of elements should be positive ({0})");
    public static final /* enum */ LocalizedFormats BASE = new LocalizedFormats("base ({0})");
    public static final /* enum */ LocalizedFormats EXPONENT = new LocalizedFormats("exponent ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_LENGTH = new LocalizedFormats("length must be positive ({0})");
    public static final /* enum */ LocalizedFormats LENGTH = new LocalizedFormats("length ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_MEAN = new LocalizedFormats("mean must be positive ({0})");
    public static final /* enum */ LocalizedFormats MEAN = new LocalizedFormats("mean ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_NUMBER_OF_SAMPLES = new LocalizedFormats("number of sample is not positive: {0}");
    public static final /* enum */ LocalizedFormats NUMBER_OF_SAMPLES = new LocalizedFormats("number of samples ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_PERMUTATION = new LocalizedFormats("permutation k ({0}) must be positive");
    public static final /* enum */ LocalizedFormats PERMUTATION_SIZE = new LocalizedFormats("permutation size ({0}");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_POISSON_MEAN = new LocalizedFormats("the Poisson mean must be positive ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_POPULATION_SIZE = new LocalizedFormats("population size must be positive ({0})");
    public static final /* enum */ LocalizedFormats POPULATION_SIZE = new LocalizedFormats("population size ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_ROW_DIMENSION = new LocalizedFormats("invalid row dimension: {0} (must be positive)");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_SAMPLE_SIZE = new LocalizedFormats("sample size must be positive ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_SCALE = new LocalizedFormats("scale must be positive ({0})");
    public static final /* enum */ LocalizedFormats SCALE = new LocalizedFormats("scale ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_SHAPE = new LocalizedFormats("shape must be positive ({0})");
    public static final /* enum */ LocalizedFormats SHAPE = new LocalizedFormats("shape ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_STANDARD_DEVIATION = new LocalizedFormats("standard deviation must be positive ({0})");
    public static final /* enum */ LocalizedFormats STANDARD_DEVIATION = new LocalizedFormats("standard deviation ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_UPPER_BOUND = new LocalizedFormats("upper bound must be positive ({0})");
    public static final /* enum */ LocalizedFormats NOT_POSITIVE_WINDOW_SIZE = new LocalizedFormats("window size must be positive ({0})");
    public static final /* enum */ LocalizedFormats NOT_POWER_OF_TWO = new LocalizedFormats("{0} is not a power of 2");
    public static final /* enum */ LocalizedFormats NOT_POWER_OF_TWO_CONSIDER_PADDING = new LocalizedFormats("{0} is not a power of 2, consider padding for fix");
    public static final /* enum */ LocalizedFormats NOT_POWER_OF_TWO_PLUS_ONE = new LocalizedFormats("{0} is not a power of 2 plus one");
    public static final /* enum */ LocalizedFormats NOT_STRICTLY_DECREASING_NUMBER_OF_POINTS = new LocalizedFormats("points {0} and {1} are not strictly decreasing ({2} <= {3})");
    public static final /* enum */ LocalizedFormats NOT_STRICTLY_DECREASING_SEQUENCE = new LocalizedFormats("points {3} and {2} are not strictly decreasing ({1} <= {0})");
    public static final /* enum */ LocalizedFormats NOT_STRICTLY_INCREASING_KNOT_VALUES = new LocalizedFormats("knot values must be strictly increasing");
    public static final /* enum */ LocalizedFormats NOT_STRICTLY_INCREASING_NUMBER_OF_POINTS = new LocalizedFormats("points {0} and {1} are not strictly increasing ({2} >= {3})");
    public static final /* enum */ LocalizedFormats NOT_STRICTLY_INCREASING_SEQUENCE = new LocalizedFormats("points {3} and {2} are not strictly increasing ({1} >= {0})");
    public static final /* enum */ LocalizedFormats NOT_SUBTRACTION_COMPATIBLE_MATRICES = new LocalizedFormats("{0}x{1} and {2}x{3} matrices are not subtraction compatible");
    public static final /* enum */ LocalizedFormats NOT_SUPPORTED_IN_DIMENSION_N = new LocalizedFormats("method not supported in dimension {0}");
    public static final /* enum */ LocalizedFormats NOT_SYMMETRIC_MATRIX = new LocalizedFormats("not symmetric matrix");
    public static final /* enum */ LocalizedFormats NON_SYMMETRIC_MATRIX = new LocalizedFormats("non symmetric matrix: the difference between entries at ({0},{1}) and ({1},{0}) is larger than {2}");
    public static final /* enum */ LocalizedFormats NO_BIN_SELECTED = new LocalizedFormats("no bin selected");
    public static final /* enum */ LocalizedFormats NO_CONVERGENCE_WITH_ANY_START_POINT = new LocalizedFormats("none of the {0} start points lead to convergence");
    public static final /* enum */ LocalizedFormats NO_DATA = new LocalizedFormats("no data");
    public static final /* enum */ LocalizedFormats NO_DEGREES_OF_FREEDOM = new LocalizedFormats("no degrees of freedom ({0} measurements, {1} parameters)");
    public static final /* enum */ LocalizedFormats NO_DENSITY_FOR_THIS_DISTRIBUTION = new LocalizedFormats("This distribution does not have a density function implemented");
    public static final /* enum */ LocalizedFormats NO_FEASIBLE_SOLUTION = new LocalizedFormats("no feasible solution");
    public static final /* enum */ LocalizedFormats NO_OPTIMUM_COMPUTED_YET = new LocalizedFormats("no optimum computed yet");
    public static final /* enum */ LocalizedFormats NO_REGRESSORS = new LocalizedFormats("Regression model must include at least one regressor");
    public static final /* enum */ LocalizedFormats NO_RESULT_AVAILABLE = new LocalizedFormats("no result available");
    public static final /* enum */ LocalizedFormats NO_SUCH_MATRIX_ENTRY = new LocalizedFormats("no entry at indices ({0}, {1}) in a {2}x{3} matrix");
    public static final /* enum */ LocalizedFormats NAN_NOT_ALLOWED = new LocalizedFormats("NaN is not allowed");
    public static final /* enum */ LocalizedFormats NULL_NOT_ALLOWED = new LocalizedFormats("null is not allowed");
    public static final /* enum */ LocalizedFormats ARRAY_ZERO_LENGTH_OR_NULL_NOT_ALLOWED = new LocalizedFormats("a null or zero length array not allowed");
    public static final /* enum */ LocalizedFormats COVARIANCE_MATRIX = new LocalizedFormats("covariance matrix");
    public static final /* enum */ LocalizedFormats DENOMINATOR = new LocalizedFormats("denominator");
    public static final /* enum */ LocalizedFormats DENOMINATOR_FORMAT = new LocalizedFormats("denominator format");
    public static final /* enum */ LocalizedFormats FRACTION = new LocalizedFormats("fraction");
    public static final /* enum */ LocalizedFormats FUNCTION = new LocalizedFormats("function");
    public static final /* enum */ LocalizedFormats IMAGINARY_FORMAT = new LocalizedFormats("imaginary format");
    public static final /* enum */ LocalizedFormats INPUT_ARRAY = new LocalizedFormats("input array");
    public static final /* enum */ LocalizedFormats NUMERATOR = new LocalizedFormats("numerator");
    public static final /* enum */ LocalizedFormats NUMERATOR_FORMAT = new LocalizedFormats("numerator format");
    public static final /* enum */ LocalizedFormats OBJECT_TRANSFORMATION = new LocalizedFormats("conversion exception in transformation");
    public static final /* enum */ LocalizedFormats REAL_FORMAT = new LocalizedFormats("real format");
    public static final /* enum */ LocalizedFormats WHOLE_FORMAT = new LocalizedFormats("whole format");
    public static final /* enum */ LocalizedFormats NUMBER_TOO_LARGE = new LocalizedFormats("{0} is larger than the maximum ({1})");
    public static final /* enum */ LocalizedFormats NUMBER_TOO_SMALL = new LocalizedFormats("{0} is smaller than the minimum ({1})");
    public static final /* enum */ LocalizedFormats NUMBER_TOO_LARGE_BOUND_EXCLUDED = new LocalizedFormats("{0} is larger than, or equal to, the maximum ({1})");
    public static final /* enum */ LocalizedFormats NUMBER_TOO_SMALL_BOUND_EXCLUDED = new LocalizedFormats("{0} is smaller than, or equal to, the minimum ({1})");
    public static final /* enum */ LocalizedFormats NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE = new LocalizedFormats("number of successes ({0}) must be less than or equal to population size ({1})");
    public static final /* enum */ LocalizedFormats NUMERATOR_OVERFLOW_AFTER_MULTIPLY = new LocalizedFormats("overflow, numerator too large after multiply: {0}");
    public static final /* enum */ LocalizedFormats N_POINTS_GAUSS_LEGENDRE_INTEGRATOR_NOT_SUPPORTED = new LocalizedFormats("{0} points Legendre-Gauss integrator not supported, number of points must be in the {1}-{2} range");
    public static final /* enum */ LocalizedFormats OBSERVED_COUNTS_ALL_ZERO = new LocalizedFormats("observed counts are all 0 in observed array {0}");
    public static final /* enum */ LocalizedFormats OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY = new LocalizedFormats("observed counts are both zero for entry {0}");
    public static final /* enum */ LocalizedFormats BOBYQA_BOUND_DIFFERENCE_CONDITION = new LocalizedFormats("the difference between the upper and lower bound must be larger than twice the initial trust region radius ({0})");
    public static final /* enum */ LocalizedFormats OUT_OF_BOUNDS_QUANTILE_VALUE = new LocalizedFormats("out of bounds quantile value: {0}, must be in (0, 100]");
    public static final /* enum */ LocalizedFormats OUT_OF_BOUNDS_CONFIDENCE_LEVEL = new LocalizedFormats("out of bounds confidence level {0}, must be between {1} and {2}");
    public static final /* enum */ LocalizedFormats OUT_OF_BOUND_SIGNIFICANCE_LEVEL = new LocalizedFormats("out of bounds significance level {0}, must be between {1} and {2}");
    public static final /* enum */ LocalizedFormats SIGNIFICANCE_LEVEL = new LocalizedFormats("significance level ({0})");
    public static final /* enum */ LocalizedFormats OUT_OF_ORDER_ABSCISSA_ARRAY = new LocalizedFormats("the abscissae array must be sorted in a strictly increasing order, but the {0}-th element is {1} whereas {2}-th is {3}");
    public static final /* enum */ LocalizedFormats OUT_OF_PLANE = new LocalizedFormats("point ({0}, {1}, {2}) is out of plane");
    public static final /* enum */ LocalizedFormats OUT_OF_RANGE_ROOT_OF_UNITY_INDEX = new LocalizedFormats("out of range root of unity index {0} (must be in [{1};{2}])");
    public static final /* enum */ LocalizedFormats OUT_OF_RANGE = new LocalizedFormats("out of range");
    public static final /* enum */ LocalizedFormats OUT_OF_RANGE_SIMPLE = new LocalizedFormats("{0} out of [{1}, {2}] range");
    public static final /* enum */ LocalizedFormats OUT_OF_RANGE_LEFT = new LocalizedFormats("{0} out of ({1}, {2}] range");
    public static final /* enum */ LocalizedFormats OUT_OF_RANGE_RIGHT = new LocalizedFormats("{0} out of [{1}, {2}) range");
    public static final /* enum */ LocalizedFormats OUTLINE_BOUNDARY_LOOP_OPEN = new LocalizedFormats("an outline boundary loop is open");
    public static final /* enum */ LocalizedFormats OVERFLOW = new LocalizedFormats("overflow");
    public static final /* enum */ LocalizedFormats OVERFLOW_IN_FRACTION = new LocalizedFormats("overflow in fraction {0}/{1}, cannot negate");
    public static final /* enum */ LocalizedFormats OVERFLOW_IN_ADDITION = new LocalizedFormats("overflow in addition: {0} + {1}");
    public static final /* enum */ LocalizedFormats OVERFLOW_IN_SUBTRACTION = new LocalizedFormats("overflow in subtraction: {0} - {1}");
    public static final /* enum */ LocalizedFormats OVERFLOW_IN_MULTIPLICATION = new LocalizedFormats("overflow in multiplication: {0} * {1}");
    public static final /* enum */ LocalizedFormats PERCENTILE_IMPLEMENTATION_CANNOT_ACCESS_METHOD = new LocalizedFormats("cannot access {0} method in percentile implementation {1}");
    public static final /* enum */ LocalizedFormats PERCENTILE_IMPLEMENTATION_UNSUPPORTED_METHOD = new LocalizedFormats("percentile implementation {0} does not support {1}");
    public static final /* enum */ LocalizedFormats PERMUTATION_EXCEEDS_N = new LocalizedFormats("permutation size ({0}) exceeds permuation domain ({1})");
    public static final /* enum */ LocalizedFormats POLYNOMIAL = new LocalizedFormats("polynomial");
    public static final /* enum */ LocalizedFormats POLYNOMIAL_INTERPOLANTS_MISMATCH_SEGMENTS = new LocalizedFormats("number of polynomial interpolants must match the number of segments ({0} != {1} - 1)");
    public static final /* enum */ LocalizedFormats POPULATION_LIMIT_NOT_POSITIVE = new LocalizedFormats("population limit has to be positive");
    public static final /* enum */ LocalizedFormats POWER_NEGATIVE_PARAMETERS = new LocalizedFormats("cannot raise an integral value to a negative power ({0}^{1})");
    public static final /* enum */ LocalizedFormats PROPAGATION_DIRECTION_MISMATCH = new LocalizedFormats("propagation direction mismatch");
    public static final /* enum */ LocalizedFormats RANDOMKEY_MUTATION_WRONG_CLASS = new LocalizedFormats("RandomKeyMutation works only with RandomKeys, not {0}");
    public static final /* enum */ LocalizedFormats ROOTS_OF_UNITY_NOT_COMPUTED_YET = new LocalizedFormats("roots of unity have not been computed yet");
    public static final /* enum */ LocalizedFormats ROTATION_MATRIX_DIMENSIONS = new LocalizedFormats("a {0}x{1} matrix cannot be a rotation matrix");
    public static final /* enum */ LocalizedFormats ROW_INDEX_OUT_OF_RANGE = new LocalizedFormats("row index {0} out of allowed range [{1}, {2}]");
    public static final /* enum */ LocalizedFormats ROW_INDEX = new LocalizedFormats("row index ({0})");
    public static final /* enum */ LocalizedFormats SAME_SIGN_AT_ENDPOINTS = new LocalizedFormats("function values at endpoints do not have different signs, endpoints: [{0}, {1}], values: [{2}, {3}]");
    public static final /* enum */ LocalizedFormats SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE = new LocalizedFormats("sample size ({0}) exceeds collection size ({1})");
    public static final /* enum */ LocalizedFormats SAMPLE_SIZE_LARGER_THAN_POPULATION_SIZE = new LocalizedFormats("sample size ({0}) must be less than or equal to population size ({1})");
    public static final /* enum */ LocalizedFormats SIMPLEX_NEED_ONE_POINT = new LocalizedFormats("simplex must contain at least one point");
    public static final /* enum */ LocalizedFormats SIMPLE_MESSAGE = new LocalizedFormats("{0}");
    public static final /* enum */ LocalizedFormats SINGULAR_MATRIX = new LocalizedFormats("matrix is singular");
    public static final /* enum */ LocalizedFormats SINGULAR_OPERATOR = new LocalizedFormats("operator is singular");
    public static final /* enum */ LocalizedFormats SUBARRAY_ENDS_AFTER_ARRAY_END = new LocalizedFormats("subarray ends after array end");
    public static final /* enum */ LocalizedFormats TOO_LARGE_CUTOFF_SINGULAR_VALUE = new LocalizedFormats("cutoff singular value is {0}, should be at most {1}");
    public static final /* enum */ LocalizedFormats TOO_LARGE_TOURNAMENT_ARITY = new LocalizedFormats("tournament arity ({0}) cannot be bigger than population size ({1})");
    public static final /* enum */ LocalizedFormats TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY = new LocalizedFormats("cannot discard {0} elements from a {1} elements array");
    public static final /* enum */ LocalizedFormats TOO_MANY_REGRESSORS = new LocalizedFormats("too many regressors ({0}) specified, only {1} in the model");
    public static final /* enum */ LocalizedFormats TOO_SMALL_COST_RELATIVE_TOLERANCE = new LocalizedFormats("cost relative tolerance is too small ({0}), no further reduction in the sum of squares is possible");
    public static final /* enum */ LocalizedFormats TOO_SMALL_INTEGRATION_INTERVAL = new LocalizedFormats("too small integration interval: length = {0}");
    public static final /* enum */ LocalizedFormats TOO_SMALL_ORTHOGONALITY_TOLERANCE = new LocalizedFormats("orthogonality tolerance is too small ({0}), solution is orthogonal to the jacobian");
    public static final /* enum */ LocalizedFormats TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE = new LocalizedFormats("parameters relative tolerance is too small ({0}), no further improvement in the approximate solution is possible");
    public static final /* enum */ LocalizedFormats TRUST_REGION_STEP_FAILED = new LocalizedFormats("trust region step has failed to reduce Q");
    public static final /* enum */ LocalizedFormats TWO_OR_MORE_CATEGORIES_REQUIRED = new LocalizedFormats("two or more categories required, got {0}");
    public static final /* enum */ LocalizedFormats TWO_OR_MORE_VALUES_IN_CATEGORY_REQUIRED = new LocalizedFormats("two or more values required in each category, one has {0}");
    public static final /* enum */ LocalizedFormats UNABLE_TO_BRACKET_OPTIMUM_IN_LINE_SEARCH = new LocalizedFormats("unable to bracket optimum in line search");
    public static final /* enum */ LocalizedFormats UNABLE_TO_COMPUTE_COVARIANCE_SINGULAR_PROBLEM = new LocalizedFormats("unable to compute covariances: singular problem");
    public static final /* enum */ LocalizedFormats UNABLE_TO_FIRST_GUESS_HARMONIC_COEFFICIENTS = new LocalizedFormats("unable to first guess the harmonic coefficients");
    public static final /* enum */ LocalizedFormats UNABLE_TO_ORTHOGONOLIZE_MATRIX = new LocalizedFormats("unable to orthogonalize matrix in {0} iterations");
    public static final /* enum */ LocalizedFormats UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN = new LocalizedFormats("unable to perform Q.R decomposition on the {0}x{1} jacobian matrix");
    public static final /* enum */ LocalizedFormats UNABLE_TO_SOLVE_SINGULAR_PROBLEM = new LocalizedFormats("unable to solve: singular problem");
    public static final /* enum */ LocalizedFormats UNBOUNDED_SOLUTION = new LocalizedFormats("unbounded solution");
    public static final /* enum */ LocalizedFormats UNKNOWN_MODE = new LocalizedFormats("unknown mode {0}, known modes: {1} ({2}), {3} ({4}), {5} ({6}), {7} ({8}), {9} ({10}) and {11} ({12})");
    public static final /* enum */ LocalizedFormats UNKNOWN_PARAMETER = new LocalizedFormats("unknown parameter {0}");
    public static final /* enum */ LocalizedFormats UNMATCHED_ODE_IN_EXPANDED_SET = new LocalizedFormats("ode does not match the main ode set in the extended set");
    public static final /* enum */ LocalizedFormats CANNOT_PARSE_AS_TYPE = new LocalizedFormats("string \"{0}\" unparseable (from position {1}) as an object of type {2}");
    public static final /* enum */ LocalizedFormats CANNOT_PARSE = new LocalizedFormats("string \"{0}\" unparseable (from position {1})");
    public static final /* enum */ LocalizedFormats UNPARSEABLE_3D_VECTOR = new LocalizedFormats("unparseable 3D vector: \"{0}\"");
    public static final /* enum */ LocalizedFormats UNPARSEABLE_COMPLEX_NUMBER = new LocalizedFormats("unparseable complex number: \"{0}\"");
    public static final /* enum */ LocalizedFormats UNPARSEABLE_REAL_VECTOR = new LocalizedFormats("unparseable real vector: \"{0}\"");
    public static final /* enum */ LocalizedFormats UNSUPPORTED_EXPANSION_MODE = new LocalizedFormats("unsupported expansion mode {0}, supported modes are {1} ({2}) and {3} ({4})");
    public static final /* enum */ LocalizedFormats UNSUPPORTED_OPERATION = new LocalizedFormats("unsupported operation");
    public static final /* enum */ LocalizedFormats ARITHMETIC_EXCEPTION = new LocalizedFormats("arithmetic exception");
    public static final /* enum */ LocalizedFormats ILLEGAL_STATE = new LocalizedFormats("illegal state");
    public static final /* enum */ LocalizedFormats USER_EXCEPTION = new LocalizedFormats("exception generated in user code");
    public static final /* enum */ LocalizedFormats URL_CONTAINS_NO_DATA = new LocalizedFormats("URL {0} contains no data");
    public static final /* enum */ LocalizedFormats VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC = new LocalizedFormats("{0} values have been added before statistic is configured");
    public static final /* enum */ LocalizedFormats VECTOR_LENGTH_MISMATCH = new LocalizedFormats("vector length mismatch: got {0} but expected {1}");
    public static final /* enum */ LocalizedFormats VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT = new LocalizedFormats("vector must have at least one element");
    public static final /* enum */ LocalizedFormats WEIGHT_AT_LEAST_ONE_NON_ZERO = new LocalizedFormats("weigth array must contain at least one non-zero value");
    public static final /* enum */ LocalizedFormats WRONG_BLOCK_LENGTH = new LocalizedFormats("wrong array shape (block length = {0}, expected {1})");
    public static final /* enum */ LocalizedFormats WRONG_NUMBER_OF_POINTS = new LocalizedFormats("{0} points are required, got only {1}");
    public static final /* enum */ LocalizedFormats NUMBER_OF_POINTS = new LocalizedFormats("number of points ({0})");
    public static final /* enum */ LocalizedFormats ZERO_DENOMINATOR = new LocalizedFormats("denominator must be different from 0");
    public static final /* enum */ LocalizedFormats ZERO_DENOMINATOR_IN_FRACTION = new LocalizedFormats("zero denominator in fraction {0}/{1}");
    public static final /* enum */ LocalizedFormats ZERO_FRACTION_TO_DIVIDE_BY = new LocalizedFormats("the fraction to divide by must not be zero: {0}/{1}");
    public static final /* enum */ LocalizedFormats ZERO_NORM = new LocalizedFormats("zero norm");
    public static final /* enum */ LocalizedFormats ZERO_NORM_FOR_ROTATION_AXIS = new LocalizedFormats("zero norm for rotation axis");
    public static final /* enum */ LocalizedFormats ZERO_NORM_FOR_ROTATION_DEFINING_VECTOR = new LocalizedFormats("zero norm for rotation defining vector");
    public static final /* enum */ LocalizedFormats ZERO_NOT_ALLOWED = new LocalizedFormats("zero not allowed here");
    private final String sourceFormat;
    private static final /* synthetic */ LocalizedFormats[] $VALUES;

    private LocalizedFormats(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    @Override
    public String getLocalizedString(Locale locale) {
        try {
            String path = LocalizedFormats.class.getName().replaceAll("\\.", "/");
            ResourceBundle bundle = ResourceBundle.getBundle("assets/" + path, locale);
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                return bundle.getString(this.toString());
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.sourceFormat;
    }

    static {
        $VALUES = new LocalizedFormats[]{ARGUMENT_OUTSIDE_DOMAIN, ARRAY_SIZE_EXCEEDS_MAX_VARIABLES, ARRAY_SIZES_SHOULD_HAVE_DIFFERENCE_1, ARRAY_SUMS_TO_ZERO, ASSYMETRIC_EIGEN_NOT_SUPPORTED, AT_LEAST_ONE_COLUMN, AT_LEAST_ONE_ROW, BANDWIDTH, BESSEL_FUNCTION_BAD_ARGUMENT, BESSEL_FUNCTION_FAILED_CONVERGENCE, BINOMIAL_INVALID_PARAMETERS_ORDER, BINOMIAL_NEGATIVE_PARAMETER, CANNOT_CLEAR_STATISTIC_CONSTRUCTED_FROM_EXTERNAL_MOMENTS, CANNOT_COMPUTE_0TH_ROOT_OF_UNITY, CANNOT_COMPUTE_BETA_DENSITY_AT_0_FOR_SOME_ALPHA, CANNOT_COMPUTE_BETA_DENSITY_AT_1_FOR_SOME_BETA, CANNOT_COMPUTE_NTH_ROOT_FOR_NEGATIVE_N, CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, CANNOT_FORMAT_INSTANCE_AS_3D_VECTOR, CANNOT_FORMAT_INSTANCE_AS_COMPLEX, CANNOT_FORMAT_INSTANCE_AS_REAL_VECTOR, CANNOT_FORMAT_OBJECT_TO_FRACTION, CANNOT_INCREMENT_STATISTIC_CONSTRUCTED_FROM_EXTERNAL_MOMENTS, CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, CANNOT_RETRIEVE_AT_NEGATIVE_INDEX, CANNOT_SET_AT_NEGATIVE_INDEX, CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, CANNOT_TRANSFORM_TO_DOUBLE, CARDAN_ANGLES_SINGULARITY, CLASS_DOESNT_IMPLEMENT_COMPARABLE, CLOSE_VERTICES, CLOSEST_ORTHOGONAL_MATRIX_HAS_NEGATIVE_DETERMINANT, COLUMN_INDEX_OUT_OF_RANGE, COLUMN_INDEX, CONSTRAINT, CONTINUED_FRACTION_INFINITY_DIVERGENCE, CONTINUED_FRACTION_NAN_DIVERGENCE, CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, CONTRACTION_CRITERIA_SMALLER_THAN_ONE, CONVERGENCE_FAILED, CROSSING_BOUNDARY_LOOPS, CROSSOVER_RATE, CUMULATIVE_PROBABILITY_RETURNED_NAN, DIFFERENT_ROWS_LENGTHS, DIFFERENT_ORIG_AND_PERMUTED_DATA, DIGEST_NOT_INITIALIZED, DIMENSIONS_MISMATCH_2x2, DIMENSIONS_MISMATCH_SIMPLE, DIMENSIONS_MISMATCH, DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, DISTRIBUTION_NOT_LOADED, DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, EDGE_CONNECTED_TO_ONE_FACET, ELITISM_RATE, EMPTY_CLUSTER_IN_K_MEANS, EMPTY_INTERPOLATION_SAMPLE, EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY, EMPTY_SELECTED_COLUMN_INDEX_ARRAY, EMPTY_SELECTED_ROW_INDEX_ARRAY, EMPTY_STRING_FOR_IMAGINARY_CHARACTER, ENDPOINTS_NOT_AN_INTERVAL, EQUAL_VERTICES_IN_SIMPLEX, EULER_ANGLES_SINGULARITY, EVALUATION, EXPANSION_FACTOR_SMALLER_THAN_ONE, FACET_ORIENTATION_MISMATCH, FACTORIAL_NEGATIVE_PARAMETER, FAILED_BRACKETING, FAILED_FRACTION_CONVERSION, FIRST_COLUMNS_NOT_INITIALIZED_YET, FIRST_ELEMENT_NOT_ZERO, FIRST_ROWS_NOT_INITIALIZED_YET, FRACTION_CONVERSION_OVERFLOW, FUNCTION_NOT_DIFFERENTIABLE, FUNCTION_NOT_POLYNOMIAL, GCD_OVERFLOW_32_BITS, GCD_OVERFLOW_64_BITS, HOLE_BETWEEN_MODELS_TIME_RANGES, ILL_CONDITIONED_OPERATOR, INCONSISTENT_STATE_AT_2_PI_WRAPPING, INDEX_LARGER_THAN_MAX, INDEX_NOT_POSITIVE, INDEX_OUT_OF_RANGE, INDEX, NOT_FINITE_NUMBER, INFINITE_BOUND, ARRAY_ELEMENT, INFINITE_ARRAY_ELEMENT, INFINITE_VALUE_CONVERSION, INITIAL_CAPACITY_NOT_POSITIVE, INITIAL_COLUMN_AFTER_FINAL_COLUMN, INITIAL_ROW_AFTER_FINAL_ROW, INPUT_DATA_FROM_UNSUPPORTED_DATASOURCE, INSTANCES_NOT_COMPARABLE_TO_EXISTING_VALUES, INSUFFICIENT_DATA, INSUFFICIENT_DATA_FOR_T_STATISTIC, INSUFFICIENT_DIMENSION, DIMENSION, INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, INSUFFICIENT_ROWS_AND_COLUMNS, INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, INTERNAL_ERROR, INVALID_BINARY_DIGIT, INVALID_BINARY_CHROMOSOME, INVALID_BRACKETING_PARAMETERS, INVALID_FIXED_LENGTH_CHROMOSOME, INVALID_IMPLEMENTATION, INVALID_INTERVAL_INITIAL_VALUE_PARAMETERS, INVALID_ITERATIONS_LIMITS, INVALID_MAX_ITERATIONS, NOT_ENOUGH_DATA_REGRESSION, INVALID_REGRESSION_ARRAY, INVALID_REGRESSION_OBSERVATION, INVALID_ROUNDING_METHOD, ITERATOR_EXHAUSTED, ITERATIONS, LCM_OVERFLOW_32_BITS, LCM_OVERFLOW_64_BITS, LIST_OF_CHROMOSOMES_BIGGER_THAN_POPULATION_SIZE, LOESS_EXPECTS_AT_LEAST_ONE_POINT, LOWER_BOUND_NOT_BELOW_UPPER_BOUND, LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, MAP_MODIFIED_WHILE_ITERATING, MULTISTEP_STARTER_STOPPED_EARLY, EVALUATIONS, MAX_COUNT_EXCEEDED, MAX_ITERATIONS_EXCEEDED, MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, MISMATCHED_LOESS_ABSCISSA_ORDINATE_ARRAYS, MUTATION_RATE, NAN_ELEMENT_AT_INDEX, NAN_VALUE_CONVERSION, NEGATIVE_BRIGHTNESS_EXPONENT, NEGATIVE_COMPLEX_MODULE, NEGATIVE_ELEMENT_AT_2D_INDEX, NEGATIVE_ELEMENT_AT_INDEX, NEGATIVE_NUMBER_OF_SUCCESSES, NUMBER_OF_SUCCESSES, NEGATIVE_NUMBER_OF_TRIALS, NUMBER_OF_INTERPOLATION_POINTS, NUMBER_OF_TRIALS, NOT_CONVEX, NOT_CONVEX_HYPERPLANES, ROBUSTNESS_ITERATIONS, START_POSITION, NON_CONVERGENT_CONTINUED_FRACTION, NON_INVERTIBLE_TRANSFORM, NON_POSITIVE_MICROSPHERE_ELEMENTS, NON_POSITIVE_POLYNOMIAL_DEGREE, NON_REAL_FINITE_ABSCISSA, NON_REAL_FINITE_ORDINATE, NON_REAL_FINITE_WEIGHT, NON_SQUARE_MATRIX, NORM, NORMALIZE_INFINITE, NORMALIZE_NAN, NOT_ADDITION_COMPATIBLE_MATRICES, NOT_DECREASING_NUMBER_OF_POINTS, NOT_DECREASING_SEQUENCE, NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, NOT_ENOUGH_POINTS_IN_SPLINE_PARTITION, NOT_INCREASING_NUMBER_OF_POINTS, NOT_INCREASING_SEQUENCE, NOT_MULTIPLICATION_COMPATIBLE_MATRICES, NOT_POSITIVE_DEFINITE_MATRIX, NON_POSITIVE_DEFINITE_MATRIX, NON_POSITIVE_DEFINITE_OPERATOR, NON_SELF_ADJOINT_OPERATOR, NON_SQUARE_OPERATOR, DEGREES_OF_FREEDOM, NOT_POSITIVE_DEGREES_OF_FREEDOM, NOT_POSITIVE_ELEMENT_AT_INDEX, NOT_POSITIVE_EXPONENT, NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, BASE, EXPONENT, NOT_POSITIVE_LENGTH, LENGTH, NOT_POSITIVE_MEAN, MEAN, NOT_POSITIVE_NUMBER_OF_SAMPLES, NUMBER_OF_SAMPLES, NOT_POSITIVE_PERMUTATION, PERMUTATION_SIZE, NOT_POSITIVE_POISSON_MEAN, NOT_POSITIVE_POPULATION_SIZE, POPULATION_SIZE, NOT_POSITIVE_ROW_DIMENSION, NOT_POSITIVE_SAMPLE_SIZE, NOT_POSITIVE_SCALE, SCALE, NOT_POSITIVE_SHAPE, SHAPE, NOT_POSITIVE_STANDARD_DEVIATION, STANDARD_DEVIATION, NOT_POSITIVE_UPPER_BOUND, NOT_POSITIVE_WINDOW_SIZE, NOT_POWER_OF_TWO, NOT_POWER_OF_TWO_CONSIDER_PADDING, NOT_POWER_OF_TWO_PLUS_ONE, NOT_STRICTLY_DECREASING_NUMBER_OF_POINTS, NOT_STRICTLY_DECREASING_SEQUENCE, NOT_STRICTLY_INCREASING_KNOT_VALUES, NOT_STRICTLY_INCREASING_NUMBER_OF_POINTS, NOT_STRICTLY_INCREASING_SEQUENCE, NOT_SUBTRACTION_COMPATIBLE_MATRICES, NOT_SUPPORTED_IN_DIMENSION_N, NOT_SYMMETRIC_MATRIX, NON_SYMMETRIC_MATRIX, NO_BIN_SELECTED, NO_CONVERGENCE_WITH_ANY_START_POINT, NO_DATA, NO_DEGREES_OF_FREEDOM, NO_DENSITY_FOR_THIS_DISTRIBUTION, NO_FEASIBLE_SOLUTION, NO_OPTIMUM_COMPUTED_YET, NO_REGRESSORS, NO_RESULT_AVAILABLE, NO_SUCH_MATRIX_ENTRY, NAN_NOT_ALLOWED, NULL_NOT_ALLOWED, ARRAY_ZERO_LENGTH_OR_NULL_NOT_ALLOWED, COVARIANCE_MATRIX, DENOMINATOR, DENOMINATOR_FORMAT, FRACTION, FUNCTION, IMAGINARY_FORMAT, INPUT_ARRAY, NUMERATOR, NUMERATOR_FORMAT, OBJECT_TRANSFORMATION, REAL_FORMAT, WHOLE_FORMAT, NUMBER_TOO_LARGE, NUMBER_TOO_SMALL, NUMBER_TOO_LARGE_BOUND_EXCLUDED, NUMBER_TOO_SMALL_BOUND_EXCLUDED, NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, NUMERATOR_OVERFLOW_AFTER_MULTIPLY, N_POINTS_GAUSS_LEGENDRE_INTEGRATOR_NOT_SUPPORTED, OBSERVED_COUNTS_ALL_ZERO, OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, BOBYQA_BOUND_DIFFERENCE_CONDITION, OUT_OF_BOUNDS_QUANTILE_VALUE, OUT_OF_BOUNDS_CONFIDENCE_LEVEL, OUT_OF_BOUND_SIGNIFICANCE_LEVEL, SIGNIFICANCE_LEVEL, OUT_OF_ORDER_ABSCISSA_ARRAY, OUT_OF_PLANE, OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, OUT_OF_RANGE, OUT_OF_RANGE_SIMPLE, OUT_OF_RANGE_LEFT, OUT_OF_RANGE_RIGHT, OUTLINE_BOUNDARY_LOOP_OPEN, OVERFLOW, OVERFLOW_IN_FRACTION, OVERFLOW_IN_ADDITION, OVERFLOW_IN_SUBTRACTION, OVERFLOW_IN_MULTIPLICATION, PERCENTILE_IMPLEMENTATION_CANNOT_ACCESS_METHOD, PERCENTILE_IMPLEMENTATION_UNSUPPORTED_METHOD, PERMUTATION_EXCEEDS_N, POLYNOMIAL, POLYNOMIAL_INTERPOLANTS_MISMATCH_SEGMENTS, POPULATION_LIMIT_NOT_POSITIVE, POWER_NEGATIVE_PARAMETERS, PROPAGATION_DIRECTION_MISMATCH, RANDOMKEY_MUTATION_WRONG_CLASS, ROOTS_OF_UNITY_NOT_COMPUTED_YET, ROTATION_MATRIX_DIMENSIONS, ROW_INDEX_OUT_OF_RANGE, ROW_INDEX, SAME_SIGN_AT_ENDPOINTS, SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, SAMPLE_SIZE_LARGER_THAN_POPULATION_SIZE, SIMPLEX_NEED_ONE_POINT, SIMPLE_MESSAGE, SINGULAR_MATRIX, SINGULAR_OPERATOR, SUBARRAY_ENDS_AFTER_ARRAY_END, TOO_LARGE_CUTOFF_SINGULAR_VALUE, TOO_LARGE_TOURNAMENT_ARITY, TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, TOO_MANY_REGRESSORS, TOO_SMALL_COST_RELATIVE_TOLERANCE, TOO_SMALL_INTEGRATION_INTERVAL, TOO_SMALL_ORTHOGONALITY_TOLERANCE, TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, TRUST_REGION_STEP_FAILED, TWO_OR_MORE_CATEGORIES_REQUIRED, TWO_OR_MORE_VALUES_IN_CATEGORY_REQUIRED, UNABLE_TO_BRACKET_OPTIMUM_IN_LINE_SEARCH, UNABLE_TO_COMPUTE_COVARIANCE_SINGULAR_PROBLEM, UNABLE_TO_FIRST_GUESS_HARMONIC_COEFFICIENTS, UNABLE_TO_ORTHOGONOLIZE_MATRIX, UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, UNABLE_TO_SOLVE_SINGULAR_PROBLEM, UNBOUNDED_SOLUTION, UNKNOWN_MODE, UNKNOWN_PARAMETER, UNMATCHED_ODE_IN_EXPANDED_SET, CANNOT_PARSE_AS_TYPE, CANNOT_PARSE, UNPARSEABLE_3D_VECTOR, UNPARSEABLE_COMPLEX_NUMBER, UNPARSEABLE_REAL_VECTOR, UNSUPPORTED_EXPANSION_MODE, UNSUPPORTED_OPERATION, ARITHMETIC_EXCEPTION, ILLEGAL_STATE, USER_EXCEPTION, URL_CONTAINS_NO_DATA, VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, VECTOR_LENGTH_MISMATCH, VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, WEIGHT_AT_LEAST_ONE_NON_ZERO, WRONG_BLOCK_LENGTH, WRONG_NUMBER_OF_POINTS, NUMBER_OF_POINTS, ZERO_DENOMINATOR, ZERO_DENOMINATOR_IN_FRACTION, ZERO_FRACTION_TO_DIVIDE_BY, ZERO_NORM, ZERO_NORM_FOR_ROTATION_AXIS, ZERO_NORM_FOR_ROTATION_DEFINING_VECTOR, ZERO_NOT_ALLOWED};
    }
}

