/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

class SigningServiceSignature
extends SignatureSpi {
    private final SigningService service;
    private final String signingAlgorithm;
    private SigningServicePrivateKey privateKey;
    private byte[] data;

    public SigningServiceSignature(SigningService service, String signingAlgorithm) {
        this.service = service;
        this.signingAlgorithm = signingAlgorithm;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        this.privateKey = (SigningServicePrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.data = new byte[len];
        System.arraycopy(b, off, this.data, 0, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.service.sign(this.privateKey, this.signingAlgorithm, this.data);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }
}

