/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.IDTracker;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.pagination.AbstractPageSequence;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.TopLevelLayoutManager;

public abstract class AbstractPageSequenceLayoutManager
extends AbstractLayoutManager
implements TopLevelLayoutManager {
    private static Log log = LogFactory.getLog(AbstractPageSequenceLayoutManager.class);
    protected AreaTreeHandler areaTreeHandler;
    protected IDTracker idTracker;
    protected AbstractPageSequence pageSeq;
    protected Page curPage;
    protected int currentPageNum;
    protected int startPageNum;

    public AbstractPageSequenceLayoutManager(AreaTreeHandler ath, AbstractPageSequence pseq) {
        super(pseq);
        this.areaTreeHandler = ath;
        this.idTracker = ath.getIDTracker();
        this.pageSeq = pseq;
    }

    public LayoutManagerMaker getLayoutManagerMaker() {
        return this.areaTreeHandler.getLayoutManagerMaker();
    }

    @Override
    public Page getCurrentPage() {
        return this.curPage;
    }

    protected void setCurrentPage(Page currentPage) {
        this.curPage = currentPage;
    }

    protected int getCurrentPageNum() {
        return this.currentPageNum;
    }

    @Override
    public void initialize() {
        this.startPageNum = this.pageSeq.getStartingPageNumber();
        this.currentPageNum = this.startPageNum - 1;
        this.curPage = null;
    }

    public PageViewport getFirstPVWithID(String idref) {
        List<PageViewport> list = this.idTracker.getPageViewportsContainingID(idref);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public PageViewport getLastPVWithID(String idref) {
        List<PageViewport> list = this.idTracker.getPageViewportsContainingID(idref);
        if (list != null && list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public void addIDToPage(String id) {
        if (id != null && id.length() > 0) {
            this.idTracker.associateIDWithPageViewport(id, this.curPage.getPageViewport());
        }
    }

    public boolean associateLayoutManagerID(String id) {
        if (log.isDebugEnabled()) {
            log.debug("associateLayoutManagerID(" + id + ")");
        }
        if (!this.idTracker.alreadyResolvedID(id)) {
            this.idTracker.signalPendingID(id);
            return false;
        }
        return true;
    }

    public void notifyEndOfLayout(String id) {
        this.idTracker.signalIDProcessed(id);
    }

    public void addUnresolvedArea(String id, Resolvable res) {
        this.curPage.getPageViewport().addUnresolvedIDRef(id, res);
        this.idTracker.addUnresolvedIDRef(id, this.curPage.getPageViewport());
    }

    public RetrieveMarker resolveRetrieveMarker(RetrieveMarker rm) {
        AreaTreeModel areaTreeModel = this.areaTreeHandler.getAreaTreeModel();
        String name = rm.getRetrieveClassName();
        int boundary = rm.getRetrieveBoundary();
        Marker mark2 = this.getCurrentPV().resolveMarker(rm);
        if (mark2 == null && boundary != 104) {
            boolean doc = boundary == 34;
            int seq = areaTreeModel.getPageSequenceCount();
            int page = areaTreeModel.getPageCount(seq) - 1;
            while (page < 0 && doc && seq > 1) {
                page = areaTreeModel.getPageCount(--seq) - 1;
            }
            while (page >= 0) {
                PageViewport pv = areaTreeModel.getPage(seq, page);
                int originalPosition = rm.getPosition();
                rm.changePositionTo(74);
                mark2 = pv.resolveMarker(rm);
                rm.changePositionTo(originalPosition);
                if (mark2 != null) break;
                if (--page >= 0 || !doc || seq <= 1) continue;
                page = areaTreeModel.getPageCount(--seq) - 1;
            }
        }
        if (mark2 == null) {
            log.debug("found no marker with name: " + name);
            return null;
        }
        rm.bindMarker(mark2);
        return rm;
    }

    protected abstract Page createPage(int var1, boolean var2);

    protected Page makeNewPage(boolean isBlank) {
        if (this.curPage != null) {
            this.finishPage();
        }
        ++this.currentPageNum;
        this.curPage = this.createPage(this.currentPageNum, isBlank);
        if (log.isDebugEnabled()) {
            log.debug("[" + this.curPage.getPageViewport().getPageNumberString() + (isBlank ? "*" : "") + "]");
        }
        this.addIDToPage(this.pageSeq.getRoot().getId());
        this.addIDToPage(this.pageSeq.getId());
        return this.curPage;
    }

    protected void finishPage() {
        if (log.isTraceEnabled()) {
            this.curPage.getPageViewport().dumpMarkers();
        }
        this.idTracker.tryIDResolution(this.curPage.getPageViewport());
        this.areaTreeHandler.getAreaTreeModel().addPage(this.curPage.getPageViewport());
        if (log.isDebugEnabled()) {
            log.debug("page finished: " + this.curPage.getPageViewport().getPageNumberString() + ", current num: " + this.currentPageNum);
        }
        this.curPage = null;
    }

    @Override
    public void doForcePageCount(Numeric nextPageSeqInitialPageNumber) {
        int forcePageCount = this.pageSeq.getForcePageCount();
        if (nextPageSeqInitialPageNumber != null && forcePageCount == 9) {
            if (nextPageSeqInitialPageNumber.getEnum() != 0) {
                int nextPageSeqPageNumberType = nextPageSeqInitialPageNumber.getEnum();
                forcePageCount = nextPageSeqPageNumberType == 11 ? 40 : (nextPageSeqPageNumberType == 10 ? 41 : 88);
            } else {
                int nextPageSeqPageStart = nextPageSeqInitialPageNumber.getValue();
                nextPageSeqPageStart = nextPageSeqPageStart > 0 ? nextPageSeqPageStart : 1;
                forcePageCount = nextPageSeqPageStart % 2 == 0 ? 41 : 40;
            }
        }
        if (forcePageCount == 43) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 != 0) {
                this.curPage = this.makeNewPage(true);
            }
        } else if (forcePageCount == 99) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 == 0) {
                this.curPage = this.makeNewPage(true);
            }
        } else if (forcePageCount == 40) {
            if (this.currentPageNum % 2 != 0) {
                this.curPage = this.makeNewPage(true);
            }
        } else if (forcePageCount == 41 && this.currentPageNum % 2 == 0) {
            this.curPage = this.makeNewPage(true);
        }
        if (this.curPage != null) {
            this.finishPage();
        }
        while (forcePageCount != 88 && this.getCurrentPageNum() < this.getLastPageNumber()) {
            this.curPage = this.makeNewPage(true);
            this.finishPage();
        }
    }

    @Override
    public void reset() {
        throw new IllegalStateException();
    }

    protected int getLastPageNumber() {
        return this.currentPageNum;
    }
}

