/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFXObject;

public class PDFFormXObject
extends PDFXObject {
    private PDFStream contents;

    public PDFFormXObject(int xnumber, PDFStream contents, PDFReference resources) {
        super(contents.getDictionary());
        this.put("Name", new PDFName("Form" + xnumber));
        this.contents = contents;
        this.put("Type", new PDFName("XObject"));
        this.put("Subtype", new PDFName("Form"));
        this.put("FormType", 1);
        this.setMatrix(new AffineTransform());
        if (resources != null) {
            this.put("Resources", resources);
        }
    }

    public void setBBox(Rectangle2D bbox) {
        PDFArray array2 = (PDFArray)this.get("BBox");
        if (array2 == null) {
            array2 = new PDFArray(this);
            array2.add(bbox.getX());
            array2.add(bbox.getY());
            array2.add(bbox.getWidth());
            array2.add(bbox.getHeight());
            this.put("BBox", array2);
        } else {
            array2.set(0, bbox.getX());
            array2.set(1, bbox.getY());
            array2.set(2, bbox.getWidth());
            array2.set(3, bbox.getHeight());
        }
    }

    public Rectangle2D getBBox() {
        PDFArray array2 = (PDFArray)this.get("BBox");
        if (array2 != null) {
            Rectangle2D.Double rect = new Rectangle2D.Double();
            double x = ((Number)array2.get(0)).doubleValue();
            double y = ((Number)array2.get(1)).doubleValue();
            double w = ((Number)array2.get(2)).doubleValue();
            double h = ((Number)array2.get(3)).doubleValue();
            rect.setFrame(x, y, w, h);
            return rect;
        }
        return null;
    }

    public void setMatrix(AffineTransform at) {
        PDFArray array2 = (PDFArray)this.get("Matrix");
        double[] m = new double[6];
        at.getMatrix(m);
        if (array2 == null) {
            array2 = new PDFArray(this);
            array2.add(m[0]);
            array2.add(m[1]);
            array2.add(m[2]);
            array2.add(m[3]);
            array2.add(m[4]);
            array2.add(m[5]);
            this.put("Matrix", array2);
        } else {
            array2.set(0, m[0]);
            array2.set(1, m[1]);
            array2.set(2, m[2]);
            array2.set(3, m[3]);
            array2.set(4, m[4]);
            array2.set(5, m[5]);
        }
    }

    public AffineTransform getMatrix() {
        PDFArray array2 = (PDFArray)this.get("Matrix");
        if (array2 != null) {
            AffineTransform at = new AffineTransform();
            double m00 = ((Number)array2.get(0)).doubleValue();
            double m10 = ((Number)array2.get(1)).doubleValue();
            double m01 = ((Number)array2.get(2)).doubleValue();
            double m11 = ((Number)array2.get(3)).doubleValue();
            double m02 = ((Number)array2.get(4)).doubleValue();
            double m12 = ((Number)array2.get(5)).doubleValue();
            at.setTransform(m00, m10, m01, m11, m02, m12);
            return at;
        }
        return null;
    }

    public void setData(byte[] data) throws IOException {
        this.contents.setData(data);
    }

    @Override
    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.contents.outputRawStreamData(out);
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        int len = super.output(stream);
        this.contents = null;
        return len;
    }

    @Override
    protected void populateStreamDict(Object lengthEntry) {
        if (this.get("Matrix") == null) {
            this.put("Matrix", new PDFArray((PDFObject)this, new int[]{1, 0, 0, 1, 0, 0}));
        }
        super.populateStreamDict(lengthEntry);
    }
}

