/*
 * Decompiled with CFR 0.152.
 */
package pe;

import common.CommonUtils;
import common.MudgeSanity;
import common.Packer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pe.BOFUtils;
import pe.OBJParser;
import pe.Relocation;

public class OBJExecutable {
    protected OBJParser info = null;
    protected byte[] data;
    protected List errors = new LinkedList();
    protected String epfunc = "";
    protected String exesect = "";

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public String getErrors() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.errors) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void error(String string) {
        this.errors.add(string);
    }

    public OBJExecutable(byte[] byArray, String string) {
        this.data = byArray;
        this.epfunc = string;
    }

    public OBJExecutable(byte[] byArray) {
        this(byArray, "go");
    }

    public OBJParser getInfo() {
        return this.info;
    }

    public void parse() {
        try {
            this.info = OBJParser.load(this.data);
            this.exesect = this.info.hasSection(".text") ? ".text" : this.info.getExeSect();
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
            MudgeSanity.logException("Error parsing object file", exception, false);
            return;
        }
    }

    public int getEntryPoint() {
        int n = this.info.get("NumberOfSymbols");
        for (int i = 0; i < n; ++i) {
            String string = this.info.getString("Symbol." + i + ".e");
            if (!("_" + this.epfunc).equals(string) && !this.epfunc.equals(string)) continue;
            return this.info.get("Symbol." + i + ".e_value");
        }
        this.error("Entry function '" + this.epfunc + "' is not defined.");
        return 0;
    }

    private byte[] A(String string) {
        int n = this.info.sectionStart(string);
        int n2 = this.info.sectionSize(string);
        return Arrays.copyOfRange(this.data, n, n + n2);
    }

    public byte[] getCode() {
        byte[] byArray = this.A(this.exesect);
        if (byArray.length == 0) {
            this.error("No .text section in object file");
        }
        return byArray;
    }

    public byte[] getRData() {
        return this.A(".rdata");
    }

    public byte[] getData() {
        return this.A(".data");
    }

    public byte[] getXData() {
        return this.A(".xdata");
    }

    public byte[] getPData() {
        return this.A(".pdata");
    }

    public int getBssSize() {
        return this.info.sectionSize(".bss");
    }

    public short getRelocSection(String string) {
        if (this.exesect.equals(string)) {
            return 1026;
        }
        if (".data".equals(string)) {
            return 1025;
        }
        if (".pdata".equals(string)) {
            return 1030;
        }
        return 0;
    }

    public byte[] getRelocations() {
        Packer packer = new Packer();
        packer.little();
        block0: for (String string : this.info.getSectionsTable()) {
            short s = 0;
            for (int i = 0; i < this.info.relocationsCount(string); ++i) {
                Relocation relocation = this.info.getRelocation(string, i);
                if (i == 0 && (s = this.getRelocSection(string)) == 0) continue block0;
                if (".rdata".equals(relocation.getSection())) {
                    packer.addInt(s);
                    packer.addShort(relocation.getType());
                    packer.addShort(1024);
                    packer.addInt(relocation.getOffset());
                    packer.addInt(relocation.getOffsetInSection());
                    continue;
                }
                if (".data".equals(relocation.getSection())) {
                    packer.addInt(s);
                    packer.addShort(relocation.getType());
                    packer.addShort(1025);
                    packer.addInt(relocation.getOffset());
                    packer.addInt(relocation.getOffsetInSection());
                    continue;
                }
                if (".xdata".equals(relocation.getSection())) {
                    packer.addInt(s);
                    packer.addShort(relocation.getType());
                    packer.addShort(1029);
                    packer.addInt(relocation.getOffset());
                    packer.addInt(relocation.getOffsetInSection());
                    continue;
                }
                if (this.exesect.equals(relocation.getSection())) {
                    packer.addInt(s);
                    packer.addShort(relocation.getType());
                    packer.addShort(1026);
                    packer.addInt(relocation.getOffset());
                    packer.addInt(relocation.getOffsetInSection());
                    continue;
                }
                if (".bss".equals(relocation.getSection())) {
                    packer.addInt(s);
                    packer.addShort(relocation.getType());
                    packer.addShort(1031);
                    packer.addInt(relocation.getOffset());
                    packer.addInt(relocation.getOffsetInSection());
                    continue;
                }
                if (BOFUtils.isInternalFunction(relocation.getSymbol())) {
                    packer.addInt(s);
                    packer.addShort(relocation.getType());
                    packer.addShort(BOFUtils.findInternalFunction(relocation.getSymbol()));
                    packer.addInt(relocation.getOffset());
                    packer.addInt(0);
                    continue;
                }
                if (BOFUtils.isDynamicFunction(relocation.getSymbol())) {
                    packer.addInt(s);
                    packer.addShort(relocation.getType());
                    packer.addShort(1027);
                    packer.addInt(relocation.getOffset());
                    packer.addInt(0);
                    packer.big();
                    packer.addLengthAndStringASCIIZ(BOFUtils.getModule(relocation.getSymbol()));
                    packer.addLengthAndStringASCIIZ(BOFUtils.getFunction(relocation.getSymbol()));
                    packer.little();
                    continue;
                }
                this.error("Unknown symbol '" + relocation.getSymbol() + "'");
            }
        }
        packer.addInt(1026);
        packer.addShort(0);
        packer.addShort(1028);
        packer.addInt(0);
        packer.addInt(0);
        return packer.getBytes();
    }

    public void walkRelocations() {
        for (String string : this.info.getSectionsTable()) {
            System.out.println("Section: " + string);
            for (int i = 0; i < this.info.relocationsCount(string); ++i) {
                System.out.println(this.info.getRelocation(string, i));
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        byte[] byArray = CommonUtils.readFile(stringArray[0]);
        OBJExecutable oBJExecutable = new OBJExecutable(byArray);
        oBJExecutable.parse();
        OBJParser.dump(stringArray);
        CommonUtils.print_stat("RELOCATIONS");
        oBJExecutable.walkRelocations();
        int n = oBJExecutable.getCode().length;
        n += oBJExecutable.getRData().length;
        n += oBJExecutable.getData().length;
        n += oBJExecutable.getXData().length;
        n += oBJExecutable.getPData().length;
        CommonUtils.print_stat("SIZE: " + (n += oBJExecutable.getRelocations().length) + " bytes");
    }
}

