/*
 * Decompiled with CFR 0.152.
 */
package pe;

import common.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import pe.PEParser;

public class PEEditor {
    protected PEParser info = null;
    protected byte[] data;
    protected byte[] bdata = new byte[8];
    protected ByteBuffer buffer = null;
    protected int origch = 0;

    public byte[] getImage() {
        return this.data;
    }

    public void checkAssertions() {
        this.getInfo();
        int n = -8483;
        if ((this.origch & n) != 0) {
            CommonUtils.print_error("Beacon DLL has a Characteristic that's unexpected\n\tFlags: " + Integer.toBinaryString(n) + "\n\tOrigc: " + Integer.toBinaryString(this.origch));
        }
    }

    public boolean patchCode(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = this.getInfo().get(".text.PointerToRawData");
        int n3 = CommonUtils.indexOf(this.data, byArray, n2, n = n2 + this.getInfo().get(".text.SizeOfRawData"));
        if (n3 == -1) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            this.data[n3 + i] = byArray2[i];
        }
        return true;
    }

    public PEParser getInfo() {
        if (this.info == null) {
            this.info = PEParser.load(this.data);
            this.origch = this.getInfo().get("Characteristics");
        }
        return this.info;
    }

    public PEEditor(byte[] byArray) {
        this.data = byArray;
        this.buffer = ByteBuffer.wrap(this.bdata);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void updateChecksum() {
        long l = this.getInfo().checksum();
        this.setChecksum(l);
    }

    public void setModuleStomp(String string) {
        this.setCharacteristic(16384, true);
        this.setString(64, CommonUtils.randomData(64));
        String string2 = string;
        int n = 1;
        int n2 = string.indexOf(43);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            n = CommonUtils.toNumber(string.substring(n2 + 3), 1);
        }
        this.setLong(64, n);
        this.setStringZ(68, string2);
    }

    public void stompPE() {
        this.setCharacteristic(1, true);
    }

    public void insertRichHeader(byte[] byArray) {
        this.removeRichHeader();
        if (byArray.length == 0) {
            return;
        }
        if (byArray.length % 4 != 0) {
            CommonUtils.print_opsec("[OPSEC] Rich Header length (" + byArray.length + ") is not 4-byte aligned.");
        }
        long l = this.getInfo().get("e_lfanew");
        this.setValueAt("e_lfanew", l + (long)byArray.length);
        byte[] byArray2 = Arrays.copyOfRange(this.data, 0, 128);
        byte[] byArray3 = Arrays.copyOfRange(this.data, (int)l, 1024 - byArray.length);
        byte[] byArray4 = CommonUtils.join(byArray2, byArray, byArray3);
        System.arraycopy(byArray4, 0, this.data, 0, 1024);
        this.info = PEParser.load(this.data);
    }

    public void removeRichHeader() {
        if (this.getInfo().getRichHeaderSize() == 0) {
            return;
        }
        long l = this.getInfo().get("e_lfanew");
        this.setValueAt("e_lfanew", 128L);
        byte[] byArray = Arrays.copyOfRange(this.data, 0, 128);
        byte[] byArray2 = Arrays.copyOfRange(this.data, (int)l, 1024);
        byte[] byArray3 = new byte[1024 - (byArray.length + byArray2.length)];
        byte[] byArray4 = CommonUtils.join(byArray, byArray2, byArray3);
        System.arraycopy(byArray4, 0, this.data, 0, 1024);
        this.info = PEParser.load(this.data);
    }

    public void setExportName(String string) {
        if (string.equals(this.getInfo().getString("Export.Name"))) {
            return;
        }
        int n = CommonUtils.bString(this.data).indexOf(string + '\u0000');
        if (n > 0) {
            int n2 = this.getInfo().getLocation("Export.Name");
            int n3 = this.getInfo().getPointerForLocation(0, n);
            this.setLong(n2, n3);
        } else {
            CommonUtils.print_warn("setExportName() failed. " + string + " not found in strings table");
        }
    }

    public void setChecksum(long l) {
        this.setLong(this.getInfo().getLocation("CheckSum"), l);
    }

    public void setAddressOfEntryPoint(long l) {
        this.setValueAt("AddressOfEntryPoint", l);
    }

    public void setEntryPoint(long l) {
        long l2 = this.getInfo().get("AddressOfEntryPoint");
        this.setValueAt("LoaderFlags", l2);
        this.setCharacteristic(4096, true);
        this.setAddressOfEntryPoint(l);
    }

    public void setString(int n, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.data[i + n] = byArray[i];
        }
    }

    public void setStringZ(int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.data[i + n] = (byte)string.charAt(i);
        }
        this.data[n + string.length()] = 0;
    }

    public int getInt(int n) {
        CommonUtils.clearBuffer(this.buffer);
        for (int i = 0; i < 4; ++i) {
            this.buffer.put(i, this.data[i + n]);
        }
        return (int)this.getInfo().fixAddress(this.buffer.getInt());
    }

    public void setLong(int n, long l) {
        CommonUtils.clearBuffer(this.buffer);
        this.buffer.putLong(0, l);
        for (int i = 0; i < 4; ++i) {
            this.data[i + n] = this.bdata[i];
        }
    }

    public void setShort(int n, long l) {
        CommonUtils.clearBuffer(this.buffer);
        this.buffer.putShort(0, (short)l);
        for (int i = 0; i < 2; ++i) {
            this.data[i + n] = this.bdata[i];
        }
    }

    public void setCharacteristic(int n, boolean bl) {
        int n2 = this.getInfo().getLocation("Characteristics");
        this.origch = bl ? (this.origch |= n) : (this.origch &= ~n);
        this.setShort(n2, this.origch);
    }

    public void setSectionCharacteristics(String string, long l) {
        int n = this.getInfo().getLocation(string + ".Characteristics");
        this.setLong(n, l);
    }

    public void setCompileTime(String string) {
        this.setCompileTime(CommonUtils.parseDate(string, "dd MMM yyyy HH:mm:ss"));
    }

    public void setCompileTime(long l) {
        int n = this.getInfo().getLocation("TimeDateStamp");
        this.setLong(n, l / 1000L);
    }

    public void setValueAt(String string, long l) {
        int n = this.getInfo().getLocation(string);
        this.setLong(n, l);
    }

    public void setImageSize(long l) {
        int n = this.getInfo().getLocation("SizeOfImage");
        this.setLong(n, l);
    }

    public void setRWXHint(boolean bl) {
        this.setCharacteristic(32768, bl);
    }

    public void stomp(int n) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.data[n] != 0) {
            stringBuffer.append((char)this.data[n]);
            this.data[n] = 0;
            ++n;
            ++n2;
        }
        this.data[n] = 0;
    }

    public void mask_PostEx(int n, int n2, byte by) {
        int n3 = n;
        while (n3 < n + n2) {
            int n4 = n3++;
            this.data[n4] = (byte)(this.data[n4] ^ by);
        }
    }

    public void mask_AggScript(int n, int n2, byte by) {
        int n3 = n;
        while (n3 < n + n2) {
            int n4 = n3++;
            this.data[n4] = (byte)(this.data[n4] ^ by);
        }
    }

    public void maskSection_AggScript(String string, byte by) {
        if (!this.getInfo().hasSection(string)) {
            CommonUtils.print_stat("Will not mask '" + string + "'");
            return;
        }
        int n = this.getInfo().get(string + ".PointerToRawData");
        int n2 = this.getInfo().get(string + ".SizeOfRawData");
        this.mask_AggScript(n, n2, by);
    }

    public void maskString_AggScript(int n, byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.data[n] != 0) {
            stringBuffer.append((char)this.data[n]);
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] ^ by);
        }
        int n3 = n;
        this.data[n3] = (byte)(this.data[n3] ^ by);
        if (stringBuffer.toString().length() >= 63) {
            CommonUtils.print_error("String '" + stringBuffer.toString() + "' is >=63 characters! Obfuscate WILL crash");
        }
    }

    public void mask_Beacon(int n, int n2, byte[] byArray) {
        for (int i = n; i < n + n2; ++i) {
            int n3 = i;
            this.data[n3] = (byte)(this.data[n3] ^ byArray[(i - n) % byArray.length]);
        }
    }

    public void maskString_Beacon(int n, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (this.data[n] != 0) {
            stringBuffer.append((char)this.data[n]);
            int n3 = n++;
            this.data[n3] = (byte)(this.data[n3] ^ byArray[n2 % byArray.length]);
            ++n2;
        }
        int n4 = n;
        this.data[n4] = (byte)(this.data[n4] ^ byArray[n2 % byArray.length]);
        if (stringBuffer.toString().length() >= 63) {
            CommonUtils.print_error("String '" + stringBuffer.toString() + "' is >=63 characters! Obfuscate WILL crash");
        }
    }

    public void obfuscate(boolean bl, boolean bl2) {
        if (bl) {
            this._obfuscate(bl2);
            this.obfuscatePEHeader();
        } else {
            this.setLong(this.getInfo().getLocation("NumberOfSymbols"), 0L);
        }
    }

    public void obfuscatePEHeader() {
        int n = this.getInfo().get("e_lfanew");
        byte[] byArray = CommonUtils.randomData(n - 64);
        this.setString(64, byArray);
        n = this.getInfo().get("SizeOfHeaders") - this.getInfo().getLocation("HeaderSlack");
        byArray = CommonUtils.randomData(n - 4);
        this.setString(this.getInfo().getLocation("HeaderSlack"), byArray);
    }

    public void maskSection_Beacon(String string, byte[] byArray) {
        if (!this.getInfo().hasSection(string)) {
            CommonUtils.print_stat("Will not mask '" + string + "'");
            return;
        }
        int n = this.getInfo().get(string + ".PointerToRawData");
        int n2 = this.getInfo().get(string + ".SizeOfRawData");
        this.mask_Beacon(n, n2, byArray);
    }

    protected void _obfuscate(boolean bl) {
        byte[] byArray = new byte[]{(byte)(CommonUtils.rand(252) + 1), (byte)(CommonUtils.rand(252) + 1), (byte)(CommonUtils.rand(252) + 1), (byte)(CommonUtils.rand(252) + 1)};
        int n = CommonUtils.toIntLittleEndian(byArray);
        this.setLong(this.getInfo().getLocation("NumberOfSymbols"), n);
        if (!bl) {
            Iterator iterator = this.getInfo().stringIterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                this.maskString_Beacon(n2, byArray);
            }
        }
        this.maskSection_Beacon(".text", byArray);
    }

    public static void main(String[] stringArray) {
        byte[] byArray = CommonUtils.readFile(stringArray[0]);
        PEEditor pEEditor = new PEEditor(byArray);
        pEEditor.setCompileTime(System.currentTimeMillis() + 3600000L);
        pEEditor.setImageSize(512000L);
        pEEditor.setRWXHint(true);
        boolean bl = false;
        boolean bl2 = true;
        pEEditor.obfuscate(bl, bl2);
        PEParser pEParser = PEParser.load(pEEditor.getImage());
        System.out.println(pEParser.toString());
    }
}

