/*
 * Decompiled with CFR 0.152.
 */
package pe;

import common.CommonUtils;
import java.util.Iterator;
import pe.OBJParser;

public class Relocation {
    protected OBJParser info;
    protected String section;
    protected int index;
    public static final int RELOC_REL32 = 20;
    public static final int RELOC_ADDR32 = 6;
    public static final int RELOC64_ADDR64 = 1;
    public static final int RELOC64_ADDR32NB = 3;
    public static final int RELOC64_REL32 = 4;

    public Relocation(OBJParser oBJParser, String string, int n) {
        this.info = oBJParser;
        this.index = n;
        this.section = string;
    }

    public int getOffset() {
        return this.info.get(this.section + ".Relocation." + this.index + ".r_vaddr");
    }

    public int getType() {
        return this.info.get(this.section + ".Relocation." + this.index + ".r_type");
    }

    public String getSymbol() {
        int n = this.info.get(this.section + ".Relocation." + this.index + ".r_symndx");
        return this.info.getString("Symbol." + n + ".e");
    }

    public String getSection() {
        int n = this.info.get(this.section + ".Relocation." + this.index + ".r_symndx");
        int n2 = this.info.get("Symbol." + n + ".e_scnum");
        if (n2 == 0) {
            return "";
        }
        if (n2 == -1) {
            return "<e_value is a constant>";
        }
        if (n2 == -2) {
            return "<debug symbol>";
        }
        Iterator iterator = this.info.getSectionsTable().iterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (n3 == n2) {
                return string;
            }
            ++n3;
        }
        return "<unknown>";
    }

    public int getOffsetInSection() {
        int n = this.info.get(this.section + ".Relocation." + this.index + ".r_symndx");
        return this.info.get("Symbol." + n + ".e_value");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.section.startsWith(".text")) {
            stringBuffer.append(".text");
        } else if (".data".equals(this.section)) {
            stringBuffer.append(".data");
        } else if (".pdata".equals(this.section)) {
            stringBuffer.append(".pdata");
        } else {
            stringBuffer.append("Unsupported relocation section " + this.section);
        }
        stringBuffer.append(" ");
        if (this.getType() == 6) {
            stringBuffer.append("RELOC_ADDR32");
        } else if (this.getType() == 20) {
            stringBuffer.append("RELOC_REL32");
        } else if (this.getType() == 4) {
            stringBuffer.append("RELOC64_REL32");
        } else if (this.getType() == 3) {
            stringBuffer.append("RELOC64_ADDR32NB");
        } else if (this.getType() == 1) {
            stringBuffer.append("RELOC64_ADDR64");
        } else {
            stringBuffer.append("RELOC_UNK_" + this.getType());
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getOffset());
        stringBuffer.append(" 0x");
        stringBuffer.append(CommonUtils.toHex(this.getOffset()));
        stringBuffer.append(" ");
        stringBuffer.append(this.getSymbol());
        stringBuffer.append(" (");
        stringBuffer.append(this.getSection());
        if ("".equals(this.getSection())) {
            stringBuffer.append(")");
        } else {
            stringBuffer.append(",");
            stringBuffer.append(this.getOffsetInSection());
            stringBuffer.append(" 0x");
            stringBuffer.append(CommonUtils.toHex(this.getOffsetInSection()));
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

