/*
 * Decompiled with CFR 0.152.
 */
package report;

import common.CommonUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import report.Content;
import report.ReportElement;

public class Bookmarks
implements ReportElement {
    protected LinkedHashMap bookmarks = new LinkedHashMap();
    protected Map references = new HashMap();

    public String register(String string) {
        String string2 = CommonUtils.garbage(string);
        this.references.put(string, string2);
        return string2;
    }

    public boolean isRegistered(String string) {
        if (this.references.get(string) == null) {
            return false;
        }
        return !"".equals(this.references.get(string));
    }

    public void bookmark(String string) {
        this.bookmarks.put(string, new LinkedList());
    }

    public void bookmark(String string, String string2) {
        LinkedList linkedList = (LinkedList)this.bookmarks.get(string);
        if (linkedList == null) {
            this.bookmarks.put(string, new LinkedList());
            this.bookmark(string, string2);
        } else {
            linkedList.add(string2);
        }
    }

    public void cleanup() {
        Iterator iterator = this.bookmarks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            LinkedList linkedList = (LinkedList)entry.getValue();
            if (!this.isRegistered(string) && linkedList.size() == 0) {
                iterator.remove();
            }
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (this.isRegistered(string2)) continue;
                iterator2.remove();
            }
        }
    }

    @Override
    public void publish(StringBuffer stringBuffer) {
        this.cleanup();
        if (this.bookmarks.size() == 0) {
            return;
        }
        stringBuffer.append("<fo:bookmark-tree>\n");
        for (Map.Entry entry : this.bookmarks.entrySet()) {
            String string = (String)entry.getKey();
            LinkedList linkedList = (LinkedList)entry.getValue();
            Object v = this.references.get(string);
            if (null == v && linkedList.size() > 0) {
                v = this.references.get(linkedList.get(0));
            }
            stringBuffer.append("\t<fo:bookmark internal-destination=\"" + v + "\">\n");
            stringBuffer.append("\t\t<fo:bookmark-title>" + Content.fixText(string) + "</fo:bookmark-title>\n");
            for (String string2 : linkedList) {
                stringBuffer.append("\t\t<fo:bookmark internal-destination=\"" + this.references.get(string2) + "\">\n");
                stringBuffer.append("\t\t\t<fo:bookmark-title>" + Content.fixText(string2) + "</fo:bookmark-title>\n");
                stringBuffer.append("\t\t</fo:bookmark>\n");
            }
            stringBuffer.append("\t</fo:bookmark>\n");
        }
        stringBuffer.append("</fo:bookmark-tree>\n");
    }
}

