/*
 * Decompiled with CFR 0.152.
 */
package report;

import common.CommonUtils;
import common.RegexParser;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import report.Document;
import report.FoBlock;
import report.KVTable;
import report.Layout;
import report.ListItem;
import report.NoBreak;
import report.Output;
import report.Piece;
import report.ReportElement;
import report.ReportUtils;
import report.Table;
import report.UnorderedList;

public class Content
implements ReportElement {
    protected List elements = new LinkedList();
    protected Document parent = null;

    public static boolean isAllowed(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c >= ' ' && c <= '\ud7ff') {
            return true;
        }
        if (c >= '\ue000' && c <= '\ufffd') {
            return true;
        }
        return c >= '\u10000' && c <= '\u10ffff';
    }

    public static String fixText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (cArray[i] == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (cArray[i] == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (cArray[i] == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (cArray[i] == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (!Content.isAllowed(cArray[i])) continue;
            if (cArray[i] > '\u00ff') {
                String string2 = CommonUtils.toHex(cArray[i]);
                String string3 = CommonUtils.padr(string2, "0", 4);
                stringBuffer.append("&#x");
                stringBuffer.append(string3);
                stringBuffer.append(";");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public Content(Document document) {
        this.parent = document;
    }

    public void h1(String string) {
        this.h1(string, string, "left");
    }

    public void h1(String string, String string2, String string3) {
        string = Content.fixText(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<fo:block font-size=\"18pt\"\n");
        stringBuffer.append("\t\tfont-family=\"sans-serif\"\n");
        stringBuffer.append("\t\tid=\"" + this.parent.register(string2) + "\"\n");
        stringBuffer.append("\t\tfont-weight=\"bold\"\n");
        stringBuffer.append("\t\tline-height=\"24pt\"\n");
        stringBuffer.append("\t\tspace-after.optimum=\"15pt\"\n");
        stringBuffer.append("\t\tcolor=\"black\"\n");
        stringBuffer.append("\t\ttext-align=\"" + string3 + "\"\n");
        stringBuffer.append("\t\tpadding-top=\"12pt\">\n");
        stringBuffer.append("\t" + string + "\n");
        stringBuffer.append("</fo:block>");
        this.elements.add(new Piece(stringBuffer.toString()));
    }

    public void h2(String string) {
        this.h2(string, string);
    }

    public void h2(String string, String string2) {
        string = Content.fixText(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<fo:block font-size=\"15pt\"\n");
        stringBuffer.append("\t\tfont-family=\"sans-serif\"\n");
        stringBuffer.append("\t\tfont-weight=\"bold\"\n");
        stringBuffer.append("\t\tid=\"" + this.parent.register(string2) + "\"\n");
        stringBuffer.append("\t\tline-height=\"24pt\"\n");
        stringBuffer.append("\t\tspace-after.optimum=\"15pt\"\n");
        stringBuffer.append("\t\tcolor=\"black\"\n");
        stringBuffer.append("\t\ttext-align=\"left\"\n");
        stringBuffer.append("\t\tpadding-top=\"6pt\"\n");
        stringBuffer.append("\t\tpadding-bottom=\"6pt\"\n");
        stringBuffer.append("\t\tmargin-bottom=\"0\">\n");
        stringBuffer.append("\t<fo:inline text-decoration=\"underline\">" + string + "</fo:inline>\n");
        stringBuffer.append("</fo:block>");
        this.elements.add(new Piece(stringBuffer.toString()));
    }

    public void img(String string, String string2) {
        this.elements.add(new Piece("<fo:external-graphic src=\"" + string + "\" content-width=\"" + string2 + "\" />"));
    }

    public void h2_img(BufferedImage bufferedImage, String string) {
        this.h2_img(bufferedImage, string, string);
    }

    public void h2_img(BufferedImage bufferedImage, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<fo:table border-separation=\"0\" margin-top=\"4pt\" margin-bottom=\"8pt\" width=\"100%\">\n");
        stringBuffer.append("\t<fo:table-body>\n");
        stringBuffer.append("\t\t<fo:table-row>\n");
        stringBuffer.append("\t\t\t<fo:table-cell display-align=\"after\" width=\"0.6in\">\n");
        stringBuffer.append("\t\t\t\t<fo:block padding=\"0\" margin=\"0\">\n");
        this.elements.add(new Piece(stringBuffer.toString()));
        this.img(ReportUtils.image(bufferedImage), "0.5in");
        stringBuffer = new StringBuffer();
        stringBuffer.append("\t\t\t\t</fo:block>\n");
        stringBuffer.append("\t\t\t</fo:table-cell>\n");
        stringBuffer.append("\t\t\t<fo:table-cell display-align=\"center\" width=\"6in\">\n");
        this.elements.add(new Piece(stringBuffer.toString()));
        this.h2(string, string2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("\t\t\t</fo:table-cell>\n");
        stringBuffer.append("\t\t</fo:table-row>\n");
        stringBuffer.append("\t</fo:table-body>\n");
        stringBuffer.append("</fo:table>\n");
        this.elements.add(new Piece(stringBuffer.toString()));
    }

    public void h3(String string) {
        string = Content.fixText(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<fo:block font-size=\"14pt\"\n");
        stringBuffer.append("\t\tfont-family=\"sans-serif\"\n");
        stringBuffer.append("\t\tfont-weight=\"bold\"\n");
        stringBuffer.append("\t\tline-height=\"24pt\"\n");
        stringBuffer.append("\t\tspace-after.optimum=\"15pt\"\n");
        stringBuffer.append("\t\tcolor=\"black\"\n");
        stringBuffer.append("\t\ttext-align=\"left\"\n");
        stringBuffer.append("\t\tpadding-top=\"6pt\"\n");
        stringBuffer.append("\t\tpadding-bottom=\"6pt\"\n");
        stringBuffer.append("\t\tmargin-bottom=\"0\">\n");
        stringBuffer.append("\t" + string + "\n");
        stringBuffer.append("</fo:block>");
        this.elements.add(new Piece(stringBuffer.toString()));
    }

    public void kvtable(Map map2) {
        this.elements.add(new KVTable(map2));
    }

    public Content block(String string) {
        FoBlock foBlock = new FoBlock(this.parent, string);
        this.elements.add(foBlock);
        return foBlock;
    }

    public Content string() {
        Content content = new Content(this.parent);
        return content;
    }

    public Content output(String string) {
        Output output = new Output(this.parent, string);
        this.elements.add(output);
        return output;
    }

    public Content nobreak() {
        NoBreak noBreak = new NoBreak(this.parent);
        this.elements.add(noBreak);
        return noBreak;
    }

    public void list(List list) {
        Content content = this.ul();
        for (Object e : list) {
            if (e == null) continue;
            content.li().text(e.toString());
        }
    }

    public void list_formatted(List list) {
        Content content = this.ul();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (iterator.next() + "").trim();
            RegexParser regexParser = new RegexParser(string);
            if (regexParser.matches("'''(.*?)'''(.*?)")) {
                Content content2 = content.li();
                content2.b(regexParser.group(1));
                content2.text(regexParser.group(2));
                continue;
            }
            if ("".equals(string)) continue;
            content.li().text(string);
        }
    }

    public void link(String string, String string2) {
        string = Content.fixText(string);
        this.elements.add(new Piece(ReportUtils.a(string, string2)));
    }

    public void link_bullet(String string, String string2) {
        Content content = this.ul();
        content.li().link(string, string2);
    }

    public Content li() {
        ListItem listItem = new ListItem(this.parent);
        this.elements.add(listItem);
        return listItem;
    }

    public Content ul() {
        UnorderedList unorderedList = new UnorderedList(this.parent);
        this.elements.add(unorderedList);
        return unorderedList;
    }

    public void b(String string) {
        string = Content.fixText(string);
        this.elements.add(new Piece("<fo:inline font-weight=\"bold\">" + string + "</fo:inline>"));
    }

    public void text(String string) {
        string = Content.fixText(string);
        this.elements.add(new Piece("<fo:inline>" + string + "</fo:inline>"));
    }

    public void color(String string, String string2) {
        string = Content.fixText(string);
        this.elements.add(new Piece("<fo:inline color=\"" + string2 + "\">" + string + "</fo:inline>"));
    }

    public void color2(String string, String string2, String string3) {
        string = Content.fixText(string);
        this.elements.add(new Piece("<fo:inline color=\"" + string2 + "\" background-color=\"" + string3 + "\">" + string + "</fo:inline>"));
    }

    public void h4(String string, String string2) {
        string = Content.fixText(string);
        this.elements.add(new Piece("<fo:block font-size=\"12pt\" font-family=\"sans-serif\" font-weight=\"bold\" color=\"black\" text-align=\"" + string2 + "\">" + string + "</fo:block>"));
    }

    public void p(String string, String string2) {
        string = Content.fixText(string);
        this.elements.add(new Piece("<fo:block font-size=\"12pt\" font-family=\"sans-serif\" font-weight=\"normal\" color=\"black\" text-align=\"" + string2 + "\">" + string + "</fo:block>"));
    }

    public void br() {
        this.elements.add(new Piece("<fo:block font-size=\"12pt\" font-family=\"sans-serif\" font-weight=\"normal\" color=\"black\" text-align=\"left\">&#160;</fo:block>"));
    }

    public void table(List list, List list2, List list3) {
        this.elements.add(new Table(list, list2, list3));
    }

    public void layout(List list, List list2, List list3) {
        this.elements.add(new Layout(list, list2, list3));
    }

    public void ts() {
        String string = DateFormat.getDateInstance(2).format(new Date());
        this.elements.add(new Piece("<fo:block font-size=\"12pt\" padding-bottom=\"8pt\" font-family=\"sans-serif\" font-style=\"italic\" font-weight=\"normal\" color=\"black\" text-align=\"left\">" + string + "</fo:block>"));
    }

    @Override
    public void publish(StringBuffer stringBuffer) {
        ReportUtils.PublishAll(stringBuffer, this.elements);
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public void bookmark(String string) {
        this.parent.getBookmarks().bookmark(string);
    }

    public void bookmark(String string, String string2) {
        this.parent.getBookmarks().bookmark(string, string2);
    }
}

