/*
 * Decompiled with CFR 0.152.
 */
package report;

import common.CHECKINSTATE;
import common.CommonUtils;
import common.RegexParser;
import cortana.Cortana;
import dialog.DialogUtils;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import report.Content;
import report.Document;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.interfaces.Environment;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ReportBridge
implements Function,
Loadable,
Environment {
    protected Map descriptions = new HashMap();
    protected LinkedHashMap reports = new LinkedHashMap();

    public List reportTitles() {
        return new LinkedList(this.reports.keySet());
    }

    public String describe(String string) {
        return (String)this.descriptions.get(string);
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        Cortana.putenv(scriptInstance, "li", this);
        Cortana.putenv(scriptInstance, "nobreak", this);
        Cortana.putenv(scriptInstance, "output", this);
        Cortana.putenv(scriptInstance, "page", this);
        Cortana.putenv(scriptInstance, "report", this);
        Cortana.putenv(scriptInstance, "ul", this);
        Cortana.put(scriptInstance, "&block", this);
        Cortana.put(scriptInstance, "&bookmark", this);
        Cortana.put(scriptInstance, "&describe", this);
        Cortana.put(scriptInstance, "&formatTime", this);
        Cortana.put(scriptInstance, "&b", this);
        Cortana.put(scriptInstance, "&br", this);
        Cortana.put(scriptInstance, "&color", this);
        Cortana.put(scriptInstance, "&color2", this);
        Cortana.put(scriptInstance, "&h1", this);
        Cortana.put(scriptInstance, "&h2", this);
        Cortana.put(scriptInstance, "&h2_img", this);
        Cortana.put(scriptInstance, "&h3", this);
        Cortana.put(scriptInstance, "&h4", this);
        Cortana.put(scriptInstance, "&host_image", this);
        Cortana.put(scriptInstance, "&img", this);
        Cortana.put(scriptInstance, "&landscape", this);
        Cortana.put(scriptInstance, "&layout", this);
        Cortana.put(scriptInstance, "&li", this);
        Cortana.put(scriptInstance, "&link", this);
        Cortana.put(scriptInstance, "&kvtable", this);
        Cortana.put(scriptInstance, "&nobreak", this);
        Cortana.put(scriptInstance, "&output", this);
        Cortana.put(scriptInstance, "&p", this);
        Cortana.put(scriptInstance, "&p_formatted", this);
        Cortana.put(scriptInstance, "&text", this);
        Cortana.put(scriptInstance, "&table", this);
        Cortana.put(scriptInstance, "&ts", this);
        Cortana.put(scriptInstance, "&ul", this);
        Cortana.put(scriptInstance, "&list_unordered", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Document buildReport(String string, String string2, Stack stack) {
        Document document = new Document(string2, 0);
        SleepClosure sleepClosure = (SleepClosure)this.reports.get(string);
        sleepClosure.getOwner().getMetadata().put("document", document);
        SleepUtils.runCode(sleepClosure, string, null, stack);
        sleepClosure.getOwner().getMetadata().put("document", null);
        sleepClosure.getOwner().getMetadata().put("document_stack", null);
        return document;
    }

    public Document getCurrentDocument(ScriptInstance scriptInstance) {
        Document document = (Document)scriptInstance.getMetadata().get("document");
        if (document == null) {
            throw new RuntimeException("this function must be run within the context of a report!");
        }
        return document;
    }

    public Stack getContentStack(ScriptInstance scriptInstance) {
        Stack stack = (Stack)scriptInstance.getMetadata().get("document_stack");
        if (stack == null) {
            stack = new Stack();
            scriptInstance.getMetadata().put("document_stack", stack);
        }
        return stack;
    }

    public Content getContent(ScriptInstance scriptInstance) {
        return (Content)this.getContentStack(scriptInstance).peek();
    }

    protected void eval(Content content, ScriptInstance scriptInstance, Block block) {
        this.getContentStack(scriptInstance).push(content);
        SleepUtils.runCode(scriptInstance, block);
        this.getContentStack(scriptInstance).pop();
    }

    protected void eval(Content content, SleepClosure sleepClosure) {
        this.getContentStack(sleepClosure.getOwner()).push(content);
        SleepUtils.runCode(sleepClosure, "", null, new Stack());
        this.getContentStack(sleepClosure.getOwner()).pop();
    }

    @Override
    public void bindFunction(ScriptInstance scriptInstance, String string, String string2, Block block) {
        if ("report".equals(string)) {
            this.reports.put(string2, new SleepClosure(scriptInstance, block));
        } else if ("page".equals(string)) {
            int n = 0;
            if (string2.equals("rest")) {
                n = 1;
            } else if (string2.equals("first")) {
                n = 0;
            } else if (string2.equals("first-center")) {
                n = 2;
            } else if (string2.equals("single")) {
                n = 3;
            } else {
                throw new RuntimeException("invalid page type '" + string2 + "'");
            }
            this.eval(this.getCurrentDocument(scriptInstance).addPage(n), scriptInstance, block);
        }
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (!"sajkld".equals(string)) {
            if ("&bookmark".equals(string)) {
                if (stack.size() == 2) {
                    String string2 = BridgeUtilities.getString(stack, "");
                    String string3 = BridgeUtilities.getString(stack, "");
                    this.getCurrentDocument(scriptInstance).getBookmarks().bookmark(string2, string3);
                } else {
                    String string4 = BridgeUtilities.getString(stack, "");
                    this.getCurrentDocument(scriptInstance).getBookmarks().bookmark(string4);
                }
            } else if ("&br".equals(string)) {
                this.getContent(scriptInstance).br();
            } else if ("&describe".equals(string)) {
                String string5 = BridgeUtilities.getString(stack, "");
                String string6 = BridgeUtilities.getString(stack, "");
                this.descriptions.put(string5, string6);
            } else {
                if ("&formatTime".equals(string)) {
                    long l = BridgeUtilities.getLong(stack);
                    return SleepUtils.getScalar(CommonUtils.formatTime(l));
                }
                if ("&h1".equals(string)) {
                    String string7 = BridgeUtilities.getString(stack, "");
                    String string8 = BridgeUtilities.getString(stack, string7);
                    String string9 = BridgeUtilities.getString(stack, "left");
                    this.getContent(scriptInstance).h1(string7, string8, string9);
                } else if ("&h2".equals(string)) {
                    String string10 = BridgeUtilities.getString(stack, "");
                    String string11 = BridgeUtilities.getString(stack, string10);
                    this.getContent(scriptInstance).h2(string10, string11);
                } else if ("&h2_img".equals(string)) {
                    BufferedImage bufferedImage = (BufferedImage)BridgeUtilities.getObject(stack);
                    String string12 = BridgeUtilities.getString(stack, "");
                    String string13 = BridgeUtilities.getString(stack, string12);
                    this.getContent(scriptInstance).h2_img(bufferedImage, string12, string13);
                } else if ("&h3".equals(string)) {
                    String string14 = BridgeUtilities.getString(stack, "");
                    this.getContent(scriptInstance).h3(string14);
                } else if ("&h4".equals(string)) {
                    String string15 = BridgeUtilities.getString(stack, "");
                    this.getContent(scriptInstance).h4(string15, "left");
                } else if ("&b".equals(string)) {
                    String string16 = BridgeUtilities.getString(stack, "");
                    this.getContent(scriptInstance).b(string16);
                } else if ("&color".equals(string)) {
                    String string17 = BridgeUtilities.getString(stack, "");
                    String string18 = BridgeUtilities.getString(stack, "");
                    this.getContent(scriptInstance).color(string17, string18);
                } else if ("&color2".equals(string)) {
                    String string19 = BridgeUtilities.getString(stack, "");
                    String string20 = BridgeUtilities.getString(stack, "");
                    String string21 = BridgeUtilities.getString(stack, "");
                    this.getContent(scriptInstance).color2(string19, string20, string21);
                } else {
                    if ("&host_image".equals(string)) {
                        String string22 = BridgeUtilities.getString(stack, "");
                        double d = BridgeUtilities.getDouble(stack, 0.0);
                        boolean bl = !SleepUtils.isEmptyScalar(BridgeUtilities.getScalar(stack));
                        return SleepUtils.getScalar(DialogUtils.TargetVisualizationMedium(string22, d, bl, CHECKINSTATE.GOOD));
                    }
                    if ("&img".equals(string)) {
                        String string23 = BridgeUtilities.getString(stack, "");
                        String string24 = BridgeUtilities.getString(stack, "");
                        this.getContent(scriptInstance).img(string23, string24);
                    } else if ("&kvtable".equals(string)) {
                        Scalar scalar = (Scalar)stack.pop();
                        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        for (Map.Entry entry : scalar.getHash().getData().entrySet()) {
                            linkedHashMap.put(entry.getKey().toString(), entry.getValue() != null ? entry.getValue().toString() : "");
                        }
                        this.getContent(scriptInstance).kvtable(linkedHashMap);
                    } else if ("&landscape".equals(string)) {
                        this.getCurrentDocument(scriptInstance).setOrientation(1);
                    } else if ("&li".equals(string)) {
                        SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                        this.eval(this.getContent(scriptInstance).li(), sleepClosure);
                    } else if ("&nobreak".equals(string)) {
                        SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                        this.eval(this.getContent(scriptInstance).nobreak(), sleepClosure);
                    } else if ("&output".equals(string)) {
                        SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                        this.eval(this.getContent(scriptInstance).output("800"), sleepClosure);
                    } else if ("&block".equals(string)) {
                        SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                        String string25 = BridgeUtilities.getString(stack, "left");
                        this.eval(this.getContent(scriptInstance).block(string25), sleepClosure);
                    } else if ("&p".equals(string)) {
                        String string26 = BridgeUtilities.getString(stack, "");
                        String string27 = BridgeUtilities.getString(stack, "left");
                        this.getContent(scriptInstance).p(string26, string27);
                    } else if ("&p_formatted".equals(string)) {
                        String string28 = BridgeUtilities.getString(stack, "");
                        string28 = CommonUtils.strrep(string28, "\n\n*", "\n*");
                        List list = CommonUtils.toList(string28.split("\n"));
                        LinkedList<String> linkedList = new LinkedList<String>();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            RegexParser regexParser;
                            String string29 = (String)iterator.next();
                            if (!(string29 = string29.trim()).equals("") && string29.charAt(0) == '*' && string29.length() > 1) {
                                linkedList.add(string29.substring(1));
                                continue;
                            }
                            if (linkedList.size() > 0) {
                                this.getContent(scriptInstance).list_formatted(linkedList);
                                linkedList = new LinkedList();
                                if ("".equals(string29)) continue;
                            }
                            if ((regexParser = new RegexParser(string29)).matches("===(.*?)===")) {
                                this.getContent(scriptInstance).h4(regexParser.group(1), "left");
                                if (!iterator.hasNext() || "".equals(string29 = (String)iterator.next())) continue;
                                this.getContent(scriptInstance).p(string29, "left");
                                continue;
                            }
                            if ("".equals(string29)) {
                                this.getContent(scriptInstance).br();
                                continue;
                            }
                            RegexParser regexParser2 = new RegexParser(string29.trim());
                            if (regexParser2.matches("'''(.*?)'''(.*?)")) {
                                Content content = this.getContent(scriptInstance).block("left");
                                content.b(regexParser2.group(1));
                                content.text(regexParser2.group(2));
                                continue;
                            }
                            this.getContent(scriptInstance).p(string29, "left");
                        }
                        if (linkedList.size() > 0) {
                            this.getContent(scriptInstance).list(linkedList);
                        }
                    } else if ("&text".equals(string)) {
                        String string30 = BridgeUtilities.getString(stack, "");
                        this.getContent(scriptInstance).text(string30);
                    } else if ("&table".equals(string) || "&layout".equals(string)) {
                        List list = SleepUtils.getListFromArray((Scalar)stack.pop());
                        List list2 = SleepUtils.getListFromArray((Scalar)stack.pop());
                        List list3 = SleepUtils.getListFromArray((Scalar)stack.pop());
                        Iterator iterator = list3.iterator();
                        while (iterator.hasNext()) {
                            for (Map.Entry entry : ((Map)iterator.next()).entrySet()) {
                                if (entry.getValue() instanceof SleepClosure) {
                                    SleepClosure sleepClosure = (SleepClosure)entry.getValue();
                                    Content content = this.getContent(scriptInstance).string();
                                    this.eval(content, sleepClosure);
                                    StringBuffer stringBuffer = new StringBuffer();
                                    content.publish(stringBuffer);
                                    entry.setValue(stringBuffer.toString());
                                    continue;
                                }
                                entry.setValue(Content.fixText(entry.getValue() != null ? entry.getValue().toString() : ""));
                            }
                        }
                        if ("&table".equals(string)) {
                            this.getContent(scriptInstance).table(list, list2, list3);
                        } else {
                            this.getContent(scriptInstance).layout(list, list2, list3);
                        }
                    } else if ("&ts".equals(string)) {
                        String string31 = BridgeUtilities.getString(stack, "");
                        this.getContent(scriptInstance).ts();
                    } else if ("&ul".equals(string)) {
                        SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                        this.eval(this.getContent(scriptInstance).ul(), sleepClosure);
                    } else if ("&list_unordered".equals(string)) {
                        List list = SleepUtils.getListFromArray((Scalar)stack.pop());
                        this.getContent(scriptInstance).list(list);
                    } else if ("&link".equals(string)) {
                        String string32 = BridgeUtilities.getString(stack, "");
                        String string33 = BridgeUtilities.getString(stack, "");
                        this.getContent(scriptInstance).link_bullet(string32, string33);
                    }
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

