/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class TimeDateBridge
implements Loadable {
    public void scriptLoaded(ScriptInstance scriptInstance) {
        scriptInstance.getScriptEnvironment().getEnvironment().put("&ticks", new ticks());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&formatDate", new formatDate());
        scriptInstance.getScriptEnvironment().getEnvironment().put("&parseDate", new parseDate());
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    private static class ticks
    implements Function {
        private ticks() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getScalar(System.currentTimeMillis());
        }
    }

    private static class parseDate
    implements Function {
        private parseDate() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            String string3 = stack.pop().toString();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            Date date = simpleDateFormat.parse(string3, new ParsePosition(0));
            return SleepUtils.getScalar(date.getTime());
        }
    }

    private static class formatDate
    implements Function {
        private formatDate() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            long l = System.currentTimeMillis();
            if (stack.size() == 2) {
                l = BridgeUtilities.getLong(stack);
            }
            String string2 = stack.pop().toString();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            Date date = new Date(l);
            return SleepUtils.getScalar(simpleDateFormat.format(date, new StringBuffer(), new FieldPosition(0)).toString());
        }
    }
}

