/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.nio.ByteOrder;
import java.util.HashMap;

public class DataPattern {
    public DataPattern next = null;
    public int count = 1;
    public char value = (char)32;
    public int size = 0;
    public ByteOrder order = ByteOrder.BIG_ENDIAN;
    private static HashMap patternCache = new HashMap();

    public static int EstimateSize(String string) {
        DataPattern dataPattern = DataPattern.Parse(string);
        int n = 0;
        while (dataPattern != null) {
            if (dataPattern.count > 0) {
                n += dataPattern.count * dataPattern.size;
            }
            dataPattern = dataPattern.next;
        }
        return n;
    }

    public static DataPattern Parse(String string) {
        if (patternCache.get(string) != null) {
            return (DataPattern)patternCache.get(string);
        }
        DataPattern dataPattern = null;
        DataPattern dataPattern2 = null;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetter(string.charAt(i))) {
                if (dataPattern2 != null) {
                    if (stringBuffer.length() > 0) {
                        dataPattern2.count = Integer.parseInt(stringBuffer.toString());
                    }
                    dataPattern2 = dataPattern2.next = new DataPattern();
                } else {
                    dataPattern2 = dataPattern = new DataPattern();
                }
                stringBuffer = new StringBuffer(3);
                dataPattern2.value = string.charAt(i);
                switch (dataPattern2.value) {
                    case 'B': 
                    case 'C': 
                    case 'H': 
                    case 'b': 
                    case 'h': 
                    case 'o': 
                    case 'x': {
                        dataPattern2.size = 1;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        dataPattern2.count = -1;
                        dataPattern2.size = 2;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        dataPattern2.count = -1;
                        dataPattern2.size = 1;
                        break;
                    }
                    case 'S': 
                    case 'c': 
                    case 's': {
                        dataPattern2.size = 2;
                        break;
                    }
                    case 'I': 
                    case 'f': 
                    case 'i': {
                        dataPattern2.size = 4;
                        break;
                    }
                    case 'd': 
                    case 'l': {
                        dataPattern2.size = 8;
                    }
                }
                continue;
            }
            if (string.charAt(i) == '*') {
                dataPattern2.count = -1;
                continue;
            }
            if (string.charAt(i) == '!') {
                dataPattern2.order = ByteOrder.nativeOrder();
                continue;
            }
            if (string.charAt(i) == '-') {
                dataPattern2.order = ByteOrder.LITTLE_ENDIAN;
                continue;
            }
            if (string.charAt(i) == '+') {
                dataPattern2.order = ByteOrder.BIG_ENDIAN;
                continue;
            }
            if (!Character.isDigit(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        if (stringBuffer.length() > 0) {
            dataPattern2.count = Integer.parseInt(stringBuffer.toString());
        }
        patternCache.put(string, dataPattern);
        return dataPattern;
    }
}

