/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Return
extends Step {
    protected int return_type;

    public Return(int n) {
        this.return_type = n;
    }

    public String toString(String string) {
        return string + "[Return]: " + this.return_type + " \n";
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        if (this.return_type == 16) {
            Scalar scalar = (Scalar)scriptEnvironment.getCurrentFrame().pop();
            if (!SleepUtils.isEmptyScalar(scalar)) {
                scriptEnvironment.getScriptInstance().clearStackTrace();
                scriptEnvironment.getScriptInstance().recordStackFrame("<origin of exception>", this.getLineNumber());
                scriptEnvironment.flagReturn(scalar, 16);
            }
        } else if (this.return_type == 2 || this.return_type == 4) {
            scriptEnvironment.flagReturn(null, this.return_type);
        } else if (this.return_type == 72) {
            Scalar scalar;
            Scalar scalar2 = scalar = scriptEnvironment.getCurrentFrame().isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)scriptEnvironment.getCurrentFrame().pop();
            if (!SleepUtils.isFunctionScalar(scalar)) {
                scriptEnvironment.getScriptInstance().fireWarning("callcc requires a function: " + SleepUtils.describe(scalar), this.getLineNumber());
                scriptEnvironment.flagReturn(scalar, 8);
            } else {
                scriptEnvironment.flagReturn(scalar, this.return_type);
            }
        } else if (scriptEnvironment.getCurrentFrame().isEmpty()) {
            scriptEnvironment.flagReturn(SleepUtils.getEmptyScalar(), this.return_type);
        } else {
            scriptEnvironment.flagReturn((Scalar)scriptEnvironment.getCurrentFrame().pop(), this.return_type);
        }
        scriptEnvironment.KillFrame();
        return null;
    }
}

