/*
 * Decompiled with CFR 0.152.
 */
package socks;

import common.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import socks.ProxyEvent;
import socks.ProxyListener;
import socks.SocksProxy;

public class BeaconProxyListener
implements ProxyListener {
    private boolean A = false;

    public byte[] writeMessage(int n, byte[] byArray, int n2) throws IOException {
        if (this.A) {
            CommonUtils.print_warn("BeaconProxyListener.writeMessage: id=" + n + " message_length=" + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256 + n2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(15);
        dataOutputStream.writeInt(n2 + 4);
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray, 0, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeMessage_udp(int n, int n2, String string, byte[] byArray, int n3) throws IOException {
        if (this.A) {
            CommonUtils.print_warn("BeaconProxyListener.writeMessage_udp: id=" + n + " host=" + string + " port=" + n2 + " message_length=" + n3);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256 + n3);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n4 = 10 + string.length() + n3;
        dataOutputStream.writeInt(104);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeBytes(string);
        dataOutputStream.write(byArray, 0, n3);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] connectMessage(int n, String string, int n2) throws IOException {
        if (this.A) {
            CommonUtils.print_warn("BeaconProxyListener.connectMessage: id=" + n + " host=" + string + " port=" + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(14);
        dataOutputStream.writeInt(string.length() + 6);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeBytes(string);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] closeMessage(int n) throws IOException {
        if (this.A) {
            CommonUtils.print_warn("BeaconProxyListener.closeMessage: id=" + n);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(16);
        dataOutputStream.writeInt(4);
        dataOutputStream.writeInt(n);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] listenMessage(int n, int n2) throws IOException {
        if (this.A) {
            CommonUtils.print_warn("BeaconProxyListener.listenMessage: id=" + n + " port=" + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(17);
        dataOutputStream.writeInt(6);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeShort(n2);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] connectUDPMessage(int n, String string, int n2) throws IOException {
        if (this.A) {
            CommonUtils.print_warn("BeaconProxyListener.connectUDPMessage: id=" + n + " host=" + string + " port=" + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(103);
        dataOutputStream.writeInt(6 + string.length());
        dataOutputStream.writeInt(n);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeBytes(string);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void proxyEvent(SocksProxy socksProxy, ProxyEvent proxyEvent) {
        try {
            switch (proxyEvent.getType()) {
                case 1: {
                    byte[] byArray = this.connectMessage(proxyEvent.getChannelId(), proxyEvent.getHost(), proxyEvent.getPort());
                    socksProxy.read(byArray);
                    break;
                }
                case 2: {
                    byte[] byArray = this.listenMessage(proxyEvent.getChannelId(), proxyEvent.getPort());
                    socksProxy.read(byArray);
                    break;
                }
                case 3: {
                    byte[] byArray = this.writeMessage(proxyEvent.getChannelId(), proxyEvent.getData(), proxyEvent.getDataLength());
                    socksProxy.read(byArray);
                    break;
                }
                case 0: {
                    byte[] byArray = this.closeMessage(proxyEvent.getChannelId());
                    socksProxy.read(byArray);
                    break;
                }
                case 4: {
                    byte[] byArray = this.connectUDPMessage(proxyEvent.getChannelId(), proxyEvent.getHost(), proxyEvent.getPort());
                    socksProxy.read(byArray);
                    break;
                }
                case 5: {
                    byte[] byArray = this.writeMessage_udp(proxyEvent.getChannelId(), proxyEvent.getPort(), proxyEvent.getHost(), proxyEvent.getData(), proxyEvent.getDataLength());
                    socksProxy.read(byArray);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

