/*
 * Decompiled with CFR 0.152.
 */
package socks;

import common.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import socks.Socks5Config;
import socks.SocksCommand;

public class Socks5Command
extends SocksCommand {
    public static final boolean LOG_DEBUG = false;
    public static final boolean LOG_DEBUG_DATA = false;
    public static final int SOCKS5_ADDRESS_TYPE_IPV4 = 1;
    public static final int SOCKS5_ADDRESS_TYPE_DOMAIN_NAME = 3;
    public static final int SOCKS5_ADDRESS_TYPE_IPV6 = 4;
    protected int chid = 0;
    protected int version;
    protected int command;
    protected int dstport;
    protected int dstraw;
    protected String dstip;
    protected String userid;
    protected int addressType = 0;
    protected String domainName = null;
    protected byte[] ipv6Addr = null;
    protected int udpAssociateBindAddressType = 1;
    protected int udpAssociateBindAddress = 0;
    protected int udpAssociateBindPort = 0;
    Socks5Config A;

    public Socks5Command(InputStream inputStream, OutputStream outputStream, Socks5Config socks5Config, int n) throws IOException {
        this.A = socks5Config;
        this.chid = n;
        if (this.A.isLoggingEnabled()) {
            this.A.log(n, "********** Constructing Socks5Command **********");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.B(dataInputStream, outputStream);
        this.A(dataInputStream, outputStream);
    }

    public String toString() {
        return "[SOCKS version: " + this.version + ", command: " + this.command + ", dstip: " + this.dstip + ", dstport: " + this.dstport + ", userid: " + this.userid + ", addressType:" + this.addressType + ", domainName:" + this.domainName + "]";
    }

    public int getVersion() {
        return this.version;
    }

    public int getCommand() {
        return this.command;
    }

    public String getHost() {
        return this.dstip;
    }

    public int getPort() {
        return this.dstport;
    }

    protected String readString(DataInputStream dataInputStream) throws IOException {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        while ((by = dataInputStream.readByte()) != 0) {
            stringBuffer.append((char)by);
        }
        return stringBuffer.toString();
    }

    protected String readString(DataInputStream dataInputStream, int n) throws IOException {
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        do {
            byte by;
            if ((by = dataInputStream.readByte()) == 0) {
                throw new IOException("premature string termination. bytes expected: " + n + " actual bytes: " + n2);
            }
            stringBuffer.append((char)by);
        } while (++n2 != n);
        return stringBuffer.toString();
    }

    protected byte[] readBytes(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        do {
            byte by;
            byArray[n2] = by = dataInputStream.readByte();
        } while (++n2 != n);
        return byArray;
    }

    private boolean B(DataInputStream dataInputStream, OutputStream outputStream) throws IOException {
        int n;
        this.version = dataInputStream.readUnsignedByte();
        switch (this.version) {
            case 5: {
                break;
            }
            default: {
                throw new IOException("invalid SOCKS version: " + this.version);
            }
        }
        int n2 = dataInputStream.readUnsignedByte();
        boolean bl = false;
        boolean bl2 = false;
        block7: for (n = 1; n <= n2; ++n) {
            int n3 = dataInputStream.readUnsignedByte();
            switch (n3) {
                case 0: {
                    bl = true;
                    this.A.log(this.chid, "Greeting: NoAuth Authentication offered: " + n3);
                    continue block7;
                }
                case 2: {
                    bl2 = true;
                    this.A.log(this.chid, "Greeting: UserPwd Authentication offered: " + n3);
                    continue block7;
                }
                default: {
                    this.A.log(this.chid, "Greeting: Unsupported Authentication offered: " + n3);
                }
            }
        }
        n = 0;
        if (bl2 && this.A.areUsersDefined()) {
            n = this.C(dataInputStream, outputStream) ? 1 : 0;
        } else if (bl && this.A.isAllowNoAuth()) {
            n = this.D(dataInputStream, outputStream) ? 1 : 0;
        } else {
            String string = "Greeting: No Acceptable Method Chosen";
            this.A.logError(this.chid, string);
            this.B(outputStream, 5, 255);
            throw new IOException(string);
        }
        if (n == 0) {
            String string = "failed SOCKS5 authentication";
            this.A.logError(this.chid, string);
            throw new IOException(string);
        }
        return true;
    }

    private void B(OutputStream outputStream, int n, int n2) throws IOException {
        String string = "sendChosenAuthentication: Chosen Authentication Type: " + n2;
        this.A.log(this.chid, string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(n2);
        outputStream.write(byteArrayOutputStream.toByteArray());
    }

    private boolean D(DataInputStream dataInputStream, OutputStream outputStream) throws IOException {
        this.B(outputStream, 5, 0);
        return true;
    }

    private boolean C(DataInputStream dataInputStream, OutputStream outputStream) throws IOException {
        boolean bl;
        int n;
        this.B(outputStream, 5, 2);
        if (this.A.isLoggingEnabled()) {
            this.A.log(this.chid, "verifyUserPwd: Verifying User/Password Authentication");
        }
        if ((n = dataInputStream.readUnsignedByte()) != 1) {
            throw new IOException("invalid SOCKS5 user/pwd auth version: " + n);
        }
        int n2 = dataInputStream.readUnsignedByte();
        this.userid = this.readString(dataInputStream, n2);
        int n3 = dataInputStream.readUnsignedByte();
        String string = this.readString(dataInputStream, n3);
        if (this.A.isLoggingEnabled()) {
            this.A.log(this.chid, "verifyUserPwd: Verifying user: " + this.userid);
        }
        if (!(bl = this.A.validUserPassword(this.userid, string))) {
            String string2 = "Invalid login attempt from user: " + this.userid;
            this.A.logError(this.chid, string2);
            try {
                Thread.sleep(1250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.A(outputStream, n, 1);
            throw new IOException(string2);
        }
        this.A.log(this.chid, "User login validated: " + this.userid);
        this.A(outputStream, n, 0);
        return true;
    }

    private void A(OutputStream outputStream, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(n2);
        outputStream.write(byteArrayOutputStream.toByteArray());
    }

    private void A(DataInputStream dataInputStream, OutputStream outputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (n != 5) {
            throw new IOException("invalid client connection request version: " + n);
        }
        int n2 = dataInputStream.readUnsignedByte();
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IOException("invalid client connection request command code: " + n2);
        }
        this.command = n2;
        int n3 = dataInputStream.readUnsignedByte();
        if (n3 != 0) {
            throw new IOException("invalid client connection request reserved byte: " + n3);
        }
        String string = "";
        this.addressType = dataInputStream.readUnsignedByte();
        switch (this.addressType) {
            case 1: {
                this.dstraw = dataInputStream.readInt();
                this.dstip = Socks5Command.toHost((long)this.dstraw);
                string = " IPV4 dstip:" + this.dstip;
                break;
            }
            case 3: {
                int n4 = dataInputStream.readUnsignedByte();
                this.dstip = this.domainName = this.readString(dataInputStream, n4);
                string = " domainName:" + this.domainName;
                break;
            }
            case 4: {
                this.ipv6Addr = this.readBytes(dataInputStream, 16);
                Object var8_10 = null;
                string = " ipv6Addr:" + this.ipv6Addr;
                break;
            }
            default: {
                String string2 = "Invalid SOCKS5 address type: " + this.addressType;
                this.A.logError(this.chid, string2);
                throw new IOException(string2);
            }
        }
        this.dstport = dataInputStream.readUnsignedShort();
        if (this.A.isLoggingEnabled()) {
            String string3 = "Processing client connection request: Command:" + this.command + string + " dstport:" + this.dstport;
            this.A.log(this.chid, string3);
        }
        if (this.addressType == 4) {
            String string4 = "Implementation does not support IPV6 address type";
            this.A.logError(this.chid, string4);
            this.A(outputStream, Socks5Status.AddressTypeNotSupported);
            throw new IOException(string4);
        }
    }

    private int A(Socks5Status socks5Status) {
        switch (socks5Status) {
            case Granted: {
                return 0;
            }
            case GeneralFailure: {
                return 1;
            }
            case NotAllowed: {
                return 2;
            }
            case NetworkUnreachable: {
                return 3;
            }
            case HostUnreachable: {
                return 4;
            }
            case ConnRefusedByDestHost: {
                return 5;
            }
            case TTLExpired: {
                return 6;
            }
            case CommandNotSupported: {
                return 7;
            }
            case AddressTypeNotSupported: {
                return 8;
            }
        }
        return 1;
    }

    public void reply(OutputStream outputStream, Socks5Status socks5Status) throws IOException {
        this.A(outputStream, socks5Status);
    }

    private void A(OutputStream outputStream, Socks5Status socks5Status) throws IOException {
        int n = this.addressType;
        int n2 = this.dstport;
        int n3 = this.dstraw;
        if (this.getCommand() == 2) {
            switch (n) {
                case 1: {
                    n3 = this.dstraw;
                    break;
                }
                case 3: {
                    break;
                }
            }
        } else if (this.getCommand() == 3) {
            n = this.udpAssociateBindAddressType;
            n2 = this.udpAssociateBindPort;
            n3 = this.udpAssociateBindAddress;
        }
        this.A(outputStream, socks5Status, n2, n, n3, this.domainName, this.ipv6Addr);
    }

    private void A(OutputStream outputStream, Socks5Status socks5Status, int n, int n2, int n3, String string, byte[] byArray) throws IOException {
        Object object;
        if (this.A.isLoggingEnabled()) {
            object = "Sending client connection reply: Status:" + (Object)((Object)socks5Status) + " bndPort:" + n + " addressType:" + n2 + " addressIPv4:" + Socks5Command.toHost((long)n3) + " domain:" + string;
            this.A.log(this.chid, (String)object);
        }
        object = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
        dataOutputStream.writeByte(this.version);
        dataOutputStream.writeByte(this.A(socks5Status));
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(n2);
        switch (n2) {
            case 1: {
                dataOutputStream.writeInt(n3);
                break;
            }
            case 3: {
                dataOutputStream.writeByte(string.length());
                dataOutputStream.writeBytes(string);
                break;
            }
            case 4: {
                if (byArray.length != 16) {
                    throw new IOException("invalid SOCKS5 ipv6 address length to write: " + byArray.length);
                }
                dataOutputStream.write(byArray);
                break;
            }
            default: {
                throw new IOException("invalid SOCKS5 address type to write: " + n2);
            }
        }
        dataOutputStream.writeShort(n);
        outputStream.write(((ByteArrayOutputStream)object).toByteArray());
    }

    public void setUDPRelayBindInfo(InetSocketAddress inetSocketAddress) throws UnknownHostException {
        this.udpAssociateBindPort = inetSocketAddress.getPort();
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (inetAddress.getAddress().length == 4) {
            this.udpAssociateBindAddressType = 1;
            this.udpAssociateBindAddress = (int)CommonUtils.ipToLong(inetAddress.getHostAddress());
        } else if (inetAddress.getAddress().length == 16) {
            this.udpAssociateBindAddressType = 4;
        }
    }

    public static enum Socks5Status {
        Granted,
        GeneralFailure,
        NotAllowed,
        NetworkUnreachable,
        HostUnreachable,
        ConnRefusedByDestHost,
        TTLExpired,
        CommandNotSupported,
        AddressTypeNotSupported;

    }
}

