/*
 * Decompiled with CFR 0.152.
 */
package socks;

import common.CommonUtils;
import common.MudgeSanity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import socks.Socks5Exception;

public class Socks5UDPHelper {
    private static boolean A = false;

    public static DatagramPacket encapsulateUDPPacket(DatagramPacket datagramPacket, SocketAddress socketAddress) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        byte[] byArray = datagramPacket.getData();
        InetAddress inetAddress = datagramPacket.getAddress();
        byte[] byArray2 = inetAddress.getAddress();
        int n = inetAddress.getAddress().length;
        int n2 = datagramPacket.getPort();
        if (A) {
            CommonUtils.print_warn("Socks5UDPHelper.encapsulateUDPPacket: Creating packet: RemoteServerAddress: " + inetAddress + " RemoteServerPort: " + n2 + " DataLength: " + byArray.length);
        }
        try {
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(n == 4 ? 1 : 4);
            dataOutputStream.write(byArray2);
            dataOutputStream.writeShort(n2);
            dataOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return new DatagramPacket(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    public static void decapsulateUDPPacket(DatagramPacket datagramPacket) throws Socks5Exception, IOException {
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream;
        DataInputStream dataInputStream;
        short s;
        if (A) {
            CommonUtils.print_warn("Socks5UDPHelper.decapsulateUDPPacket...");
        }
        if ((s = (dataInputStream = new DataInputStream(byteArrayInputStream = new ByteArrayInputStream(byArray = Arrays.copyOfRange(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getOffset() + datagramPacket.getLength())))).readShort()) != 0) {
            throw new Socks5Exception("Socks5UDPHelper udp datagram packet reserved field error. (" + s + ")");
        }
        byte by = dataInputStream.readByte();
        if (by != 0) {
            throw new Socks5Exception("Socks5UDPHelper udp datagram packet does not support fragments.");
        }
        InetAddress inetAddress = null;
        int n = -1;
        byte[] byArray2 = new byte[2048];
        int n2 = 0;
        byte by2 = dataInputStream.readByte();
        switch (by2) {
            case 1: {
                try {
                    byte[] byArray3 = new byte[4];
                    dataInputStream.read(byArray3);
                    inetAddress = InetAddress.getByAddress(byArray3);
                }
                catch (UnknownHostException unknownHostException) {
                    MudgeSanity.logException("Socks5 UDP decapsulating IPV4 Data", unknownHostException, false);
                    throw new Socks5Exception("Unknown IPV4 host", unknownHostException);
                }
                n = dataInputStream.readUnsignedShort();
                n2 = dataInputStream.read(byArray2);
                break;
            }
            case 4: {
                try {
                    byte[] byArray4 = new byte[16];
                    dataInputStream.read(byArray4);
                    inetAddress = InetAddress.getByAddress(byArray4);
                }
                catch (UnknownHostException unknownHostException) {
                    MudgeSanity.logException("Socks5 UDP decapsulating IPV6 Data", unknownHostException, false);
                    throw new Socks5Exception("Unknown IPV6 host", unknownHostException);
                }
                n = dataInputStream.readUnsignedShort();
                n2 = dataInputStream.read(byArray2);
                break;
            }
            case 3: {
                byte by3 = dataInputStream.readByte();
                byte[] byArray5 = new byte[by3];
                dataInputStream.read(byArray5);
                String string = new String(byArray5);
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    MudgeSanity.logException("Socks5 UDP decapsulating Domain Name Data", unknownHostException, false);
                    throw new Socks5Exception("Unknown host domain name: " + string, unknownHostException);
                }
                n = dataInputStream.readUnsignedShort();
                n2 = dataInputStream.read(byArray2);
                if (!A) break;
                CommonUtils.print_warn("Socks5UDPHelper.decapsulateUDPPacket - Original Data Len: " + n2);
                break;
            }
            default: {
                String string = "Socks5UDPHelper.decapsulateUDPPacket: Unsupported Address Type: " + by2;
                CommonUtils.print_warn(string);
                throw new Socks5Exception(string);
            }
        }
        if (A) {
            CommonUtils.print_warn("Socks5UDPHelper.decapsulateUDPPacket: updating packet: RemoteServerAddress: " + inetAddress + " RemoteServerPort: " + n + " OriginalLength: " + n2);
        }
        datagramPacket.setAddress(inetAddress);
        datagramPacket.setPort(n);
        datagramPacket.setData(Arrays.copyOf(byArray2, n2));
    }

    public static void logPacket(DatagramPacket datagramPacket, String string, boolean bl) {
        CommonUtils.print_warn(string + " >> Port:" + datagramPacket.getPort() + " Address:" + datagramPacket.getAddress() + " Length:" + datagramPacket.getLength() + " DataLen:" + datagramPacket.getData().length + " SocketAddress:" + datagramPacket.getSocketAddress());
        if (bl) {
            if (datagramPacket.getLength() < 2000) {
                CommonUtils.print_warn(string + " >> PacketDataLength: " + datagramPacket.getLength() + " PacketDataOffset:" + datagramPacket.getOffset() + " Data: " + CommonUtils.toHex(Arrays.copyOfRange(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getOffset() + datagramPacket.getLength())));
            } else {
                CommonUtils.print_warn(string + " >> PacketDataLength: " + datagramPacket.getLength() + " PacketDataOffset:" + datagramPacket.getOffset() + " Data(2000): " + CommonUtils.toHex(Arrays.copyOfRange(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getOffset() + 2000)));
            }
        }
    }
}

