/*
 * Decompiled with CFR 0.152.
 */
package socks;

import common.CommonUtils;
import common.MudgeSanity;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import socks.ProxyEvent;
import socks.Socks5Config;
import socks.Socks5UDPHelper;
import socks.SocksProxy;

public class Socks5UDPRelayServer
implements Runnable {
    private boolean E = false;
    private DatagramSocket D;
    private int J;
    private SocksProxy I;
    private Socks5Config C;
    private InetAddress G;
    private int F;
    private Thread H;
    private int B = 0x500000;
    private boolean A = false;

    public Socks5UDPRelayServer(SocksProxy socksProxy, int n, InetAddress inetAddress, int n2, Socks5Config socks5Config) {
        this(socksProxy, n, new InetSocketAddress(inetAddress, n2), socks5Config);
    }

    public Socks5UDPRelayServer(SocksProxy socksProxy, int n, SocketAddress socketAddress, Socks5Config socks5Config) {
        this.I = socksProxy;
        this.J = n;
        this.C = socks5Config;
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Socks5UDPRelayServer supports java.net.InetSocketAddress only");
        }
        this.G = ((InetSocketAddress)socketAddress).getAddress();
        this.F = ((InetSocketAddress)socketAddress).getPort();
        if (this.C.isLoggingEnabled()) {
            String string = "Socks5UDPRelayServer (constructor): Client Address:" + this.G + " Port:" + this.F;
            this.C.log(n, string);
        }
    }

    public SocketAddress start() throws SocketException {
        Object object;
        if (this.C.isLoggingEnabled()) {
            object = "Socks5UDPRelayServer starting";
            this.C.log(this.J, (String)object);
        }
        this.E = true;
        this.D = new DatagramSocket();
        object = this.D.getLocalSocketAddress();
        this.H = new Thread(this);
        this.H.start();
        return object;
    }

    public void stop() {
        if (this.C.isLoggingEnabled()) {
            String string = "Socks5UDPRelayServer stopping";
            this.C.log(this.J, string);
        }
        if (this.E) {
            this.E = false;
            this.H.interrupt();
            if (!this.D.isClosed()) {
                this.D.close();
            }
        }
    }

    protected void writeToClient(byte[] byArray) {
        if (this.E) {
            Object object;
            if (this.C.isLoggingEnabled()) {
                object = "Socks5UDPRelayServer.writeToClient: ClientAddress: " + this.G + " ClientPort: " + this.F + " DataLen: " + byArray.length;
                this.C.log(this.J, (String)object);
                if (this.A) {
                    object = "Socks5UDPRelayServer.writeToClient: Data: " + CommonUtils.toHexString(byArray);
                    this.C.log(this.J, (String)object);
                }
            }
            object = new DatagramPacket(byArray, byArray.length, this.G, this.F);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.G, this.F);
            DatagramPacket datagramPacket = Socks5UDPHelper.encapsulateUDPPacket((DatagramPacket)object, inetSocketAddress);
            try {
                this.D.send(datagramPacket);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected boolean isFromClient(DatagramPacket datagramPacket) {
        if (datagramPacket.getPort() == this.F && this.G.equals(datagramPacket.getAddress())) {
            return true;
        }
        return datagramPacket.getPort() == this.F && this.G.getHostAddress().startsWith("127.");
    }

    @Override
    public void run() {
        try {
            Object object;
            if (this.C.isLoggingEnabled()) {
                object = "Socks5UDPRelayServer running";
                this.C.log(this.J, (String)object);
            }
            object = new byte[this.B];
            while (this.E) {
                Object object2;
                DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length);
                this.D.receive(datagramPacket);
                if (this.isFromClient(datagramPacket)) {
                    if (this.C.isLoggingEnabled()) {
                        Socks5UDPHelper.logPacket(datagramPacket, "Client-Packet (Original)", this.A);
                    }
                    Socks5UDPHelper.decapsulateUDPPacket(datagramPacket);
                    if (this.C.isLoggingEnabled()) {
                        Socks5UDPHelper.logPacket(datagramPacket, "Client-Packet (Decapsulated)", this.A);
                    }
                    object2 = datagramPacket.getData();
                    this.I.fireEvent(ProxyEvent.EVENT_READ_UDP((int)this.J, (String)datagramPacket.getAddress().getHostAddress(), (int)datagramPacket.getPort(), (byte[])object2, (int)((byte[])object2).length));
                    continue;
                }
                if (!this.C.isLoggingEnabled()) continue;
                object2 = "Socks5UDPRelayServer.run: Dropping Packet from unknown client. PacketAddress: " + datagramPacket.getAddress() + " PacketPort:" + datagramPacket.getPort();
                this.C.log(this.J, (String)object2);
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equalsIgnoreCase("Socket closed") && !this.E) {
                if (this.C.isLoggingEnabled()) {
                    String string = "Socks5UDPRelayServer.run: socket closed. server stopped.";
                    this.C.log(this.J, string);
                }
            }
            CommonUtils.print_error("Socks5UDPRelayServer.run: CHID: " + this.J + "Error: " + iOException.getMessage());
            MudgeSanity.logException("UDP Relay Server", iOException, false);
        }
    }
}

