/*
 * Decompiled with CFR 0.152.
 */
package ssl;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import ssl.ArmitageTrustListener;

public class ArmitageTrustManager
implements X509TrustManager {
    protected ArmitageTrustListener checker;

    public ArmitageTrustManager(ArmitageTrustListener armitageTrustListener) {
        this.checker = armitageTrustListener;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                byte[] byArray = x509CertificateArray[i].getEncoded();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] byArray2 = messageDigest.digest(byArray);
                BigInteger bigInteger = new BigInteger(1, byArray2);
                String string2 = bigInteger.toString(16);
                if (this.checker == null || this.checker.trust(string2)) continue;
                throw new CertificateException("Certificate Rejected. Press Cancel.");
            }
            return;
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Exception exception) {
            throw new CertificateException(exception.getMessage());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

