/*
 * Decompiled with CFR 0.152.
 */
package table;

import common.CommonUtils;
import filter.DataFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import ui.ATable;
import ui.GenericTableModel;

public class FilterPanel
extends JPanel
implements ActionListener {
    protected JTextField filter = null;
    protected JLabel status = null;
    protected ATable table = null;
    protected JComboBox cols = null;
    protected StringBuffer desc = new StringBuffer();
    protected JToggleButton negate = new JToggleButton(" ! ");
    protected DataFilter action = new DataFilter();

    public String getColumn() {
        return this.cols.getSelectedItem().toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("".equals(this.filter.getText())) {
            return;
        }
        if (CommonUtils.contains("internal, external, host, address, fhost", this.getColumn())) {
            this.action.checkNetwork(this.getColumn(), this.filter.getText(), this.negate.isSelected());
        } else if (CommonUtils.contains("rx, tx, port, fport, Size, size, pid, last", this.getColumn())) {
            this.action.checkNumber(this.getColumn(), this.filter.getText(), this.negate.isSelected());
        } else {
            this.action.checkWildcard(this.getColumn(), "*" + this.filter.getText() + "*", this.negate.isSelected());
        }
        ((GenericTableModel)this.table.getModel()).apply(this.action);
        this.filter.setText("");
        this.negate.setSelected(false);
        this.status.setText(this.action.toString() + " applied.");
    }

    @Override
    public void requestFocus() {
        this.filter.requestFocus();
    }

    public void clear() {
        this.status.setText("");
        this.desc = new StringBuffer();
        ((GenericTableModel)this.table.getModel()).reset();
    }

    public FilterPanel(ATable aTable) {
        this.table = aTable;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        List list = CommonUtils.toList(((GenericTableModel)aTable.getModel()).getColumnNames());
        list.remove(" ");
        list.remove("D");
        list.remove("date");
        list.remove("Modified");
        list.remove("last");
        list.remove("added");
        list.add(0, "*");
        this.cols = new JComboBox<String>(CommonUtils.toArray(list));
        this.filter = new JTextField(15);
        this.filter.addActionListener(this);
        JButton jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterPanel.this.action.reset();
                FilterPanel.this.clear();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel("Filter: "));
        jPanel.add(this.negate);
        jPanel.add(this.filter);
        jPanel.add(this.cols);
        this.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(jButton);
        this.add((Component)jPanel2, "East");
        this.status = new JLabel("");
        this.add((Component)this.status, "Center");
        this.negate.setToolTipText("Negate this filter.");
    }
}

