/*
 * Decompiled with CFR 0.152.
 */
package tunnel;

import aggressor.AggressorClient;
import common.AObject;
import common.CommonUtils;
import common.MudgeSanity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;
import socks.BeaconProxyListener;
import tunnel.TunnelMessage;

public class TunnelClient
extends AObject {
    protected BeaconProxyListener messages;
    protected _B reader = null;
    protected _A writer = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected Socket socket = null;
    protected AggressorClient client;
    protected int chid;
    protected String bid;
    protected boolean alive = false;

    public TunnelClient(AggressorClient aggressorClient, String string, int n) {
        this.bid = string;
        this.chid = n;
        this.client = aggressorClient;
        this.messages = new BeaconProxyListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        TunnelClient tunnelClient = this;
        synchronized (tunnelClient) {
            return this.alive && this.socket.isConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        Object object = this;
        synchronized (object) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                this.in = null;
                this.out = null;
                this.socket = null;
            }
            catch (IOException iOException) {
                MudgeSanity.logException("TunnelClient die() [socket]", iOException, false);
            }
        }
        try {
            object = this.messages.closeMessage(this.chid);
            this.client.getConnection().call("beacons.task_pivot", CommonUtils.args(this.bid, object));
        }
        catch (IOException iOException) {
            MudgeSanity.logException("TunnelClient die() [message]", iOException, false);
        }
    }

    public void start(String string, int n) {
        this.writer = new _A(string, n);
        new Thread((Runnable)this.writer, "Tunnel Client Writer " + string + ":" + n).start();
    }

    public boolean isTarget(TunnelMessage tunnelMessage) {
        return this.chid == tunnelMessage.getSocketID() && this.bid.equals(tunnelMessage.getBeaconID());
    }

    public void write(byte[] byArray) {
        this.writer.A(byArray);
    }

    public void fireRead(byte[] byArray, int n) {
        try {
            byte[] byArray2 = this.messages.writeMessage(this.chid, byArray, n);
            this.client.getConnection().call("beacons.task_pivot", CommonUtils.args(this.bid, byArray2));
        }
        catch (IOException iOException) {
            MudgeSanity.logException("TunnelClient fireRead: " + n, iOException, false);
        }
    }

    private class _A
    implements Runnable {
        protected String B;
        protected int C;
        protected LinkedList D = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] A() {
            _A _A2 = this;
            synchronized (_A2) {
                return (byte[])this.D.pollFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void A(byte[] byArray) {
            _A _A2 = this;
            synchronized (_A2) {
                if (this.D.size() > 1000) {
                    CommonUtils.print_error("tunnel for " + this.B + ":" + this.C + " has 1,000 accumulated reads. Probably dead. Closing.");
                    TunnelClient.this.die();
                    return;
                }
                this.D.add(byArray);
            }
        }

        public _A(String string, int n) {
            this.B = string;
            this.C = n;
        }

        @Override
        public void run() {
            try {
                TunnelClient.this.socket = new Socket(this.B, this.C);
                TunnelClient.this.socket.setKeepAlive(true);
                TunnelClient.this.socket.setSoTimeout(0);
                TunnelClient.this.alive = true;
                TunnelClient.this.in = TunnelClient.this.socket.getInputStream();
                TunnelClient.this.out = TunnelClient.this.socket.getOutputStream();
                TunnelClient.this.reader = new _B();
                new Thread((Runnable)TunnelClient.this.reader, "Tunnel Client Reader " + this.B + ":" + this.C).start();
            }
            catch (IOException iOException) {
                MudgeSanity.logException("Failed to connect to " + this.B + ":" + this.C, iOException, false);
                TunnelClient.this.die();
                return;
            }
            try {
                while (TunnelClient.this.isAlive()) {
                    byte[] byArray = this.A();
                    if (byArray != null) {
                        TunnelClient.this.out.write(byArray, 0, byArray.length);
                        TunnelClient.this.out.flush();
                        Thread.yield();
                        continue;
                    }
                    CommonUtils.sleep(25L);
                }
            }
            catch (IOException iOException) {
                TunnelClient.this.die();
            }
        }
    }

    private class _B
    implements Runnable {
        @Override
        public void run() {
            try {
                byte[] byArray = new byte[65536];
                int n = 0;
                while (TunnelClient.this.isAlive() && (n = TunnelClient.this.in.read(byArray)) != -1) {
                    TunnelClient.this.fireRead(byArray, n);
                    Thread.yield();
                }
                TunnelClient.this.die();
            }
            catch (IOException iOException) {
                TunnelClient.this.die();
            }
        }
    }
}

