/*
 * Decompiled with CFR 0.152.
 */
package tunnel;

import aggressor.AggressorClient;
import common.Callback;
import common.CommonUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import tunnel.Accept;
import tunnel.Die;
import tunnel.TunnelClient;
import tunnel.TunnelMessage;
import tunnel.Write;

public class TunnelManager
implements Callback {
    protected AggressorClient client;
    protected List clients;
    protected Set allowlist;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allow(String string, int n) {
        TunnelManager tunnelManager = this;
        synchronized (tunnelManager) {
            this.allowlist.add(string + ":" + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowListed(String string, int n) {
        TunnelManager tunnelManager = this;
        synchronized (tunnelManager) {
            return this.allowlist.contains(string + ":" + n);
        }
    }

    public TunnelManager(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        this.clients = new LinkedList();
        this.allowlist = new HashSet();
    }

    public void init() {
        this.client.getData().subscribe("tunnel", this);
    }

    @Override
    public void result(String string, Object object) {
        if (object instanceof Accept) {
            Accept accept = (Accept)object;
            if (!this.isAllowListed(accept.getHost(), accept.getPort())) {
                CommonUtils.print_error("Received accept command for " + accept.getHost() + ":" + accept.getPort() + " tunnel to " + accept.getBeaconID() + ". Not in allow list. Rejecting.");
                return;
            }
            TunnelClient tunnelClient = new TunnelClient(this.client, accept.getBeaconID(), accept.getSocketID());
            tunnelClient.start(accept.getHost(), accept.getPort());
            this.clients.add(tunnelClient);
        } else {
            TunnelMessage tunnelMessage = (TunnelMessage)object;
            Iterator iterator = this.clients.iterator();
            while (iterator.hasNext()) {
                TunnelClient tunnelClient = (TunnelClient)iterator.next();
                if (!tunnelClient.isTarget(tunnelMessage)) continue;
                if (tunnelMessage instanceof Write) {
                    byte[] byArray = ((Write)tunnelMessage).getData();
                    tunnelClient.write(byArray);
                    continue;
                }
                if (!(tunnelMessage instanceof Die)) continue;
                tunnelClient.die();
                iterator.remove();
            }
        }
        Thread.yield();
    }
}

