/*
 * Decompiled with CFR 0.152.
 */
package ui;

import aggressor.ui.UseSynthetica;
import common.CommonUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import ui.CutCopyPastePopup;
import ui.GenericTableModel;
import ui.TableClickListener;
import ui.TablePopup;

public class ATable
extends JTable {
    protected boolean alternateBackground = false;
    protected TableClickListener clickl = new TableClickListener();
    protected int[] selected = null;
    public static final Color BACK_NEUTRAL = new Color(255, 235, 156);
    public static final Color BACK_GOOD = new Color(198, 239, 206);
    public static final Color BACK_BAD = new Color(255, 199, 206);
    public static final Color BACK_IGNORE = new Color(165, 165, 165);
    public static final Color BACK_CANCEL = new Color(61, 87, 158);
    public static final Color FORE_NEUTRAL = new Color(181, 107, 6);
    public static final Color FORE_GOOD = new Color(47, 75, 47);
    public static final Color FORE_BAD = new Color(173, 32, 40);
    public static final Color FORE_IGNORE = Color.WHITE;
    public static final Color FORE_CANCEL = Color.WHITE;
    private static final Color A = new Color(0xF7F7F9);

    public void markSelections() {
        this.selected = this.getSelectedRows();
    }

    public void setPopupMenu(TablePopup tablePopup) {
        this.clickl.setPopup(tablePopup);
    }

    public void fixSelection() {
        int n = this.getModel().getRowCount();
        if (this.selected.length == 0) {
            if (n > 0) {
                this.getSelectionModel().addSelectionInterval(0, 0);
            }
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        boolean bl = false;
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] >= n) continue;
            bl = true;
            this.getSelectionModel().addSelectionInterval(this.selected[i], this.selected[i]);
        }
        if (!bl && n > 0) {
            this.getSelectionModel().addSelectionInterval(n - 1, n - 1);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
    }

    public void restoreSelections() {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                ATable.this.fixSelection();
            }
        });
    }

    public static TableCellRenderer getFileTypeTableRenderer(final GenericTableModel genericTableModel) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, "", bl, false, n, n2);
                ((JLabel)jComponent).setEnabled(true);
                if ("dir".equals(object)) {
                    ((JLabel)jComponent).setIcon(UIManager.getIcon("FileView.directoryIcon"));
                    if (genericTableModel.getValueAt(jTable, n, "cache") == Boolean.FALSE) {
                        ((JLabel)jComponent).setEnabled(false);
                    }
                } else if ("drive".equals(object)) {
                    ((JLabel)jComponent).setIcon(UIManager.getIcon("FileView.hardDriveIcon"));
                } else {
                    ((JLabel)jComponent).setIcon(UIManager.getIcon("FileView.fileIcon"));
                }
                return jComponent;
            }
        };
    }

    public static TableCellRenderer getListenerStatusRenderer(final GenericTableModel genericTableModel) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JLabel jLabel = (JLabel)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                Object object2 = genericTableModel.getValueAt(jTable, n, "status");
                if (object2 == null || "".equals(object2) || "success".equals(object2)) {
                    jLabel.setFont(jLabel.getFont().deriveFont(0));
                } else {
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                    jLabel.setText("ERROR! " + jLabel.getText() + " - " + object2);
                }
                return jLabel;
            }
        };
    }

    public static TableCellRenderer getClientStatusRenderer(GenericTableModel genericTableModel) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JLabel jLabel = (JLabel)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                String string = jLabel.getText();
                if (string == null || "".equals(string) || !string.startsWith("DISCONNECTED!")) {
                    jLabel.setFont(jLabel.getFont().deriveFont(0));
                } else {
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                }
                return jLabel;
            }
        };
    }

    public static TableCellRenderer getBoldOnKeyRenderer(final GenericTableModel genericTableModel, final String string) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JLabel jLabel = (JLabel)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (genericTableModel.getValueAt(jTable, n, string) == Boolean.TRUE) {
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                } else {
                    jLabel.setFont(jLabel.getFont().deriveFont(0));
                }
                return jLabel;
            }
        };
    }

    public static TableCellRenderer getSimpleTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                ((JLabel)jComponent).setIcon(null);
                return jComponent;
            }
        };
    }

    public static TableCellRenderer getSizeTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, "", bl, false, n, n2);
                try {
                    long l = Long.parseLong(object + "");
                    String string = "b";
                    if (l > 1024L) {
                        l /= 1024L;
                        string = "kb";
                    }
                    if (l > 1024L) {
                        l /= 1024L;
                        string = "mb";
                    }
                    if (l > 1024L) {
                        l /= 1024L;
                        string = "gb";
                    }
                    ((JLabel)jComponent).setText(l + string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jComponent;
            }
        };
    }

    public static TableCellRenderer getLastTableRenderer(final GenericTableModel genericTableModel) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, "", bl, false, n, n2);
                try {
                    long l = Long.parseLong(object + "");
                    String string = "ms";
                    if (l <= 1000L) {
                        ((JLabel)jComponent).setText(l + string);
                        return jComponent;
                    }
                    string = "s";
                    if ((l /= 1000L) > 60L) {
                        l /= 60L;
                        string = "m";
                    }
                    if (l > 60L) {
                        l /= 60L;
                        string = "h";
                    }
                    JLabel jLabel = (JLabel)jComponent;
                    jLabel.setText(l + string);
                    Object object2 = genericTableModel.getValueAt(jTable, n, "checkinstate");
                    if (object2 != null && object2 instanceof Boolean) {
                        Boolean bl3 = (Boolean)object2;
                        if (!bl3.booleanValue()) {
                            jLabel.setFont(jLabel.getFont().deriveFont(3));
                        } else {
                            jLabel.setFont(jLabel.getFont().deriveFont(0));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jComponent;
            }
        };
    }

    public static TableCellRenderer getTimeSleepRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, "", bl, false, n, n2);
                try {
                    Object[] objectArray = (Object[])object;
                    long l = Long.parseLong(objectArray[0] + "");
                    long l2 = Long.parseLong(objectArray[1] + "");
                    boolean bl3 = Boolean.parseBoolean(objectArray[2] + "");
                    String string = "Unknown";
                    if (l == 0L || !bl3) {
                        string = "Interactive";
                    } else if (l > 0L) {
                        long l3 = l / 86400L;
                        long l4 = l % 86400L / 3600L;
                        long l5 = l % 3600L / 60L;
                        long l6 = l % 60L;
                        StringBuilder stringBuilder = new StringBuilder();
                        if (l3 != 0L) {
                            stringBuilder.append(String.format(" %d day", l3));
                            if (l3 > 1L) {
                                stringBuilder.append("s");
                            }
                        }
                        if (l4 != 0L) {
                            stringBuilder.append(String.format(" %d hour", l4));
                            if (l4 > 1L) {
                                stringBuilder.append("s");
                            }
                        }
                        if (l5 != 0L) {
                            stringBuilder.append(String.format(" %d minute", l5));
                            if (l5 > 1L) {
                                stringBuilder.append("s");
                            }
                        }
                        if (l6 != 0L) {
                            stringBuilder.append(String.format(" %d second", l6));
                            if (l6 > 1L) {
                                stringBuilder.append("s");
                            }
                        }
                        if (l2 > 0L && l2 < 100L) {
                            stringBuilder.append(String.format(" (%d%% jitter)", l2));
                        }
                        string = stringBuilder.toString();
                    }
                    ((JLabel)jComponent).setText(string);
                    ((JLabel)jComponent).setToolTipText(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jComponent;
            }
        };
    }

    public static TableCellRenderer getUserRenderer(final GenericTableModel genericTableModel) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, "", bl, false, n, n2);
                String string = (String)object;
                String string2 = (String)genericTableModel.getValueAt(jTable, n, "impersonated");
                if (string2 != null && !string2.equals("")) {
                    string = string + " [" + string2 + "]";
                }
                ((JLabel)jComponent).setText(string);
                return jComponent;
            }
        };
    }

    public static TableCellRenderer getImageTableRenderer(final GenericTableModel genericTableModel, final String string) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)jTable.getDefaultRenderer(Object.class).getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                ImageIcon imageIcon = (ImageIcon)genericTableModel.getValueAt(jTable, n, string);
                if (imageIcon != null) {
                    jLabel.setIcon(imageIcon);
                    jLabel.setText("");
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText("");
                }
                return jLabel;
            }
        };
    }

    public static TableCellRenderer getImageAndTextTableRenderer(final GenericTableModel genericTableModel, final String string) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)jTable.getDefaultRenderer(Object.class).getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                ImageIcon imageIcon = (ImageIcon)genericTableModel.getValueAt(jTable, n, string);
                if (imageIcon != null) {
                    jLabel.setIcon(imageIcon);
                    jLabel.setText(object + "");
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText(object + "");
                }
                return jLabel;
            }
        };
    }

    public static TableCellRenderer getDateTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(String.class);
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, "", bl, false, n, n2);
                try {
                    long l = Long.parseLong(object + "");
                    ((JLabel)jComponent).setText(CommonUtils.formatDate(l));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jComponent;
            }
        };
    }

    public void adjust() {
        this.setOpaque(true);
        this.addMouseListener(this.clickl);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(this.getRowHeight() + 2);
        final TableCellEditor tableCellEditor = this.getDefaultEditor(Object.class);
        this.setDefaultEditor(Object.class, new TableCellEditor(){

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = tableCellEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
                if (component instanceof JTextComponent) {
                    new CutCopyPastePopup((JTextComponent)component);
                }
                return component;
            }

            @Override
            public void addCellEditorListener(CellEditorListener cellEditorListener) {
                tableCellEditor.addCellEditorListener(cellEditorListener);
            }

            @Override
            public void cancelCellEditing() {
                tableCellEditor.cancelCellEditing();
            }

            @Override
            public Object getCellEditorValue() {
                return tableCellEditor.getCellEditorValue();
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                return tableCellEditor.isCellEditable(eventObject);
            }

            @Override
            public void removeCellEditorListener(CellEditorListener cellEditorListener) {
                tableCellEditor.removeCellEditorListener(cellEditorListener);
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                return tableCellEditor.shouldSelectCell(eventObject);
            }

            @Override
            public boolean stopCellEditing() {
                return tableCellEditor.stopCellEditing();
            }
        });
        final TableCellRenderer tableCellRenderer = this.getDefaultRenderer(Object.class);
        this.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object == null) {
                    object = "";
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                Object object2 = ((GenericTableModel)jTable.getModel()).getValueAtColumn(jTable, n, "_accent");
                if (!bl) {
                    if ("neutral".equals(object2)) {
                        component.setForeground(FORE_NEUTRAL);
                        component.setBackground(BACK_NEUTRAL);
                    } else if ("bad".equals(object2)) {
                        component.setForeground(FORE_BAD);
                        component.setBackground(BACK_BAD);
                    } else if ("good".equals(object2)) {
                        component.setForeground(FORE_GOOD);
                        component.setBackground(BACK_GOOD);
                    } else if ("ignore".equals(object2)) {
                        component.setForeground(FORE_IGNORE);
                        component.setBackground(BACK_IGNORE);
                    } else if ("cancel".equals(object2)) {
                        component.setForeground(FORE_CANCEL);
                        component.setBackground(BACK_CANCEL);
                    } else if (!UseSynthetica.isUsingDarkMode().booleanValue()) {
                        component.setForeground(Color.BLACK);
                        component.setBackground(ATable.this.alternateBackground ? A : Color.WHITE);
                    }
                } else if ("neutral".equals(object2)) {
                    component.setForeground(BACK_NEUTRAL);
                } else if ("bad".equals(object2)) {
                    component.setForeground(BACK_BAD);
                } else if ("good".equals(object2)) {
                    component.setForeground(BACK_GOOD);
                } else if ("ignore".equals(object2)) {
                    component.setForeground(BACK_IGNORE);
                } else if ("cancel".equals(object2)) {
                    component.setForeground(BACK_CANCEL);
                }
                return component;
            }
        });
    }

    public ATable() {
        this.adjust();
    }

    public ATable(TableModel tableModel) {
        super(tableModel);
        this.adjust();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        this.alternateBackground = n % 2 == 0;
        return super.prepareRenderer(tableCellRenderer, n, n2);
    }

    public Color getComponentBackground() {
        return this.alternateBackground ? new Color(0xF7F7F9) : Color.WHITE;
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.getActionMap().put(keyStroke.toString(), action);
        this.getInputMap().put(keyStroke, keyStroke.toString());
    }

    public void addActionForKey(String string, Action action) {
        this.addActionForKeyStroke(KeyStroke.getKeyStroke(string), action);
    }

    public BufferedImage getScreenshot() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 6);
        Graphics graphics = bufferedImage.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        return bufferedImage;
    }
}

