/*
 * Decompiled with CFR 0.152.
 */
package ui;

import common.CommonUtils;
import dialog.SolidIcon;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import ui.ATable;

public class ColorPanel
extends JPanel {
    protected LinkedList buttons = new LinkedList();
    protected Map fcolors = new HashMap();
    protected Map bcolors = new HashMap();

    public ColorPanel() {
        this.setLayout(new FlowLayout(0));
        this.add(" ", "", Color.BLACK, Color.WHITE);
        this.add("G", "good", ATable.FORE_GOOD, ATable.BACK_GOOD);
        this.add("B", "bad", ATable.FORE_BAD, ATable.BACK_BAD);
        this.add("N", "neutral", ATable.FORE_NEUTRAL, ATable.BACK_NEUTRAL);
        this.add("I", "ignore", ATable.FORE_IGNORE, ATable.BACK_IGNORE);
        this.add("C", "cancel", ATable.FORE_CANCEL, ATable.BACK_CANCEL);
    }

    public static boolean isColorAction(String string) {
        Set set = CommonUtils.toSet("good, bad, neutral, ignore, cancel");
        set.add("");
        return set.contains(string);
    }

    public Color getForeColor(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        return (Color)this.fcolors.get(string);
    }

    public Color getBackColor(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        return (Color)this.bcolors.get(string);
    }

    public void addActionListener(ActionListener actionListener) {
        for (JButton jButton : this.buttons) {
            jButton.addActionListener(actionListener);
        }
    }

    public void add(String string, String string2, Color color, Color color2) {
        JButton jButton = new JButton("");
        jButton.setIcon(new SolidIcon(color2, 16, 16));
        jButton.setForeground(color);
        jButton.setBackground(color2);
        jButton.setOpaque(false);
        jButton.setActionCommand(string2);
        this.fcolors.put(string2, color);
        this.bcolors.put(string2, color2);
        this.add(jButton);
        this.buttons.add(jButton);
    }
}

